/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricWidgetImageRequest extends CloudWatchRequest implements
        ToCopyableBuilder<GetMetricWidgetImageRequest.Builder, GetMetricWidgetImageRequest> {
    private static final SdkField<String> METRIC_WIDGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricWidget").getter(getter(GetMetricWidgetImageRequest::metricWidget))
            .setter(setter(Builder::metricWidget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricWidget").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(GetMetricWidgetImageRequest::outputFormat))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_WIDGET_FIELD,
            OUTPUT_FORMAT_FIELD));

    private final String metricWidget;

    private final String outputFormat;

    private GetMetricWidgetImageRequest(BuilderImpl builder) {
        super(builder);
        this.metricWidget = builder.metricWidget;
        this.outputFormat = builder.outputFormat;
    }

    /**
     * <p>
     * A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in the
     * graph, statistics, annotations, title, axis limits, and so on. You can include only one <code>MetricWidget</code>
     * parameter in each <code>GetMetricWidgetImage</code> call.
     * </p>
     * <p>
     * For more information about the syntax of <code>MetricWidget</code> see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html"
     * >GetMetricWidgetImage: Metric Widget Structure and Syntax</a>.
     * </p>
     * <p>
     * If any metric on the graph could not load all the requested data points, an orange triangle with an exclamation
     * point appears next to the graph legend.
     * </p>
     * 
     * @return A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include
     *         in the graph, statistics, annotations, title, axis limits, and so on. You can include only one
     *         <code>MetricWidget</code> parameter in each <code>GetMetricWidgetImage</code> call.</p>
     *         <p>
     *         For more information about the syntax of <code>MetricWidget</code> see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html"
     *         >GetMetricWidgetImage: Metric Widget Structure and Syntax</a>.
     *         </p>
     *         <p>
     *         If any metric on the graph could not load all the requested data points, an orange triangle with an
     *         exclamation point appears next to the graph legend.
     */
    public final String metricWidget() {
        return metricWidget;
    }

    /**
     * <p>
     * The format of the resulting image. Only PNG images are supported.
     * </p>
     * <p>
     * The default is <code>png</code>. If you specify <code>png</code>, the API returns an HTTP response with the
     * content-type set to <code>text/xml</code>. The image data is in a <code>MetricWidgetImage</code> field. For
     * example:
     * </p>
     * <p>
     * <code> &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;</code>
     * </p>
     * <p>
     * <code> &lt;GetMetricWidgetImageResult&gt;</code>
     * </p>
     * <p>
     * <code> &lt;MetricWidgetImage&gt;</code>
     * </p>
     * <p>
     * <code> iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...</code>
     * </p>
     * <p>
     * <code> &lt;/MetricWidgetImage&gt;</code>
     * </p>
     * <p>
     * <code> &lt;/GetMetricWidgetImageResult&gt;</code>
     * </p>
     * <p>
     * <code> &lt;ResponseMetadata&gt;</code>
     * </p>
     * <p>
     * <code> &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;</code>
     * </p>
     * <p>
     * <code> &lt;/ResponseMetadata&gt;</code>
     * </p>
     * <p>
     * <code>&lt;/GetMetricWidgetImageResponse&gt;</code>
     * </p>
     * <p>
     * The <code>image/png</code> setting is intended only for custom HTTP requests. For most use cases, and all actions
     * using an AWS SDK, you should use <code>png</code>. If you specify <code>image/png</code>, the HTTP response has a
     * content-type set to <code>image/png</code>, and the body of the response is a PNG image.
     * </p>
     * 
     * @return The format of the resulting image. Only PNG images are supported.</p>
     *         <p>
     *         The default is <code>png</code>. If you specify <code>png</code>, the API returns an HTTP response with
     *         the content-type set to <code>text/xml</code>. The image data is in a <code>MetricWidgetImage</code>
     *         field. For example:
     *         </p>
     *         <p>
     *         <code> &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;GetMetricWidgetImageResult&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;MetricWidgetImage&gt;</code>
     *         </p>
     *         <p>
     *         <code> iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...</code>
     *         </p>
     *         <p>
     *         <code> &lt;/MetricWidgetImage&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;/GetMetricWidgetImageResult&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;ResponseMetadata&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;</code>
     *         </p>
     *         <p>
     *         <code> &lt;/ResponseMetadata&gt;</code>
     *         </p>
     *         <p>
     *         <code>&lt;/GetMetricWidgetImageResponse&gt;</code>
     *         </p>
     *         <p>
     *         The <code>image/png</code> setting is intended only for custom HTTP requests. For most use cases, and all
     *         actions using an AWS SDK, you should use <code>png</code>. If you specify <code>image/png</code>, the
     *         HTTP response has a content-type set to <code>image/png</code>, and the body of the response is a PNG
     *         image.
     */
    public final String outputFormat() {
        return outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricWidget());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricWidgetImageRequest)) {
            return false;
        }
        GetMetricWidgetImageRequest other = (GetMetricWidgetImageRequest) obj;
        return Objects.equals(metricWidget(), other.metricWidget()) && Objects.equals(outputFormat(), other.outputFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricWidgetImageRequest").add("MetricWidget", metricWidget())
                .add("OutputFormat", outputFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricWidget":
            return Optional.ofNullable(clazz.cast(metricWidget()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricWidgetImageRequest, T> g) {
        return obj -> g.apply((GetMetricWidgetImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricWidgetImageRequest> {
        /**
         * <p>
         * A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in
         * the graph, statistics, annotations, title, axis limits, and so on. You can include only one
         * <code>MetricWidget</code> parameter in each <code>GetMetricWidgetImage</code> call.
         * </p>
         * <p>
         * For more information about the syntax of <code>MetricWidget</code> see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html"
         * >GetMetricWidgetImage: Metric Widget Structure and Syntax</a>.
         * </p>
         * <p>
         * If any metric on the graph could not load all the requested data points, an orange triangle with an
         * exclamation point appears next to the graph legend.
         * </p>
         * 
         * @param metricWidget
         *        A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to
         *        include in the graph, statistics, annotations, title, axis limits, and so on. You can include only one
         *        <code>MetricWidget</code> parameter in each <code>GetMetricWidgetImage</code> call.</p>
         *        <p>
         *        For more information about the syntax of <code>MetricWidget</code> see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html"
         *        >GetMetricWidgetImage: Metric Widget Structure and Syntax</a>.
         *        </p>
         *        <p>
         *        If any metric on the graph could not load all the requested data points, an orange triangle with an
         *        exclamation point appears next to the graph legend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricWidget(String metricWidget);

        /**
         * <p>
         * The format of the resulting image. Only PNG images are supported.
         * </p>
         * <p>
         * The default is <code>png</code>. If you specify <code>png</code>, the API returns an HTTP response with the
         * content-type set to <code>text/xml</code>. The image data is in a <code>MetricWidgetImage</code> field. For
         * example:
         * </p>
         * <p>
         * <code> &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;</code>
         * </p>
         * <p>
         * <code> &lt;GetMetricWidgetImageResult&gt;</code>
         * </p>
         * <p>
         * <code> &lt;MetricWidgetImage&gt;</code>
         * </p>
         * <p>
         * <code> iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...</code>
         * </p>
         * <p>
         * <code> &lt;/MetricWidgetImage&gt;</code>
         * </p>
         * <p>
         * <code> &lt;/GetMetricWidgetImageResult&gt;</code>
         * </p>
         * <p>
         * <code> &lt;ResponseMetadata&gt;</code>
         * </p>
         * <p>
         * <code> &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;</code>
         * </p>
         * <p>
         * <code> &lt;/ResponseMetadata&gt;</code>
         * </p>
         * <p>
         * <code>&lt;/GetMetricWidgetImageResponse&gt;</code>
         * </p>
         * <p>
         * The <code>image/png</code> setting is intended only for custom HTTP requests. For most use cases, and all
         * actions using an AWS SDK, you should use <code>png</code>. If you specify <code>image/png</code>, the HTTP
         * response has a content-type set to <code>image/png</code>, and the body of the response is a PNG image.
         * </p>
         * 
         * @param outputFormat
         *        The format of the resulting image. Only PNG images are supported.</p>
         *        <p>
         *        The default is <code>png</code>. If you specify <code>png</code>, the API returns an HTTP response
         *        with the content-type set to <code>text/xml</code>. The image data is in a
         *        <code>MetricWidgetImage</code> field. For example:
         *        </p>
         *        <p>
         *        <code> &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;GetMetricWidgetImageResult&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;MetricWidgetImage&gt;</code>
         *        </p>
         *        <p>
         *        <code> iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...</code>
         *        </p>
         *        <p>
         *        <code> &lt;/MetricWidgetImage&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;/GetMetricWidgetImageResult&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;ResponseMetadata&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;</code>
         *        </p>
         *        <p>
         *        <code> &lt;/ResponseMetadata&gt;</code>
         *        </p>
         *        <p>
         *        <code>&lt;/GetMetricWidgetImageResponse&gt;</code>
         *        </p>
         *        <p>
         *        The <code>image/png</code> setting is intended only for custom HTTP requests. For most use cases, and
         *        all actions using an AWS SDK, you should use <code>png</code>. If you specify <code>image/png</code>,
         *        the HTTP response has a content-type set to <code>image/png</code>, and the body of the response is a
         *        PNG image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFormat(String outputFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String metricWidget;

        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricWidgetImageRequest model) {
            super(model);
            metricWidget(model.metricWidget);
            outputFormat(model.outputFormat);
        }

        public final String getMetricWidget() {
            return metricWidget;
        }

        @Override
        public final Builder metricWidget(String metricWidget) {
            this.metricWidget = metricWidget;
            return this;
        }

        public final void setMetricWidget(String metricWidget) {
            this.metricWidget = metricWidget;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricWidgetImageRequest build() {
            return new GetMetricWidgetImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
