/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetricStreamRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutMetricStreamRequest.Builder, PutMetricStreamRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutMetricStreamRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<MetricStreamFilter>> INCLUDE_FILTERS_FIELD = SdkField
            .<List<MetricStreamFilter>> builder(MarshallingType.LIST)
            .memberName("IncludeFilters")
            .getter(getter(PutMetricStreamRequest::includeFilters))
            .setter(setter(Builder::includeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricStreamFilter>> EXCLUDE_FILTERS_FIELD = SdkField
            .<List<MetricStreamFilter>> builder(MarshallingType.LIST)
            .memberName("ExcludeFilters")
            .getter(getter(PutMetricStreamRequest::excludeFilters))
            .setter(setter(Builder::excludeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirehoseArn").getter(getter(PutMetricStreamRequest::firehoseArn)).setter(setter(Builder::firehoseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(PutMetricStreamRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(PutMetricStreamRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutMetricStreamRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INCLUDE_FILTERS_FIELD, EXCLUDE_FILTERS_FIELD, FIREHOSE_ARN_FIELD, ROLE_ARN_FIELD, OUTPUT_FORMAT_FIELD, TAGS_FIELD));

    private final String name;

    private final List<MetricStreamFilter> includeFilters;

    private final List<MetricStreamFilter> excludeFilters;

    private final String firehoseArn;

    private final String roleArn;

    private final String outputFormat;

    private final List<Tag> tags;

    private PutMetricStreamRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.includeFilters = builder.includeFilters;
        this.excludeFilters = builder.excludeFilters;
        this.firehoseArn = builder.firehoseArn;
        this.roleArn = builder.roleArn;
        this.outputFormat = builder.outputFormat;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * If you are creating a new metric stream, this is the name for the new stream. The name must be different than the
     * names of other metric streams in this account and Region.
     * </p>
     * <p>
     * If you are updating a metric stream, specify the name of that stream here.
     * </p>
     * <p>
     * Valid characters are A-Z, a-z, 0-9, "-" and "_".
     * </p>
     * 
     * @return If you are creating a new metric stream, this is the name for the new stream. The name must be different
     *         than the names of other metric streams in this account and Region.</p>
     *         <p>
     *         If you are updating a metric stream, specify the name of that stream here.
     *         </p>
     *         <p>
     *         Valid characters are A-Z, a-z, 0-9, "-" and "_".
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the IncludeFilters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIncludeFilters() {
        return includeFilters != null && !(includeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify
     * here.
     * </p>
     * <p>
     * You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If you specify this parameter, the stream sends only the metrics from the metric namespaces that you
     *         specify here.</p>
     *         <p>
     *         You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
     */
    public final List<MetricStreamFilter> includeFilters() {
        return includeFilters;
    }

    /**
     * Returns true if the ExcludeFilters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExcludeFilters() {
        return excludeFilters != null && !(excludeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that
     * you specify here.
     * </p>
     * <p>
     * You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludeFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If you specify this parameter, the stream sends metrics from all metric namespaces except for the
     *         namespaces that you specify here.</p>
     *         <p>
     *         You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
     */
    public final List<MetricStreamFilter> excludeFilters() {
        return excludeFilters;
    }

    /**
     * <p>
     * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis
     * Firehose delivery stream must already exist and must be in the same account as the metric stream.
     * </p>
     * 
     * @return The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis
     *         Firehose delivery stream must already exist and must be in the same account as the metric stream.
     */
    public final String firehoseArn() {
        return firehoseArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This IAM
     * role must already exist and must be in the same account as the metric stream. This IAM role must include the
     * following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * firehose:PutRecord
     * </p>
     * </li>
     * <li>
     * <p>
     * firehose:PutRecordBatch
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This
     *         IAM role must already exist and must be in the same account as the metric stream. This IAM role must
     *         include the following permissions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         firehose:PutRecord
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         firehose:PutRecordBatch
     *         </p>
     *         </li>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>. For more
     * information about metric stream output formats, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
     * Metric streams output formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>.
     *         For more information about metric stream output formats, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
     *         Metric streams output formats</a>.
     * @see MetricStreamOutputFormat
     */
    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>. For more
     * information about metric stream output formats, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
     * Metric streams output formats</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link MetricStreamOutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>.
     *         For more information about metric stream output formats, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
     *         Metric streams output formats</a>.
     * @see MetricStreamOutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a metric
     * stream.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with
     *         a metric stream.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeFilters() ? includeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeFilters() ? excludeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricStreamRequest)) {
            return false;
        }
        PutMetricStreamRequest other = (PutMetricStreamRequest) obj;
        return Objects.equals(name(), other.name()) && hasIncludeFilters() == other.hasIncludeFilters()
                && Objects.equals(includeFilters(), other.includeFilters()) && hasExcludeFilters() == other.hasExcludeFilters()
                && Objects.equals(excludeFilters(), other.excludeFilters()) && Objects.equals(firehoseArn(), other.firehoseArn())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMetricStreamRequest").add("Name", name())
                .add("IncludeFilters", hasIncludeFilters() ? includeFilters() : null)
                .add("ExcludeFilters", hasExcludeFilters() ? excludeFilters() : null).add("FirehoseArn", firehoseArn())
                .add("RoleArn", roleArn()).add("OutputFormat", outputFormatAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IncludeFilters":
            return Optional.ofNullable(clazz.cast(includeFilters()));
        case "ExcludeFilters":
            return Optional.ofNullable(clazz.cast(excludeFilters()));
        case "FirehoseArn":
            return Optional.ofNullable(clazz.cast(firehoseArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricStreamRequest, T> g) {
        return obj -> g.apply((PutMetricStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetricStreamRequest> {
        /**
         * <p>
         * If you are creating a new metric stream, this is the name for the new stream. The name must be different than
         * the names of other metric streams in this account and Region.
         * </p>
         * <p>
         * If you are updating a metric stream, specify the name of that stream here.
         * </p>
         * <p>
         * Valid characters are A-Z, a-z, 0-9, "-" and "_".
         * </p>
         * 
         * @param name
         *        If you are creating a new metric stream, this is the name for the new stream. The name must be
         *        different than the names of other metric streams in this account and Region.</p>
         *        <p>
         *        If you are updating a metric stream, specify the name of that stream here.
         *        </p>
         *        <p>
         *        Valid characters are A-Z, a-z, 0-9, "-" and "_".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify
         * here.
         * </p>
         * <p>
         * You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
         * </p>
         * 
         * @param includeFilters
         *        If you specify this parameter, the stream sends only the metrics from the metric namespaces that you
         *        specify here.</p>
         *        <p>
         *        You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilters(Collection<MetricStreamFilter> includeFilters);

        /**
         * <p>
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify
         * here.
         * </p>
         * <p>
         * You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
         * </p>
         * 
         * @param includeFilters
         *        If you specify this parameter, the stream sends only the metrics from the metric namespaces that you
         *        specify here.</p>
         *        <p>
         *        You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFilters(MetricStreamFilter... includeFilters);

        /**
         * <p>
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify
         * here.
         * </p>
         * <p>
         * You cannot include <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricStreamFilter>.Builder} avoiding the
         * need to create one manually via {@link List<MetricStreamFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricStreamFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #includeFilters(List<MetricStreamFilter>)}.
         * 
         * @param includeFilters
         *        a consumer that will call methods on {@link List<MetricStreamFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includeFilters(List<MetricStreamFilter>)
         */
        Builder includeFilters(Consumer<MetricStreamFilter.Builder>... includeFilters);

        /**
         * <p>
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces
         * that you specify here.
         * </p>
         * <p>
         * You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
         * </p>
         * 
         * @param excludeFilters
         *        If you specify this parameter, the stream sends metrics from all metric namespaces except for the
         *        namespaces that you specify here.</p>
         *        <p>
         *        You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters);

        /**
         * <p>
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces
         * that you specify here.
         * </p>
         * <p>
         * You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
         * </p>
         * 
         * @param excludeFilters
         *        If you specify this parameter, the stream sends metrics from all metric namespaces except for the
         *        namespaces that you specify here.</p>
         *        <p>
         *        You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilters(MetricStreamFilter... excludeFilters);

        /**
         * <p>
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces
         * that you specify here.
         * </p>
         * <p>
         * You cannot include <code>ExcludeFilters</code> and <code>IncludeFilters</code> in the same operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricStreamFilter>.Builder} avoiding the
         * need to create one manually via {@link List<MetricStreamFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricStreamFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #excludeFilters(List<MetricStreamFilter>)}.
         * 
         * @param excludeFilters
         *        a consumer that will call methods on {@link List<MetricStreamFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeFilters(List<MetricStreamFilter>)
         */
        Builder excludeFilters(Consumer<MetricStreamFilter.Builder>... excludeFilters);

        /**
         * <p>
         * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis
         * Firehose delivery stream must already exist and must be in the same account as the metric stream.
         * </p>
         * 
         * @param firehoseArn
         *        The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon
         *        Kinesis Firehose delivery stream must already exist and must be in the same account as the metric
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehoseArn(String firehoseArn);

        /**
         * <p>
         * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This IAM
         * role must already exist and must be in the same account as the metric stream. This IAM role must include the
         * following permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * firehose:PutRecord
         * </p>
         * </li>
         * <li>
         * <p>
         * firehose:PutRecordBatch
         * </p>
         * </li>
         * </ul>
         * 
         * @param roleArn
         *        The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources.
         *        This IAM role must already exist and must be in the same account as the metric stream. This IAM role
         *        must include the following permissions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        firehose:PutRecord
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        firehose:PutRecordBatch
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>. For
         * more information about metric stream output formats, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
         * Metric streams output formats</a>.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>
         *        . For more information about metric stream output formats, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         *        > Metric streams output formats</a>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>. For
         * more information about metric stream output formats, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">
         * Metric streams output formats</a>.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the stream. Valid values are <code>json</code> and <code>opentelemetry0.7</code>
         *        . For more information about metric stream output formats, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html"
         *        > Metric streams output formats</a>.
         * @see MetricStreamOutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStreamOutputFormat
         */
        Builder outputFormat(MetricStreamOutputFormat outputFormat);

        /**
         * <p>
         * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a
         * metric stream.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags
         *        with a metric stream.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a
         * metric stream.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags
         *        with a metric stream.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a
         * metric stream.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String name;

        private List<MetricStreamFilter> includeFilters = DefaultSdkAutoConstructList.getInstance();

        private List<MetricStreamFilter> excludeFilters = DefaultSdkAutoConstructList.getInstance();

        private String firehoseArn;

        private String roleArn;

        private String outputFormat;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricStreamRequest model) {
            super(model);
            name(model.name);
            includeFilters(model.includeFilters);
            excludeFilters(model.excludeFilters);
            firehoseArn(model.firehoseArn);
            roleArn(model.roleArn);
            outputFormat(model.outputFormat);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<MetricStreamFilter.Builder> getIncludeFilters() {
            if (includeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return includeFilters != null ? includeFilters.stream().map(MetricStreamFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder includeFilters(Collection<MetricStreamFilter> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copy(includeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(MetricStreamFilter... includeFilters) {
            includeFilters(Arrays.asList(includeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFilters(Consumer<MetricStreamFilter.Builder>... includeFilters) {
            includeFilters(Stream.of(includeFilters).map(c -> MetricStreamFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIncludeFilters(Collection<MetricStreamFilter.BuilderImpl> includeFilters) {
            this.includeFilters = MetricStreamFiltersCopier.copyFromBuilder(includeFilters);
        }

        public final Collection<MetricStreamFilter.Builder> getExcludeFilters() {
            if (excludeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeFilters != null ? excludeFilters.stream().map(MetricStreamFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludeFilters(Collection<MetricStreamFilter> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copy(excludeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(MetricStreamFilter... excludeFilters) {
            excludeFilters(Arrays.asList(excludeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilters(Consumer<MetricStreamFilter.Builder>... excludeFilters) {
            excludeFilters(Stream.of(excludeFilters).map(c -> MetricStreamFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExcludeFilters(Collection<MetricStreamFilter.BuilderImpl> excludeFilters) {
            this.excludeFilters = MetricStreamFiltersCopier.copyFromBuilder(excludeFilters);
        }

        public final String getFirehoseArn() {
            return firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricStreamRequest build() {
            return new PutMetricStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
