/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyDetectorsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAnomalyDetectorsResponse.Builder, DescribeAnomalyDetectorsResponse> {
    private static final SdkField<List<AnomalyDetector>> ANOMALY_DETECTORS_FIELD = SdkField
            .<List<AnomalyDetector>> builder(MarshallingType.LIST)
            .memberName("AnomalyDetectors")
            .getter(getter(DescribeAnomalyDetectorsResponse::anomalyDetectors))
            .setter(setter(Builder::anomalyDetectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnomalyDetector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnomalyDetector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAnomalyDetectorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AnomalyDetector> anomalyDetectors;

    private final String nextToken;

    private DescribeAnomalyDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectors = builder.anomalyDetectors;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AnomalyDetectors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAnomalyDetectors() {
        return anomalyDetectors != null && !(anomalyDetectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of anomaly detection models returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnomalyDetectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of anomaly detection models returned by the operation.
     */
    public final List<AnomalyDetector> anomalyDetectors() {
        return anomalyDetectors;
    }

    /**
     * <p>
     * A token that you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that you can use in a subsequent operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalyDetectors() ? anomalyDetectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorsResponse)) {
            return false;
        }
        DescribeAnomalyDetectorsResponse other = (DescribeAnomalyDetectorsResponse) obj;
        return hasAnomalyDetectors() == other.hasAnomalyDetectors()
                && Objects.equals(anomalyDetectors(), other.anomalyDetectors()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyDetectorsResponse")
                .add("AnomalyDetectors", hasAnomalyDetectors() ? anomalyDetectors() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectors":
            return Optional.ofNullable(clazz.cast(anomalyDetectors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorsResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnomalyDetectorsResponse> {
        /**
         * <p>
         * The list of anomaly detection models returned by the operation.
         * </p>
         * 
         * @param anomalyDetectors
         *        The list of anomaly detection models returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectors(Collection<AnomalyDetector> anomalyDetectors);

        /**
         * <p>
         * The list of anomaly detection models returned by the operation.
         * </p>
         * 
         * @param anomalyDetectors
         *        The list of anomaly detection models returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectors(AnomalyDetector... anomalyDetectors);

        /**
         * <p>
         * The list of anomaly detection models returned by the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnomalyDetector>.Builder} avoiding the need
         * to create one manually via {@link List<AnomalyDetector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnomalyDetector>.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalyDetectors(List<AnomalyDetector>)}.
         * 
         * @param anomalyDetectors
         *        a consumer that will call methods on {@link List<AnomalyDetector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetectors(List<AnomalyDetector>)
         */
        Builder anomalyDetectors(Consumer<AnomalyDetector.Builder>... anomalyDetectors);

        /**
         * <p>
         * A token that you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that you can use in a subsequent operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<AnomalyDetector> anomalyDetectors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorsResponse model) {
            super(model);
            anomalyDetectors(model.anomalyDetectors);
            nextToken(model.nextToken);
        }

        public final Collection<AnomalyDetector.Builder> getAnomalyDetectors() {
            if (anomalyDetectors instanceof SdkAutoConstructList) {
                return null;
            }
            return anomalyDetectors != null ? anomalyDetectors.stream().map(AnomalyDetector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder anomalyDetectors(Collection<AnomalyDetector> anomalyDetectors) {
            this.anomalyDetectors = AnomalyDetectorsCopier.copy(anomalyDetectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectors(AnomalyDetector... anomalyDetectors) {
            anomalyDetectors(Arrays.asList(anomalyDetectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectors(Consumer<AnomalyDetector.Builder>... anomalyDetectors) {
            anomalyDetectors(Stream.of(anomalyDetectors).map(c -> AnomalyDetector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalyDetectors(Collection<AnomalyDetector.BuilderImpl> anomalyDetectors) {
            this.anomalyDetectors = AnomalyDetectorsCopier.copyFromBuilder(anomalyDetectors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAnomalyDetectorsResponse build() {
            return new DescribeAnomalyDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
