/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInsightRulesResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeInsightRulesResponse.Builder, DescribeInsightRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInsightRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<InsightRule>> INSIGHT_RULES_FIELD = SdkField
            .<List<InsightRule>> builder(MarshallingType.LIST)
            .memberName("InsightRules")
            .getter(getter(DescribeInsightRulesResponse::insightRules))
            .setter(setter(Builder::insightRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INSIGHT_RULES_FIELD));

    private final String nextToken;

    private final List<InsightRule> insightRules;

    private DescribeInsightRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.insightRules = builder.insightRules;
    }

    /**
     * <p>
     * If this parameter is present, it is a token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return If this parameter is present, it is a token that marks the start of the next batch of returned results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsightRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsightRules() {
        return insightRules != null && !(insightRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsightRules} method.
     * </p>
     * 
     * @return The rules returned by the operation.
     */
    public final List<InsightRule> insightRules() {
        return insightRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsightRules() ? insightRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInsightRulesResponse)) {
            return false;
        }
        DescribeInsightRulesResponse other = (DescribeInsightRulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasInsightRules() == other.hasInsightRules()
                && Objects.equals(insightRules(), other.insightRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInsightRulesResponse").add("NextToken", nextToken())
                .add("InsightRules", hasInsightRules() ? insightRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "InsightRules":
            return Optional.ofNullable(clazz.cast(insightRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInsightRulesResponse, T> g) {
        return obj -> g.apply((DescribeInsightRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInsightRulesResponse> {
        /**
         * <p>
         * If this parameter is present, it is a token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        If this parameter is present, it is a token that marks the start of the next batch of returned
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The rules returned by the operation.
         * </p>
         * 
         * @param insightRules
         *        The rules returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightRules(Collection<InsightRule> insightRules);

        /**
         * <p>
         * The rules returned by the operation.
         * </p>
         * 
         * @param insightRules
         *        The rules returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightRules(InsightRule... insightRules);

        /**
         * <p>
         * The rules returned by the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InsightRule>.Builder} avoiding the need to
         * create one manually via {@link List<InsightRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #insightRules(List<InsightRule>)}.
         * 
         * @param insightRules
         *        a consumer that will call methods on {@link List<InsightRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightRules(List<InsightRule>)
         */
        Builder insightRules(Consumer<InsightRule.Builder>... insightRules);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<InsightRule> insightRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInsightRulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            insightRules(model.insightRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InsightRule.Builder> getInsightRules() {
            List<InsightRule.Builder> result = InsightRulesCopier.copyToBuilder(this.insightRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightRules(Collection<InsightRule.BuilderImpl> insightRules) {
            this.insightRules = InsightRulesCopier.copyFromBuilder(insightRules);
        }

        @Override
        @Transient
        public final Builder insightRules(Collection<InsightRule> insightRules) {
            this.insightRules = InsightRulesCopier.copy(insightRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder insightRules(InsightRule... insightRules) {
            insightRules(Arrays.asList(insightRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder insightRules(Consumer<InsightRule.Builder>... insightRules) {
            insightRules(Stream.of(insightRules).map(c -> InsightRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInsightRulesResponse build() {
            return new DescribeInsightRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
