/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This array is empty if the API operation was successful for all the rules specified in the request. If the operation
 * could not process one of the rules, the following data is returned for each of those rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartialFailure implements SdkPojo, Serializable, ToCopyableBuilder<PartialFailure.Builder, PartialFailure> {
    private static final SdkField<String> FAILURE_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureResource").getter(getter(PartialFailure::failureResource))
            .setter(setter(Builder::failureResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureResource").build()).build();

    private static final SdkField<String> EXCEPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExceptionType").getter(getter(PartialFailure::exceptionType)).setter(setter(Builder::exceptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExceptionType").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(PartialFailure::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureDescription").getter(getter(PartialFailure::failureDescription))
            .setter(setter(Builder::failureDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_RESOURCE_FIELD,
            EXCEPTION_TYPE_FIELD, FAILURE_CODE_FIELD, FAILURE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureResource;

    private final String exceptionType;

    private final String failureCode;

    private final String failureDescription;

    private PartialFailure(BuilderImpl builder) {
        this.failureResource = builder.failureResource;
        this.exceptionType = builder.exceptionType;
        this.failureCode = builder.failureCode;
        this.failureDescription = builder.failureDescription;
    }

    /**
     * <p>
     * The specified rule that could not be deleted.
     * </p>
     * 
     * @return The specified rule that could not be deleted.
     */
    public final String failureResource() {
        return failureResource;
    }

    /**
     * <p>
     * The type of error.
     * </p>
     * 
     * @return The type of error.
     */
    public final String exceptionType() {
        return exceptionType;
    }

    /**
     * <p>
     * The code of the error.
     * </p>
     * 
     * @return The code of the error.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * A description of the error.
     * </p>
     * 
     * @return A description of the error.
     */
    public final String failureDescription() {
        return failureDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureResource());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionType());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartialFailure)) {
            return false;
        }
        PartialFailure other = (PartialFailure) obj;
        return Objects.equals(failureResource(), other.failureResource())
                && Objects.equals(exceptionType(), other.exceptionType()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(failureDescription(), other.failureDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartialFailure").add("FailureResource", failureResource()).add("ExceptionType", exceptionType())
                .add("FailureCode", failureCode()).add("FailureDescription", failureDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureResource":
            return Optional.ofNullable(clazz.cast(failureResource()));
        case "ExceptionType":
            return Optional.ofNullable(clazz.cast(exceptionType()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureDescription":
            return Optional.ofNullable(clazz.cast(failureDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartialFailure, T> g) {
        return obj -> g.apply((PartialFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartialFailure> {
        /**
         * <p>
         * The specified rule that could not be deleted.
         * </p>
         * 
         * @param failureResource
         *        The specified rule that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResource(String failureResource);

        /**
         * <p>
         * The type of error.
         * </p>
         * 
         * @param exceptionType
         *        The type of error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionType(String exceptionType);

        /**
         * <p>
         * The code of the error.
         * </p>
         * 
         * @param failureCode
         *        The code of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * A description of the error.
         * </p>
         * 
         * @param failureDescription
         *        A description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDescription(String failureDescription);
    }

    static final class BuilderImpl implements Builder {
        private String failureResource;

        private String exceptionType;

        private String failureCode;

        private String failureDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PartialFailure model) {
            failureResource(model.failureResource);
            exceptionType(model.exceptionType);
            failureCode(model.failureCode);
            failureDescription(model.failureDescription);
        }

        public final String getFailureResource() {
            return failureResource;
        }

        public final void setFailureResource(String failureResource) {
            this.failureResource = failureResource;
        }

        @Override
        @Transient
        public final Builder failureResource(String failureResource) {
            this.failureResource = failureResource;
            return this;
        }

        public final String getExceptionType() {
            return exceptionType;
        }

        public final void setExceptionType(String exceptionType) {
            this.exceptionType = exceptionType;
        }

        @Override
        @Transient
        public final Builder exceptionType(String exceptionType) {
            this.exceptionType = exceptionType;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        @Transient
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureDescription() {
            return failureDescription;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        @Override
        @Transient
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        @Override
        public PartialFailure build() {
            return new PartialFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
