/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about a metric alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricAlarm implements SdkPojo, Serializable, ToCopyableBuilder<MetricAlarm.Builder, MetricAlarm> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmName").getter(getter(MetricAlarm::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmArn").getter(getter(MetricAlarm::alarmArn)).setter(setter(Builder::alarmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()).build();

    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmDescription").getter(getter(MetricAlarm::alarmDescription))
            .setter(setter(Builder::alarmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()).build();

    private static final SdkField<Instant> ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AlarmConfigurationUpdatedTimestamp")
            .getter(getter(MetricAlarm::alarmConfigurationUpdatedTimestamp))
            .setter(setter(Builder::alarmConfigurationUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfigurationUpdatedTimestamp")
                    .build()).build();

    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActionsEnabled").getter(getter(MetricAlarm::actionsEnabled)).setter(setter(Builder::actionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()).build();

    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OKActions")
            .getter(getter(MetricAlarm::okActions))
            .setter(setter(Builder::okActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmActions")
            .getter(getter(MetricAlarm::alarmActions))
            .setter(setter(Builder::alarmActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsufficientDataActions")
            .getter(getter(MetricAlarm::insufficientDataActions))
            .setter(setter(Builder::insufficientDataActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateValue").getter(getter(MetricAlarm::stateValueAsString)).setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(MetricAlarm::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonData").getter(getter(MetricAlarm::stateReasonData)).setter(setter(Builder::stateReasonData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()).build();

    private static final SdkField<Instant> STATE_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateUpdatedTimestamp").getter(getter(MetricAlarm::stateUpdatedTimestamp))
            .setter(setter(Builder::stateUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricAlarm::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(MetricAlarm::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(MetricAlarm::statisticAsString)).setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<String> EXTENDED_STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtendedStatistic").getter(getter(MetricAlarm::extendedStatistic))
            .setter(setter(Builder::extendedStatistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistic").build()).build();

    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(MetricAlarm::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(MetricAlarm::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(MetricAlarm::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriods").getter(getter(MetricAlarm::evaluationPeriods))
            .setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()).build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlarm").getter(getter(MetricAlarm::datapointsToAlarm))
            .setter(setter(Builder::datapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlarm").build()).build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Threshold").getter(getter(MetricAlarm::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(MetricAlarm::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatMissingData").getter(getter(MetricAlarm::treatMissingData))
            .setter(setter(Builder::treatMissingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatMissingData").build()).build();

    private static final SdkField<String> EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EvaluateLowSampleCountPercentile")
            .getter(getter(MetricAlarm::evaluateLowSampleCountPercentile))
            .setter(setter(Builder::evaluateLowSampleCountPercentile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluateLowSampleCountPercentile")
                    .build()).build();

    private static final SdkField<List<MetricDataQuery>> METRICS_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(MetricAlarm::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> THRESHOLD_METRIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThresholdMetricId").getter(getter(MetricAlarm::thresholdMetricId))
            .setter(setter(Builder::thresholdMetricId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdMetricId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            ALARM_ARN_FIELD, ALARM_DESCRIPTION_FIELD, ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD, ACTIONS_ENABLED_FIELD,
            OK_ACTIONS_FIELD, ALARM_ACTIONS_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, STATE_VALUE_FIELD, STATE_REASON_FIELD,
            STATE_REASON_DATA_FIELD, STATE_UPDATED_TIMESTAMP_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD, STATISTIC_FIELD,
            EXTENDED_STATISTIC_FIELD, DIMENSIONS_FIELD, PERIOD_FIELD, UNIT_FIELD, EVALUATION_PERIODS_FIELD,
            DATAPOINTS_TO_ALARM_FIELD, THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD, TREAT_MISSING_DATA_FIELD,
            EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD, METRICS_FIELD, THRESHOLD_METRIC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmName;

    private final String alarmArn;

    private final String alarmDescription;

    private final Instant alarmConfigurationUpdatedTimestamp;

    private final Boolean actionsEnabled;

    private final List<String> okActions;

    private final List<String> alarmActions;

    private final List<String> insufficientDataActions;

    private final String stateValue;

    private final String stateReason;

    private final String stateReasonData;

    private final Instant stateUpdatedTimestamp;

    private final String metricName;

    private final String namespace;

    private final String statistic;

    private final String extendedStatistic;

    private final List<Dimension> dimensions;

    private final Integer period;

    private final String unit;

    private final Integer evaluationPeriods;

    private final Integer datapointsToAlarm;

    private final Double threshold;

    private final String comparisonOperator;

    private final String treatMissingData;

    private final String evaluateLowSampleCountPercentile;

    private final List<MetricDataQuery> metrics;

    private final String thresholdMetricId;

    private MetricAlarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmArn = builder.alarmArn;
        this.alarmDescription = builder.alarmDescription;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
        this.stateUpdatedTimestamp = builder.stateUpdatedTimestamp;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
        this.metrics = builder.metrics;
        this.thresholdMetricId = builder.thresholdMetricId;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public final String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alarm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alarm.
     */
    public final String alarmArn() {
        return alarmArn;
    }

    /**
     * <p>
     * The description of the alarm.
     * </p>
     * 
     * @return The description of the alarm.
     */
    public final String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * The time stamp of the last update to the alarm configuration.
     * </p>
     * 
     * @return The time stamp of the last update to the alarm configuration.
     */
    public final Instant alarmConfigurationUpdatedTimestamp() {
        return alarmConfigurationUpdatedTimestamp;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state.
     */
    public final Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * Returns true if the OKActions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOkActions() {
        return okActions != null && !(okActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each action
     * is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOkActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).
     */
    public final List<String> okActions() {
        return okActions;
    }

    /**
     * Returns true if the AlarmActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAlarmActions() {
        return alarmActions != null && !(alarmActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
     * action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlarmActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).
     */
    public final List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * Returns true if the InsufficientDataActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInsufficientDataActions() {
        return insufficientDataActions != null && !(insufficientDataActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
     * state. Each action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInsufficientDataActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any
     *         other state. Each action is specified as an Amazon Resource Name (ARN).
     */
    public final List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * <p>
     * The state value for the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value for the alarm.
     * @see StateValue
     */
    public final StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The state value for the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The state value for the alarm.
     * @see StateValue
     */
    public final String stateValueAsString() {
        return stateValue;
    }

    /**
     * <p>
     * An explanation for the alarm state, in text format.
     * </p>
     * 
     * @return An explanation for the alarm state, in text format.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * An explanation for the alarm state, in JSON format.
     * </p>
     * 
     * @return An explanation for the alarm state, in JSON format.
     */
    public final String stateReasonData() {
        return stateReasonData;
    }

    /**
     * <p>
     * The time stamp of the last update to the alarm state.
     * </p>
     * 
     * @return The time stamp of the last update to the alarm state.
     */
    public final Instant stateUpdatedTimestamp() {
        return stateUpdatedTimestamp;
    }

    /**
     * <p>
     * The name of the metric associated with the alarm, if this is an alarm based on a single metric.
     * </p>
     * 
     * @return The name of the metric associated with the alarm, if this is an alarm based on a single metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the metric associated with the alarm.
     * </p>
     * 
     * @return The namespace of the metric associated with the alarm.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public final Statistic statistic() {
        return Statistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.
     * @see Statistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     * </p>
     * 
     * @return The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     */
    public final String extendedStatistic() {
        return extendedStatistic;
    }

    /**
     * Returns true if the Dimensions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions for the metric associated with the alarm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The dimensions for the metric associated with the alarm.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The period, in seconds, over which the statistic is applied.
     * </p>
     * 
     * @return The period, in seconds, over which the statistic is applied.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The unit of the metric associated with the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of the metric associated with the alarm.
     * @see StandardUnit
     */
    public final StandardUnit unit() {
        return StandardUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of the metric associated with the alarm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of the metric associated with the alarm.
     * @see StandardUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The number of periods over which data is compared to the specified threshold.
     * </p>
     * 
     * @return The number of periods over which data is compared to the specified threshold.
     */
    public final Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * The number of data points that must be breaching to trigger the alarm.
     * </p>
     * 
     * @return The number of data points that must be breaching to trigger the alarm.
     */
    public final Integer datapointsToAlarm() {
        return datapointsToAlarm;
    }

    /**
     * <p>
     * The value to compare with the specified statistic.
     * </p>
     * 
     * @return The value to compare with the specified statistic.
     */
    public final Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of
     * <code>missing</code> is used.
     * </p>
     * 
     * @return Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior
     *         of <code>missing</code> is used.
     */
    public final String treatMissingData() {
        return treatMissingData;
    }

    /**
     * <p>
     * Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during periods
     * with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used,
     * the alarm is always evaluated and possibly changes state no matter how many data points are available.
     * </p>
     * 
     * @return Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during
     *         periods with too few data points to be statistically significant. If <code>evaluate</code> or this
     *         parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data
     *         points are available.
     */
    public final String evaluateLowSampleCountPercentile() {
        return evaluateLowSampleCountPercentile;
    }

    /**
     * Returns true if the Metrics property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure either
     * retrieves a metric or performs a math expression. One item in the Metrics array is the math expression that the
     * alarm watches. This expression by designated by having <code>ReturnData</code> set to true.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each
     *         structure either retrieves a metric or performs a math expression. One item in the Metrics array is the
     *         math expression that the alarm watches. This expression by designated by having <code>ReturnData</code>
     *         set to true.
     */
    public final List<MetricDataQuery> metrics() {
        return metrics;
    }

    /**
     * <p>
     * In an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code>
     * function used as the threshold for the alarm.
     * </p>
     * 
     * @return In an alarm based on an anomaly detection model, this is the ID of the
     *         <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.
     */
    public final String thresholdMetricId() {
        return thresholdMetricId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasOkActions() ? okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmActions() ? alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInsufficientDataActions() ? insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonData());
        hashCode = 31 * hashCode + Objects.hashCode(stateUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(evaluateLowSampleCountPercentile());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thresholdMetricId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAlarm)) {
            return false;
        }
        MetricAlarm other = (MetricAlarm) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(alarmArn(), other.alarmArn())
                && Objects.equals(alarmDescription(), other.alarmDescription())
                && Objects.equals(alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp())
                && Objects.equals(actionsEnabled(), other.actionsEnabled()) && hasOkActions() == other.hasOkActions()
                && Objects.equals(okActions(), other.okActions()) && hasAlarmActions() == other.hasAlarmActions()
                && Objects.equals(alarmActions(), other.alarmActions())
                && hasInsufficientDataActions() == other.hasInsufficientDataActions()
                && Objects.equals(insufficientDataActions(), other.insufficientDataActions())
                && Objects.equals(stateValueAsString(), other.stateValueAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonData(), other.stateReasonData())
                && Objects.equals(stateUpdatedTimestamp(), other.stateUpdatedTimestamp())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(extendedStatistic(), other.extendedStatistic()) && hasDimensions() == other.hasDimensions()
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(period(), other.period())
                && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(datapointsToAlarm(), other.datapointsToAlarm())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(treatMissingData(), other.treatMissingData())
                && Objects.equals(evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(thresholdMetricId(), other.thresholdMetricId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricAlarm").add("AlarmName", alarmName()).add("AlarmArn", alarmArn())
                .add("AlarmDescription", alarmDescription())
                .add("AlarmConfigurationUpdatedTimestamp", alarmConfigurationUpdatedTimestamp())
                .add("ActionsEnabled", actionsEnabled()).add("OKActions", hasOkActions() ? okActions() : null)
                .add("AlarmActions", hasAlarmActions() ? alarmActions() : null)
                .add("InsufficientDataActions", hasInsufficientDataActions() ? insufficientDataActions() : null)
                .add("StateValue", stateValueAsString()).add("StateReason", stateReason())
                .add("StateReasonData", stateReasonData()).add("StateUpdatedTimestamp", stateUpdatedTimestamp())
                .add("MetricName", metricName()).add("Namespace", namespace()).add("Statistic", statisticAsString())
                .add("ExtendedStatistic", extendedStatistic()).add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("Period", period()).add("Unit", unitAsString()).add("EvaluationPeriods", evaluationPeriods())
                .add("DatapointsToAlarm", datapointsToAlarm()).add("Threshold", threshold())
                .add("ComparisonOperator", comparisonOperatorAsString()).add("TreatMissingData", treatMissingData())
                .add("EvaluateLowSampleCountPercentile", evaluateLowSampleCountPercentile())
                .add("Metrics", hasMetrics() ? metrics() : null).add("ThresholdMetricId", thresholdMetricId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "AlarmArn":
            return Optional.ofNullable(clazz.cast(alarmArn()));
        case "AlarmDescription":
            return Optional.ofNullable(clazz.cast(alarmDescription()));
        case "AlarmConfigurationUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(alarmConfigurationUpdatedTimestamp()));
        case "ActionsEnabled":
            return Optional.ofNullable(clazz.cast(actionsEnabled()));
        case "OKActions":
            return Optional.ofNullable(clazz.cast(okActions()));
        case "AlarmActions":
            return Optional.ofNullable(clazz.cast(alarmActions()));
        case "InsufficientDataActions":
            return Optional.ofNullable(clazz.cast(insufficientDataActions()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonData":
            return Optional.ofNullable(clazz.cast(stateReasonData()));
        case "StateUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(stateUpdatedTimestamp()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "ExtendedStatistic":
            return Optional.ofNullable(clazz.cast(extendedStatistic()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "EvaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "DatapointsToAlarm":
            return Optional.ofNullable(clazz.cast(datapointsToAlarm()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "TreatMissingData":
            return Optional.ofNullable(clazz.cast(treatMissingData()));
        case "EvaluateLowSampleCountPercentile":
            return Optional.ofNullable(clazz.cast(evaluateLowSampleCountPercentile()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "ThresholdMetricId":
            return Optional.ofNullable(clazz.cast(thresholdMetricId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricAlarm, T> g) {
        return obj -> g.apply((MetricAlarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricAlarm> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alarm.
         * </p>
         * 
         * @param alarmArn
         *        The Amazon Resource Name (ARN) of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmArn(String alarmArn);

        /**
         * <p>
         * The description of the alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * The time stamp of the last update to the alarm configuration.
         * </p>
         * 
         * @param alarmConfigurationUpdatedTimestamp
         *        The time stamp of the last update to the alarm configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp);

        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The state value for the alarm.
         * </p>
         * 
         * @param stateValue
         *        The state value for the alarm.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The state value for the alarm.
         * </p>
         * 
         * @param stateValue
         *        The state value for the alarm.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * An explanation for the alarm state, in text format.
         * </p>
         * 
         * @param stateReason
         *        An explanation for the alarm state, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * An explanation for the alarm state, in JSON format.
         * </p>
         * 
         * @param stateReasonData
         *        An explanation for the alarm state, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReasonData(String stateReasonData);

        /**
         * <p>
         * The time stamp of the last update to the alarm state.
         * </p>
         * 
         * @param stateUpdatedTimestamp
         *        The time stamp of the last update to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp);

        /**
         * <p>
         * The name of the metric associated with the alarm, if this is an alarm based on a single metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric associated with the alarm, if this is an alarm based on a single metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the metric associated with the alarm.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         * </p>
         * 
         * @param extendedStatistic
         *        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and
         *        p100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistic(String extendedStatistic);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Dimension>.Builder} avoiding the need to
         * create one manually via {@link List<Dimension>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Dimension>.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<Dimension>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * The period, in seconds, over which the statistic is applied.
         * </p>
         * 
         * @param period
         *        The period, in seconds, over which the statistic is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The unit of the metric associated with the alarm.
         * </p>
         * 
         * @param unit
         *        The unit of the metric associated with the alarm.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of the metric associated with the alarm.
         * </p>
         * 
         * @param unit
         *        The unit of the metric associated with the alarm.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);

        /**
         * <p>
         * The number of periods over which data is compared to the specified threshold.
         * </p>
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * The number of data points that must be breaching to trigger the alarm.
         * </p>
         * 
         * @param datapointsToAlarm
         *        The number of data points that must be breaching to trigger the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlarm(Integer datapointsToAlarm);

        /**
         * <p>
         * The value to compare with the specified statistic.
         * </p>
         * 
         * @param threshold
         *        The value to compare with the specified statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of
         * <code>missing</code> is used.
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm is to handle missing data points. If this parameter is omitted, the default
         *        behavior of <code>missing</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * <p>
         * Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during
         * periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter
         * is not used, the alarm is always evaluated and possibly changes state no matter how many data points are
         * available.
         * </p>
         * 
         * @param evaluateLowSampleCountPercentile
         *        Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
         *        during periods with too few data points to be statistically significant. If <code>evaluate</code> or
         *        this parameter is not used, the alarm is always evaluated and possibly changes state no matter how
         *        many data points are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile);

        /**
         * <p>
         * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure
         * either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression
         * that the alarm watches. This expression by designated by having <code>ReturnData</code> set to true.
         * </p>
         * 
         * @param metrics
         *        An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each
         *        structure either retrieves a metric or performs a math expression. One item in the Metrics array is
         *        the math expression that the alarm watches. This expression by designated by having
         *        <code>ReturnData</code> set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<MetricDataQuery> metrics);

        /**
         * <p>
         * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure
         * either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression
         * that the alarm watches. This expression by designated by having <code>ReturnData</code> set to true.
         * </p>
         * 
         * @param metrics
         *        An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each
         *        structure either retrieves a metric or performs a math expression. One item in the Metrics array is
         *        the math expression that the alarm watches. This expression by designated by having
         *        <code>ReturnData</code> set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(MetricDataQuery... metrics);

        /**
         * <p>
         * An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure
         * either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression
         * that the alarm watches. This expression by designated by having <code>ReturnData</code> set to true.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDataQuery>.Builder} avoiding the need
         * to create one manually via {@link List<MetricDataQuery>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDataQuery>.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(List<MetricDataQuery>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link List<MetricDataQuery>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(List<MetricDataQuery>)
         */
        Builder metrics(Consumer<MetricDataQuery.Builder>... metrics);

        /**
         * <p>
         * In an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code>
         * function used as the threshold for the alarm.
         * </p>
         * 
         * @param thresholdMetricId
         *        In an alarm based on an anomaly detection model, this is the ID of the
         *        <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdMetricId(String thresholdMetricId);
    }

    static final class BuilderImpl implements Builder {
        private String alarmName;

        private String alarmArn;

        private String alarmDescription;

        private Instant alarmConfigurationUpdatedTimestamp;

        private Boolean actionsEnabled;

        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();

        private String stateValue;

        private String stateReason;

        private String stateReasonData;

        private Instant stateUpdatedTimestamp;

        private String metricName;

        private String namespace;

        private String statistic;

        private String extendedStatistic;

        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private Integer period;

        private String unit;

        private Integer evaluationPeriods;

        private Integer datapointsToAlarm;

        private Double threshold;

        private String comparisonOperator;

        private String treatMissingData;

        private String evaluateLowSampleCountPercentile;

        private List<MetricDataQuery> metrics = DefaultSdkAutoConstructList.getInstance();

        private String thresholdMetricId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAlarm model) {
            alarmName(model.alarmName);
            alarmArn(model.alarmArn);
            alarmDescription(model.alarmDescription);
            alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            actionsEnabled(model.actionsEnabled);
            okActions(model.okActions);
            alarmActions(model.alarmActions);
            insufficientDataActions(model.insufficientDataActions);
            stateValue(model.stateValue);
            stateReason(model.stateReason);
            stateReasonData(model.stateReasonData);
            stateUpdatedTimestamp(model.stateUpdatedTimestamp);
            metricName(model.metricName);
            namespace(model.namespace);
            statistic(model.statistic);
            extendedStatistic(model.extendedStatistic);
            dimensions(model.dimensions);
            period(model.period);
            unit(model.unit);
            evaluationPeriods(model.evaluationPeriods);
            datapointsToAlarm(model.datapointsToAlarm);
            threshold(model.threshold);
            comparisonOperator(model.comparisonOperator);
            treatMissingData(model.treatMissingData);
            evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
            metrics(model.metrics);
            thresholdMetricId(model.thresholdMetricId);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        @Transient
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmArn() {
            return alarmArn;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        @Override
        @Transient
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        @Transient
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final Instant getAlarmConfigurationUpdatedTimestamp() {
            return alarmConfigurationUpdatedTimestamp;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        @Transient
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getOkActions() {
            if (okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @Override
        @Transient
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            okActions(Arrays.asList(okActions));
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @Override
        @Transient
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @Override
        @Transient
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final String getStateValue() {
            return stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        @Transient
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        @Transient
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        @Transient
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonData() {
            return stateReasonData;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        @Transient
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final Instant getStateUpdatedTimestamp() {
            return stateUpdatedTimestamp;
        }

        public final void setStateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        @Transient
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        @Transient
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getExtendedStatistic() {
            return extendedStatistic;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        @Override
        @Transient
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Transient
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        @Transient
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        @Transient
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        @Transient
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        @Transient
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        @Transient
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return evaluateLowSampleCountPercentile;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        @Transient
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final List<MetricDataQuery.Builder> getMetrics() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricDataQuery.BuilderImpl> metrics) {
            this.metrics = MetricDataQueriesCopier.copyFromBuilder(metrics);
        }

        @Override
        @Transient
        public final Builder metrics(Collection<MetricDataQuery> metrics) {
            this.metrics = MetricDataQueriesCopier.copy(metrics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metrics(MetricDataQuery... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metrics(Consumer<MetricDataQuery.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> MetricDataQuery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getThresholdMetricId() {
            return thresholdMetricId;
        }

        public final void setThresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
        }

        @Override
        @Transient
        public final Builder thresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
            return this;
        }

        @Override
        public MetricAlarm build() {
            return new MetricAlarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
