/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyDetectorsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAnomalyDetectorsRequest.Builder, DescribeAnomalyDetectorsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAnomalyDetectorsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeAnomalyDetectorsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(DescribeAnomalyDetectorsRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(DescribeAnomalyDetectorsRequest::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(DescribeAnomalyDetectorsRequest::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ANOMALY_DETECTOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AnomalyDetectorTypes")
            .getter(getter(DescribeAnomalyDetectorsRequest::anomalyDetectorTypesAsStrings))
            .setter(setter(Builder::anomalyDetectorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, NAMESPACE_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, ANOMALY_DETECTOR_TYPES_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String namespace;

    private final String metricName;

    private final List<Dimension> dimensions;

    private final List<String> anomalyDetectorTypes;

    private DescribeAnomalyDetectorsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.anomalyDetectorTypes = builder.anomalyDetectorTypes;
    }

    /**
     * <p>
     * Use the token returned by the previous operation to request the next page of results.
     * </p>
     * 
     * @return Use the token returned by the previous operation to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in one operation. The maximum value that you can specify is 100.
     * </p>
     * <p>
     * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in one operation. The maximum value that you can specify is
     *         100.</p>
     *         <p>
     *         To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Limits the results to only the anomaly detection models that are associated with the specified namespace.
     * </p>
     * 
     * @return Limits the results to only the anomaly detection models that are associated with the specified namespace.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * Limits the results to only the anomaly detection models that are associated with the specified metric name. If
     * there are multiple metrics with this name in different namespaces that have anomaly detection models, they're all
     * returned.
     * </p>
     * 
     * @return Limits the results to only the anomaly detection models that are associated with the specified metric
     *         name. If there are multiple metrics with this name in different namespaces that have anomaly detection
     *         models, they're all returned.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Limits the results to only the anomaly detection models that are associated with the specified metric dimensions.
     * If there are multiple metrics that have these dimensions and have anomaly detection models associated, they're
     * all returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return Limits the results to only the anomaly detection models that are associated with the specified metric
     *         dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
     *         associated, they're all returned.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty, defaults
     * to <code>SINGLE_METRIC</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnomalyDetectorTypes} method.
     * </p>
     * 
     * @return The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
     *         defaults to <code>SINGLE_METRIC</code>.
     */
    public final List<AnomalyDetectorType> anomalyDetectorTypes() {
        return AnomalyDetectorTypesCopier.copyStringToEnum(anomalyDetectorTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AnomalyDetectorTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnomalyDetectorTypes() {
        return anomalyDetectorTypes != null && !(anomalyDetectorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty, defaults
     * to <code>SINGLE_METRIC</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnomalyDetectorTypes} method.
     * </p>
     * 
     * @return The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
     *         defaults to <code>SINGLE_METRIC</code>.
     */
    public final List<String> anomalyDetectorTypesAsStrings() {
        return anomalyDetectorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalyDetectorTypes() ? anomalyDetectorTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorsRequest)) {
            return false;
        }
        DescribeAnomalyDetectorsRequest other = (DescribeAnomalyDetectorsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(metricName(), other.metricName())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && hasAnomalyDetectorTypes() == other.hasAnomalyDetectorTypes()
                && Objects.equals(anomalyDetectorTypesAsStrings(), other.anomalyDetectorTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyDetectorsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Namespace", namespace()).add("MetricName", metricName())
                .add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("AnomalyDetectorTypes", hasAnomalyDetectorTypes() ? anomalyDetectorTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "AnomalyDetectorTypes":
            return Optional.ofNullable(clazz.cast(anomalyDetectorTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorsRequest, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnomalyDetectorsRequest> {
        /**
         * <p>
         * Use the token returned by the previous operation to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Use the token returned by the previous operation to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in one operation. The maximum value that you can specify is 100.
         * </p>
         * <p>
         * To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in one operation. The maximum value that you can specify is
         *        100.</p>
         *        <p>
         *        To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Limits the results to only the anomaly detection models that are associated with the specified namespace.
         * </p>
         * 
         * @param namespace
         *        Limits the results to only the anomaly detection models that are associated with the specified
         *        namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * Limits the results to only the anomaly detection models that are associated with the specified metric name.
         * If there are multiple metrics with this name in different namespaces that have anomaly detection models,
         * they're all returned.
         * </p>
         * 
         * @param metricName
         *        Limits the results to only the anomaly detection models that are associated with the specified metric
         *        name. If there are multiple metrics with this name in different namespaces that have anomaly detection
         *        models, they're all returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * Limits the results to only the anomaly detection models that are associated with the specified metric
         * dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
         * associated, they're all returned.
         * </p>
         * 
         * @param dimensions
         *        Limits the results to only the anomaly detection models that are associated with the specified metric
         *        dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
         *        associated, they're all returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * Limits the results to only the anomaly detection models that are associated with the specified metric
         * dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
         * associated, they're all returned.
         * </p>
         * 
         * @param dimensions
         *        Limits the results to only the anomaly detection models that are associated with the specified metric
         *        dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
         *        associated, they're all returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * Limits the results to only the anomaly detection models that are associated with the specified metric
         * dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models
         * associated, they're all returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Dimension>.Builder} avoiding the need to
         * create one manually via {@link List<Dimension>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Dimension>.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<Dimension>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         * defaults to <code>SINGLE_METRIC</code>.
         * </p>
         * 
         * @param anomalyDetectorTypes
         *        The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         *        defaults to <code>SINGLE_METRIC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorTypesWithStrings(Collection<String> anomalyDetectorTypes);

        /**
         * <p>
         * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         * defaults to <code>SINGLE_METRIC</code>.
         * </p>
         * 
         * @param anomalyDetectorTypes
         *        The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         *        defaults to <code>SINGLE_METRIC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorTypesWithStrings(String... anomalyDetectorTypes);

        /**
         * <p>
         * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         * defaults to <code>SINGLE_METRIC</code>.
         * </p>
         * 
         * @param anomalyDetectorTypes
         *        The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         *        defaults to <code>SINGLE_METRIC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorTypes(Collection<AnomalyDetectorType> anomalyDetectorTypes);

        /**
         * <p>
         * The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         * defaults to <code>SINGLE_METRIC</code>.
         * </p>
         * 
         * @param anomalyDetectorTypes
         *        The anomaly detector types to request when using <code>DescribeAnomalyDetectorsInput</code>. If empty,
         *        defaults to <code>SINGLE_METRIC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorTypes(AnomalyDetectorType... anomalyDetectorTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String namespace;

        private String metricName;

        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private List<String> anomalyDetectorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            namespace(model.namespace);
            metricName(model.metricName);
            dimensions(model.dimensions);
            anomalyDetectorTypesWithStrings(model.anomalyDetectorTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Transient
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAnomalyDetectorTypes() {
            if (anomalyDetectorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return anomalyDetectorTypes;
        }

        public final void setAnomalyDetectorTypes(Collection<String> anomalyDetectorTypes) {
            this.anomalyDetectorTypes = AnomalyDetectorTypesCopier.copy(anomalyDetectorTypes);
        }

        @Override
        @Transient
        public final Builder anomalyDetectorTypesWithStrings(Collection<String> anomalyDetectorTypes) {
            this.anomalyDetectorTypes = AnomalyDetectorTypesCopier.copy(anomalyDetectorTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyDetectorTypesWithStrings(String... anomalyDetectorTypes) {
            anomalyDetectorTypesWithStrings(Arrays.asList(anomalyDetectorTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorTypes(Collection<AnomalyDetectorType> anomalyDetectorTypes) {
            this.anomalyDetectorTypes = AnomalyDetectorTypesCopier.copyEnumToString(anomalyDetectorTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalyDetectorTypes(AnomalyDetectorType... anomalyDetectorTypes) {
            anomalyDetectorTypes(Arrays.asList(anomalyDetectorTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAnomalyDetectorsRequest build() {
            return new DescribeAnomalyDetectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
