/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the definition for a Contributor Insights rule. For more information about this rule, see<a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html"> Using Constributor
 * Insights to analyze high-cardinality data</a> in the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightRule implements SdkPojo, Serializable, ToCopyableBuilder<InsightRule.Builder, InsightRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InsightRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InsightRule::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(InsightRule::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Definition").getter(getter(InsightRule::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD,
            SCHEMA_FIELD, DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String state;

    private final String schema;

    private final String definition;

    private InsightRule(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.schema = builder.schema;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether the rule is enabled or disabled.
     * </p>
     * 
     * @return Indicates whether the rule is enabled or disabled.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For managed
     * rules, this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
     * </p>
     * 
     * @return For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For
     *         managed rules, this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors,
     * the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the
     * valid syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     * >Contributor Insights Rule Syntax</a>.
     * </p>
     * 
     * @return The definition of the rule, as a JSON object. The definition contains the keywords used to define
     *         contributors, the value to aggregate on if this rule returns a sum instead of a count, and the filters.
     *         For details on the valid syntax, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     *         >Contributor Insights Rule Syntax</a>.
     */
    public final String definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRule)) {
            return false;
        }
        InsightRule other = (InsightRule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(state(), other.state())
                && Objects.equals(schema(), other.schema()) && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightRule").add("Name", name()).add("State", state()).add("Schema", schema())
                .add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightRule, T> g) {
        return obj -> g.apply((InsightRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightRule> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether the rule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Indicates whether the rule is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For
         * managed rules, this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
         * </p>
         * 
         * @param schema
         *        For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>.
         *        For managed rules, this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The definition of the rule, as a JSON object. The definition contains the keywords used to define
         * contributors, the value to aggregate on if this rule returns a sum instead of a count, and the filters. For
         * details on the valid syntax, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         * >Contributor Insights Rule Syntax</a>.
         * </p>
         * 
         * @param definition
         *        The definition of the rule, as a JSON object. The definition contains the keywords used to define
         *        contributors, the value to aggregate on if this rule returns a sum instead of a count, and the
         *        filters. For details on the valid syntax, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         *        >Contributor Insights Rule Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String state;

        private String schema;

        private String definition;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRule model) {
            name(model.name);
            state(model.state);
            schema(model.schema);
            definition(model.definition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        @Transient
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        @Transient
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public InsightRule build() {
            return new InsightRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
