/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<ListMetricsRequest.Builder, ListMetricsRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(ListMetricsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(ListMetricsRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<List<DimensionFilter>> DIMENSIONS_FIELD = SdkField
            .<List<DimensionFilter>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(ListMetricsRequest::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> RECENTLY_ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecentlyActive").getter(getter(ListMetricsRequest::recentlyActiveAsString))
            .setter(setter(Builder::recentlyActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecentlyActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            METRIC_NAME_FIELD, DIMENSIONS_FIELD, NEXT_TOKEN_FIELD, RECENTLY_ACTIVE_FIELD));

    private final String namespace;

    private final String metricName;

    private final List<DimensionFilter> dimensions;

    private final String nextToken;

    private final String recentlyActive;

    private ListMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.nextToken = builder.nextToken;
        this.recentlyActive = builder.recentlyActive;
    }

    /**
     * <p>
     * The metric namespace to filter against. Only the namespace that matches exactly will be returned.
     * </p>
     * 
     * @return The metric namespace to filter against. Only the namespace that matches exactly will be returned.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the metric to filter against. Only the metrics with names that match exactly will be returned.
     * </p>
     * 
     * @return The name of the metric to filter against. Only the metrics with names that match exactly will be
     *         returned.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions to filter against. Only the dimensions that match exactly will be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The dimensions to filter against. Only the dimensions that match exactly will be returned.
     */
    public final List<DimensionFilter> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * To filter the results to show only metrics that have had data points published in the past three hours, specify
     * this parameter with a value of <code>PT3H</code>. This is the only valid value for this parameter.
     * </p>
     * <p>
     * The results that are returned are an approximation of the value you specify. There is a low probability that the
     * returned results include metrics with last published data as much as 40 minutes more than the specified time
     * interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recentlyActive}
     * will return {@link RecentlyActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recentlyActiveAsString}.
     * </p>
     * 
     * @return To filter the results to show only metrics that have had data points published in the past three hours,
     *         specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this
     *         parameter.</p>
     *         <p>
     *         The results that are returned are an approximation of the value you specify. There is a low probability
     *         that the returned results include metrics with last published data as much as 40 minutes more than the
     *         specified time interval.
     * @see RecentlyActive
     */
    public final RecentlyActive recentlyActive() {
        return RecentlyActive.fromValue(recentlyActive);
    }

    /**
     * <p>
     * To filter the results to show only metrics that have had data points published in the past three hours, specify
     * this parameter with a value of <code>PT3H</code>. This is the only valid value for this parameter.
     * </p>
     * <p>
     * The results that are returned are an approximation of the value you specify. There is a low probability that the
     * returned results include metrics with last published data as much as 40 minutes more than the specified time
     * interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recentlyActive}
     * will return {@link RecentlyActive#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recentlyActiveAsString}.
     * </p>
     * 
     * @return To filter the results to show only metrics that have had data points published in the past three hours,
     *         specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this
     *         parameter.</p>
     *         <p>
     *         The results that are returned are an approximation of the value you specify. There is a low probability
     *         that the returned results include metrics with last published data as much as 40 minutes more than the
     *         specified time interval.
     * @see RecentlyActive
     */
    public final String recentlyActiveAsString() {
        return recentlyActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recentlyActiveAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(metricName(), other.metricName())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(recentlyActiveAsString(), other.recentlyActiveAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricsRequest").add("Namespace", namespace()).add("MetricName", metricName())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("NextToken", nextToken())
                .add("RecentlyActive", recentlyActiveAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RecentlyActive":
            return Optional.ofNullable(clazz.cast(recentlyActiveAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricsRequest, T> g) {
        return obj -> g.apply((ListMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricsRequest> {
        /**
         * <p>
         * The metric namespace to filter against. Only the namespace that matches exactly will be returned.
         * </p>
         * 
         * @param namespace
         *        The metric namespace to filter against. Only the namespace that matches exactly will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the metric to filter against. Only the metrics with names that match exactly will be returned.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to filter against. Only the metrics with names that match exactly will be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The dimensions to filter against. Only the dimensions that match exactly will be returned.
         * </p>
         * 
         * @param dimensions
         *        The dimensions to filter against. Only the dimensions that match exactly will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<DimensionFilter> dimensions);

        /**
         * <p>
         * The dimensions to filter against. Only the dimensions that match exactly will be returned.
         * </p>
         * 
         * @param dimensions
         *        The dimensions to filter against. Only the dimensions that match exactly will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionFilter... dimensions);

        /**
         * <p>
         * The dimensions to filter against. Only the dimensions that match exactly will be returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionFilter>.Builder} avoiding the need
         * to create one manually via {@link List<DimensionFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #dimensions(List<DimensionFilter>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<DimensionFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<DimensionFilter>)
         */
        Builder dimensions(Consumer<DimensionFilter.Builder>... dimensions);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * To filter the results to show only metrics that have had data points published in the past three hours,
         * specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this parameter.
         * </p>
         * <p>
         * The results that are returned are an approximation of the value you specify. There is a low probability that
         * the returned results include metrics with last published data as much as 40 minutes more than the specified
         * time interval.
         * </p>
         * 
         * @param recentlyActive
         *        To filter the results to show only metrics that have had data points published in the past three
         *        hours, specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this
         *        parameter.</p>
         *        <p>
         *        The results that are returned are an approximation of the value you specify. There is a low
         *        probability that the returned results include metrics with last published data as much as 40 minutes
         *        more than the specified time interval.
         * @see RecentlyActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecentlyActive
         */
        Builder recentlyActive(String recentlyActive);

        /**
         * <p>
         * To filter the results to show only metrics that have had data points published in the past three hours,
         * specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this parameter.
         * </p>
         * <p>
         * The results that are returned are an approximation of the value you specify. There is a low probability that
         * the returned results include metrics with last published data as much as 40 minutes more than the specified
         * time interval.
         * </p>
         * 
         * @param recentlyActive
         *        To filter the results to show only metrics that have had data points published in the past three
         *        hours, specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this
         *        parameter.</p>
         *        <p>
         *        The results that are returned are an approximation of the value you specify. There is a low
         *        probability that the returned results include metrics with last published data as much as 40 minutes
         *        more than the specified time interval.
         * @see RecentlyActive
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecentlyActive
         */
        Builder recentlyActive(RecentlyActive recentlyActive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String namespace;

        private String metricName;

        private List<DimensionFilter> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String recentlyActive;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsRequest model) {
            super(model);
            namespace(model.namespace);
            metricName(model.metricName);
            dimensions(model.dimensions);
            nextToken(model.nextToken);
            recentlyActive(model.recentlyActive);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final List<DimensionFilter.Builder> getDimensions() {
            List<DimensionFilter.Builder> result = DimensionFiltersCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionFilter.BuilderImpl> dimensions) {
            this.dimensions = DimensionFiltersCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Transient
        public final Builder dimensions(Collection<DimensionFilter> dimensions) {
            this.dimensions = DimensionFiltersCopier.copy(dimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(DimensionFilter... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionFilter.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> DimensionFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRecentlyActive() {
            return recentlyActive;
        }

        public final void setRecentlyActive(String recentlyActive) {
            this.recentlyActive = recentlyActive;
        }

        @Override
        @Transient
        public final Builder recentlyActive(String recentlyActive) {
            this.recentlyActive = recentlyActive;
            return this;
        }

        @Override
        @Transient
        public final Builder recentlyActive(RecentlyActive recentlyActive) {
            this.recentlyActive(recentlyActive == null ? null : recentlyActive.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetricsRequest build() {
            return new ListMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
