/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmsResponse.Builder, DescribeAlarmsResponse> {
    private static final SdkField<List<CompositeAlarm>> COMPOSITE_ALARMS_FIELD = SdkField
            .<List<CompositeAlarm>> builder(MarshallingType.LIST)
            .memberName("CompositeAlarms")
            .getter(getter(DescribeAlarmsResponse::compositeAlarms))
            .setter(setter(Builder::compositeAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompositeAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositeAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricAlarm>> METRIC_ALARMS_FIELD = SdkField
            .<List<MetricAlarm>> builder(MarshallingType.LIST)
            .memberName("MetricAlarms")
            .getter(getter(DescribeAlarmsResponse::metricAlarms))
            .setter(setter(Builder::metricAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAlarmsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_ALARMS_FIELD,
            METRIC_ALARMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<CompositeAlarm> compositeAlarms;

    private final List<MetricAlarm> metricAlarms;

    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.compositeAlarms = builder.compositeAlarms;
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompositeAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompositeAlarms() {
        return compositeAlarms != null && !(compositeAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about any composite alarms returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompositeAlarms} method.
     * </p>
     * 
     * @return The information about any composite alarms returned by the operation.
     */
    public final List<CompositeAlarm> compositeAlarms() {
        return compositeAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricAlarms() {
        return metricAlarms != null && !(metricAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about any metric alarms returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricAlarms} method.
     * </p>
     * 
     * @return The information about any metric alarms returned by the operation.
     */
    public final List<MetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCompositeAlarms() ? compositeAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricAlarms() ? metricAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse) obj;
        return hasCompositeAlarms() == other.hasCompositeAlarms() && Objects.equals(compositeAlarms(), other.compositeAlarms())
                && hasMetricAlarms() == other.hasMetricAlarms() && Objects.equals(metricAlarms(), other.metricAlarms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmsResponse").add("CompositeAlarms", hasCompositeAlarms() ? compositeAlarms() : null)
                .add("MetricAlarms", hasMetricAlarms() ? metricAlarms() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompositeAlarms":
            return Optional.ofNullable(clazz.cast(compositeAlarms()));
        case "MetricAlarms":
            return Optional.ofNullable(clazz.cast(metricAlarms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsResponse, T> g) {
        return obj -> g.apply((DescribeAlarmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmsResponse> {
        /**
         * <p>
         * The information about any composite alarms returned by the operation.
         * </p>
         * 
         * @param compositeAlarms
         *        The information about any composite alarms returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeAlarms(Collection<CompositeAlarm> compositeAlarms);

        /**
         * <p>
         * The information about any composite alarms returned by the operation.
         * </p>
         * 
         * @param compositeAlarms
         *        The information about any composite alarms returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeAlarms(CompositeAlarm... compositeAlarms);

        /**
         * <p>
         * The information about any composite alarms returned by the operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CompositeAlarm>.Builder} avoiding
         * the need to create one manually via {@link List<CompositeAlarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompositeAlarm>.Builder#build()} is called immediately and
         * its result is passed to {@link #compositeAlarms(List<CompositeAlarm>)}.
         * 
         * @param compositeAlarms
         *        a consumer that will call methods on {@link List<CompositeAlarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositeAlarms(List<CompositeAlarm>)
         */
        Builder compositeAlarms(Consumer<CompositeAlarm.Builder>... compositeAlarms);

        /**
         * <p>
         * The information about any metric alarms returned by the operation.
         * </p>
         * 
         * @param metricAlarms
         *        The information about any metric alarms returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<MetricAlarm> metricAlarms);

        /**
         * <p>
         * The information about any metric alarms returned by the operation.
         * </p>
         * 
         * @param metricAlarms
         *        The information about any metric alarms returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(MetricAlarm... metricAlarms);

        /**
         * <p>
         * The information about any metric alarms returned by the operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricAlarm>.Builder} avoiding the
         * need to create one manually via {@link List<MetricAlarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricAlarm>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricAlarms(List<MetricAlarm>)}.
         * 
         * @param metricAlarms
         *        a consumer that will call methods on {@link List<MetricAlarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAlarms(List<MetricAlarm>)
         */
        Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<CompositeAlarm> compositeAlarms = DefaultSdkAutoConstructList.getInstance();

        private List<MetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            super(model);
            compositeAlarms(model.compositeAlarms);
            metricAlarms(model.metricAlarms);
            nextToken(model.nextToken);
        }

        public final List<CompositeAlarm.Builder> getCompositeAlarms() {
            List<CompositeAlarm.Builder> result = CompositeAlarmsCopier.copyToBuilder(this.compositeAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositeAlarms(Collection<CompositeAlarm.BuilderImpl> compositeAlarms) {
            this.compositeAlarms = CompositeAlarmsCopier.copyFromBuilder(compositeAlarms);
        }

        @Override
        @Transient
        public final Builder compositeAlarms(Collection<CompositeAlarm> compositeAlarms) {
            this.compositeAlarms = CompositeAlarmsCopier.copy(compositeAlarms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compositeAlarms(CompositeAlarm... compositeAlarms) {
            compositeAlarms(Arrays.asList(compositeAlarms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compositeAlarms(Consumer<CompositeAlarm.Builder>... compositeAlarms) {
            compositeAlarms(Stream.of(compositeAlarms).map(c -> CompositeAlarm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MetricAlarm.Builder> getMetricAlarms() {
            List<MetricAlarm.Builder> result = MetricAlarmsCopier.copyToBuilder(this.metricAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        @Transient
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms) {
            metricAlarms(Stream.of(metricAlarms).map(c -> MetricAlarm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
