/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<ListDashboardsResponse.Builder, ListDashboardsResponse> {
    private static final SdkField<List<DashboardEntry>> DASHBOARD_ENTRIES_FIELD = SdkField
            .<List<DashboardEntry>> builder(MarshallingType.LIST)
            .memberName("DashboardEntries")
            .getter(getter(ListDashboardsResponse::dashboardEntries))
            .setter(setter(Builder::dashboardEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDashboardsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DashboardEntry> dashboardEntries;

    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardEntries = builder.dashboardEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DashboardEntries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDashboardEntries() {
        return dashboardEntries != null && !(dashboardEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of matching dashboards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDashboardEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of matching dashboards.
     */
    public final List<DashboardEntry> dashboardEntries() {
        return dashboardEntries;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboardEntries() ? dashboardEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse) obj;
        return hasDashboardEntries() == other.hasDashboardEntries()
                && Objects.equals(dashboardEntries(), other.dashboardEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDashboardsResponse")
                .add("DashboardEntries", hasDashboardEntries() ? dashboardEntries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardEntries":
            return Optional.ofNullable(clazz.cast(dashboardEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsResponse, T> g) {
        return obj -> g.apply((ListDashboardsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDashboardsResponse> {
        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * 
         * @param dashboardEntries
         *        The list of matching dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEntries(Collection<DashboardEntry> dashboardEntries);

        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * 
         * @param dashboardEntries
         *        The list of matching dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEntries(DashboardEntry... dashboardEntries);

        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardEntry>.Builder} avoiding the need
         * to create one manually via {@link List<DashboardEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #dashboardEntries(List<DashboardEntry>)}.
         * 
         * @param dashboardEntries
         *        a consumer that will call methods on {@link List<DashboardEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardEntries(List<DashboardEntry>)
         */
        Builder dashboardEntries(Consumer<DashboardEntry.Builder>... dashboardEntries);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<DashboardEntry> dashboardEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            super(model);
            dashboardEntries(model.dashboardEntries);
            nextToken(model.nextToken);
        }

        public final List<DashboardEntry.Builder> getDashboardEntries() {
            List<DashboardEntry.Builder> result = DashboardEntriesCopier.copyToBuilder(this.dashboardEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboardEntries(Collection<DashboardEntry.BuilderImpl> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copyFromBuilder(dashboardEntries);
        }

        @Override
        @Transient
        public final Builder dashboardEntries(Collection<DashboardEntry> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copy(dashboardEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dashboardEntries(DashboardEntry... dashboardEntries) {
            dashboardEntries(Arrays.asList(dashboardEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dashboardEntries(Consumer<DashboardEntry.Builder>... dashboardEntries) {
            dashboardEntries(Stream.of(dashboardEntries).map(c -> DashboardEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
