/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataRequest extends CloudWatchRequest implements
        ToCopyableBuilder<GetMetricDataRequest.Builder, GetMetricDataRequest> {
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField
            .<List<MetricDataQuery>> builder(MarshallingType.LIST)
            .memberName("MetricDataQueries")
            .getter(getter(GetMetricDataRequest::metricDataQueries))
            .setter(setter(Builder::metricDataQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SCAN_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ScanBy")
            .getter(getter(GetMetricDataRequest::scanByAsString)).setter(setter(Builder::scanBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBy").build()).build();

    private static final SdkField<Integer> MAX_DATAPOINTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDatapoints").getter(getter(GetMetricDataRequest::maxDatapoints))
            .setter(setter(Builder::maxDatapoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDatapoints").build()).build();

    private static final SdkField<LabelOptions> LABEL_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("LabelOptions").getter(getter(GetMetricDataRequest::labelOptions)).setter(setter(Builder::labelOptions))
            .constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_QUERIES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, SCAN_BY_FIELD, MAX_DATAPOINTS_FIELD, LABEL_OPTIONS_FIELD));

    private final List<MetricDataQuery> metricDataQueries;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final String scanBy;

    private final Integer maxDatapoints;

    private final LabelOptions labelOptions;

    private GetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.metricDataQueries = builder.metricDataQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.scanBy = builder.scanBy;
        this.maxDatapoints = builder.maxDatapoints;
        this.labelOptions = builder.labelOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataQueries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataQueries() {
        return metricDataQueries != null && !(metricDataQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
     * <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to retrieve, or a
     * math expression to perform on retrieved data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataQueries} method.
     * </p>
     * 
     * @return The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
     *         <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to
     *         retrieve, or a math expression to perform on retrieved data.
     */
    public final List<MetricDataQuery> metricDataQueries() {
        return metricDataQueries;
    }

    /**
     * <p>
     * The time stamp indicating the earliest data to be returned.
     * </p>
     * <p>
     * The value specified is inclusive; results include data points with the specified time stamp.
     * </p>
     * <p>
     * CloudWatch rounds the specified time stamp as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down
     * to 12:32:00.
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34
     * is rounded down to 12:30:00.
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is
     * rounded down to 12:00:00.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the nearest
     * time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at
     * (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you
     * receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using
     * a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15.
     * </p>
     * <p>
     * For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the value
     * of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For example, if the
     * <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>StartTime</code> can get a
     * faster response from CloudWatch than setting 12:07 or 12:29 as the <code>StartTime</code>.
     * </p>
     * 
     * @return The time stamp indicating the earliest data to be returned.</p>
     *         <p>
     *         The value specified is inclusive; results include data points with the specified time stamp.
     *         </p>
     *         <p>
     *         CloudWatch rounds the specified time stamp as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is
     *         rounded down to 12:32:00.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example,
     *         12:32:34 is rounded down to 12:30:00.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example,
     *         12:32:34 is rounded down to 12:00:00.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the
     *         nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you
     *         make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is
     *         rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the
     *         previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15
     *         and 15:07:15.
     *         </p>
     *         <p>
     *         For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with
     *         the value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For
     *         example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as
     *         <code>StartTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the
     *         <code>StartTime</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time stamp indicating the latest data to be returned.
     * </p>
     * <p>
     * The value specified is exclusive; results include data points up to the specified time stamp.
     * </p>
     * <p>
     * For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the value
     * of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For example, if the
     * <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>EndTime</code> can get a faster
     * response from CloudWatch than setting 12:07 or 12:29 as the <code>EndTime</code>.
     * </p>
     * 
     * @return The time stamp indicating the latest data to be returned.</p>
     *         <p>
     *         The value specified is exclusive; results include data points up to the specified time stamp.
     *         </p>
     *         <p>
     *         For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with
     *         the value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For
     *         example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as
     *         <code>EndTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the
     *         <code>EndTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Include this value, if it was returned by the previous <code>GetMetricData</code> operation, to get the next set
     * of data points.
     * </p>
     * 
     * @return Include this value, if it was returned by the previous <code>GetMetricData</code> operation, to get the
     *         next set of data points.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The order in which data points should be returned. <code>TimestampDescending</code> returns the newest data first
     * and paginates when the <code>MaxDatapoints</code> limit is reached. <code>TimestampAscending</code> returns the
     * oldest data first and paginates when the <code>MaxDatapoints</code> limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanBy} will
     * return {@link ScanBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanByAsString}.
     * </p>
     * 
     * @return The order in which data points should be returned. <code>TimestampDescending</code> returns the newest
     *         data first and paginates when the <code>MaxDatapoints</code> limit is reached.
     *         <code>TimestampAscending</code> returns the oldest data first and paginates when the
     *         <code>MaxDatapoints</code> limit is reached.
     * @see ScanBy
     */
    public final ScanBy scanBy() {
        return ScanBy.fromValue(scanBy);
    }

    /**
     * <p>
     * The order in which data points should be returned. <code>TimestampDescending</code> returns the newest data first
     * and paginates when the <code>MaxDatapoints</code> limit is reached. <code>TimestampAscending</code> returns the
     * oldest data first and paginates when the <code>MaxDatapoints</code> limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanBy} will
     * return {@link ScanBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanByAsString}.
     * </p>
     * 
     * @return The order in which data points should be returned. <code>TimestampDescending</code> returns the newest
     *         data first and paginates when the <code>MaxDatapoints</code> limit is reached.
     *         <code>TimestampAscending</code> returns the oldest data first and paginates when the
     *         <code>MaxDatapoints</code> limit is reached.
     * @see ScanBy
     */
    public final String scanByAsString() {
        return scanBy;
    }

    /**
     * <p>
     * The maximum number of data points the request should return before paginating. If you omit this, the default of
     * 100,800 is used.
     * </p>
     * 
     * @return The maximum number of data points the request should return before paginating. If you omit this, the
     *         default of 100,800 is used.
     */
    public final Integer maxDatapoints() {
        return maxDatapoints;
    }

    /**
     * <p>
     * This structure includes the <code>Timezone</code> parameter, which you can use to specify your time zone so that
     * the labels of returned data display the correct time for your time zone.
     * </p>
     * 
     * @return This structure includes the <code>Timezone</code> parameter, which you can use to specify your time zone
     *         so that the labels of returned data display the correct time for your time zone.
     */
    public final LabelOptions labelOptions() {
        return labelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataQueries() ? metricDataQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scanByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxDatapoints());
        hashCode = 31 * hashCode + Objects.hashCode(labelOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest) obj;
        return hasMetricDataQueries() == other.hasMetricDataQueries()
                && Objects.equals(metricDataQueries(), other.metricDataQueries())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(scanByAsString(), other.scanByAsString())
                && Objects.equals(maxDatapoints(), other.maxDatapoints()) && Objects.equals(labelOptions(), other.labelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricDataRequest")
                .add("MetricDataQueries", hasMetricDataQueries() ? metricDataQueries() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("NextToken", nextToken()).add("ScanBy", scanByAsString())
                .add("MaxDatapoints", maxDatapoints()).add("LabelOptions", labelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricDataQueries":
            return Optional.ofNullable(clazz.cast(metricDataQueries()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScanBy":
            return Optional.ofNullable(clazz.cast(scanByAsString()));
        case "MaxDatapoints":
            return Optional.ofNullable(clazz.cast(maxDatapoints()));
        case "LabelOptions":
            return Optional.ofNullable(clazz.cast(labelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataRequest, T> g) {
        return obj -> g.apply((GetMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataRequest> {
        /**
         * <p>
         * The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
         * <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to retrieve, or
         * a math expression to perform on retrieved data.
         * </p>
         * 
         * @param metricDataQueries
         *        The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
         *        <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to
         *        retrieve, or a math expression to perform on retrieved data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries);

        /**
         * <p>
         * The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
         * <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to retrieve, or
         * a math expression to perform on retrieved data.
         * </p>
         * 
         * @param metricDataQueries
         *        The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
         *        <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to
         *        retrieve, or a math expression to perform on retrieved data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataQueries(MetricDataQuery... metricDataQueries);

        /**
         * <p>
         * The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500
         * <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to retrieve, or
         * a math expression to perform on retrieved data.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricDataQuery>.Builder} avoiding
         * the need to create one manually via {@link List<MetricDataQuery>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDataQuery>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricDataQueries(List<MetricDataQuery>)}.
         * 
         * @param metricDataQueries
         *        a consumer that will call methods on {@link List<MetricDataQuery>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataQueries(List<MetricDataQuery>)
         */
        Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries);

        /**
         * <p>
         * The time stamp indicating the earliest data to be returned.
         * </p>
         * <p>
         * The value specified is inclusive; results include data points with the specified time stamp.
         * </p>
         * <p>
         * CloudWatch rounds the specified time stamp as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded
         * down to 12:32:00.
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example,
         * 12:32:34 is rounded down to 12:30:00.
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34
         * is rounded down to 12:00:00.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the nearest
         * time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query
         * at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and
         * you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
         * data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15.
         * </p>
         * <p>
         * For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the
         * value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For example, if
         * the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>StartTime</code> can get
         * a faster response from CloudWatch than setting 12:07 or 12:29 as the <code>StartTime</code>.
         * </p>
         * 
         * @param startTime
         *        The time stamp indicating the earliest data to be returned.</p>
         *        <p>
         *        The value specified is inclusive; results include data points with the specified time stamp.
         *        </p>
         *        <p>
         *        CloudWatch rounds the specified time stamp as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is
         *        rounded down to 12:32:00.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For
         *        example, 12:32:34 is rounded down to 12:30:00.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example,
         *        12:32:34 is rounded down to 12:00:00.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the
         *        nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you
         *        make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request
         *        is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for
         *        the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between
         *        15:02:15 and 15:07:15.
         *        </p>
         *        <p>
         *        For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with
         *        the value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For
         *        example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as
         *        <code>StartTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the
         *        <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time stamp indicating the latest data to be returned.
         * </p>
         * <p>
         * The value specified is exclusive; results include data points up to the specified time stamp.
         * </p>
         * <p>
         * For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the
         * value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For example, if
         * the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>EndTime</code> can get a
         * faster response from CloudWatch than setting 12:07 or 12:29 as the <code>EndTime</code>.
         * </p>
         * 
         * @param endTime
         *        The time stamp indicating the latest data to be returned.</p>
         *        <p>
         *        The value specified is exclusive; results include data points up to the specified time stamp.
         *        </p>
         *        <p>
         *        For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with
         *        the value of the metric's <code>Period</code> and sync up with the beginning and end of an hour. For
         *        example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as
         *        <code>EndTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the
         *        <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Include this value, if it was returned by the previous <code>GetMetricData</code> operation, to get the next
         * set of data points.
         * </p>
         * 
         * @param nextToken
         *        Include this value, if it was returned by the previous <code>GetMetricData</code> operation, to get
         *        the next set of data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The order in which data points should be returned. <code>TimestampDescending</code> returns the newest data
         * first and paginates when the <code>MaxDatapoints</code> limit is reached. <code>TimestampAscending</code>
         * returns the oldest data first and paginates when the <code>MaxDatapoints</code> limit is reached.
         * </p>
         * 
         * @param scanBy
         *        The order in which data points should be returned. <code>TimestampDescending</code> returns the newest
         *        data first and paginates when the <code>MaxDatapoints</code> limit is reached.
         *        <code>TimestampAscending</code> returns the oldest data first and paginates when the
         *        <code>MaxDatapoints</code> limit is reached.
         * @see ScanBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanBy
         */
        Builder scanBy(String scanBy);

        /**
         * <p>
         * The order in which data points should be returned. <code>TimestampDescending</code> returns the newest data
         * first and paginates when the <code>MaxDatapoints</code> limit is reached. <code>TimestampAscending</code>
         * returns the oldest data first and paginates when the <code>MaxDatapoints</code> limit is reached.
         * </p>
         * 
         * @param scanBy
         *        The order in which data points should be returned. <code>TimestampDescending</code> returns the newest
         *        data first and paginates when the <code>MaxDatapoints</code> limit is reached.
         *        <code>TimestampAscending</code> returns the oldest data first and paginates when the
         *        <code>MaxDatapoints</code> limit is reached.
         * @see ScanBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanBy
         */
        Builder scanBy(ScanBy scanBy);

        /**
         * <p>
         * The maximum number of data points the request should return before paginating. If you omit this, the default
         * of 100,800 is used.
         * </p>
         * 
         * @param maxDatapoints
         *        The maximum number of data points the request should return before paginating. If you omit this, the
         *        default of 100,800 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDatapoints(Integer maxDatapoints);

        /**
         * <p>
         * This structure includes the <code>Timezone</code> parameter, which you can use to specify your time zone so
         * that the labels of returned data display the correct time for your time zone.
         * </p>
         * 
         * @param labelOptions
         *        This structure includes the <code>Timezone</code> parameter, which you can use to specify your time
         *        zone so that the labels of returned data display the correct time for your time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelOptions(LabelOptions labelOptions);

        /**
         * <p>
         * This structure includes the <code>Timezone</code> parameter, which you can use to specify your time zone so
         * that the labels of returned data display the correct time for your time zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #labelOptions(LabelOptions)}.
         * 
         * @param labelOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelOptions(LabelOptions)
         */
        default Builder labelOptions(Consumer<LabelOptions.Builder> labelOptions) {
            return labelOptions(LabelOptions.builder().applyMutation(labelOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private String scanBy;

        private Integer maxDatapoints;

        private LabelOptions labelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataRequest model) {
            super(model);
            metricDataQueries(model.metricDataQueries);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            scanBy(model.scanBy);
            maxDatapoints(model.maxDatapoints);
            labelOptions(model.labelOptions);
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery... metricDataQueries) {
            metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder>... metricDataQueries) {
            metricDataQueries(Stream.of(metricDataQueries).map(c -> MetricDataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanBy() {
            return scanBy;
        }

        public final void setScanBy(String scanBy) {
            this.scanBy = scanBy;
        }

        @Override
        public final Builder scanBy(String scanBy) {
            this.scanBy = scanBy;
            return this;
        }

        @Override
        public final Builder scanBy(ScanBy scanBy) {
            this.scanBy(scanBy == null ? null : scanBy.toString());
            return this;
        }

        public final Integer getMaxDatapoints() {
            return maxDatapoints;
        }

        public final void setMaxDatapoints(Integer maxDatapoints) {
            this.maxDatapoints = maxDatapoints;
        }

        @Override
        public final Builder maxDatapoints(Integer maxDatapoints) {
            this.maxDatapoints = maxDatapoints;
            return this;
        }

        public final LabelOptions.Builder getLabelOptions() {
            return labelOptions != null ? labelOptions.toBuilder() : null;
        }

        public final void setLabelOptions(LabelOptions.BuilderImpl labelOptions) {
            this.labelOptions = labelOptions != null ? labelOptions.build() : null;
        }

        @Override
        public final Builder labelOptions(LabelOptions labelOptions) {
            this.labelOptions = labelOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataRequest build() {
            return new GetMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
