/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutCompositeAlarmRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutCompositeAlarmRequest.Builder, PutCompositeAlarmRequest> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActionsEnabled").getter(getter(PutCompositeAlarmRequest::actionsEnabled))
            .setter(setter(Builder::actionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()).build();

    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmActions")
            .getter(getter(PutCompositeAlarmRequest::alarmActions))
            .setter(setter(Builder::alarmActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmDescription").getter(getter(PutCompositeAlarmRequest::alarmDescription))
            .setter(setter(Builder::alarmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()).build();

    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmName").getter(getter(PutCompositeAlarmRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> ALARM_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmRule").getter(getter(PutCompositeAlarmRequest::alarmRule)).setter(setter(Builder::alarmRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmRule").build()).build();

    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsufficientDataActions")
            .getter(getter(PutCompositeAlarmRequest::insufficientDataActions))
            .setter(setter(Builder::insufficientDataActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OKActions")
            .getter(getter(PutCompositeAlarmRequest::okActions))
            .setter(setter(Builder::okActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutCompositeAlarmRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD,
            ALARM_ACTIONS_FIELD, ALARM_DESCRIPTION_FIELD, ALARM_NAME_FIELD, ALARM_RULE_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD,
            OK_ACTIONS_FIELD, TAGS_FIELD));

    private final Boolean actionsEnabled;

    private final List<String> alarmActions;

    private final String alarmDescription;

    private final String alarmName;

    private final String alarmRule;

    private final List<String> insufficientDataActions;

    private final List<String> okActions;

    private final List<Tag> tags;

    private PutCompositeAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.alarmRule = builder.alarmRule;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.okActions = builder.okActions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. The
     * default is <code>TRUE</code>.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state of the composite
     *         alarm. The default is <code>TRUE</code>.
     */
    public final Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlarmActions() {
        return alarmActions != null && !(alarmActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
     * action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
     * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmActions} method.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state.
     *         Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
     *         <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
     */
    public final List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * <p>
     * The description for the composite alarm.
     * </p>
     * 
     * @return The description for the composite alarm.
     */
    public final String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * The name for the composite alarm. This name must be unique within the Region.
     * </p>
     * 
     * @return The name for the composite alarm. This name must be unique within the Region.
     */
    public final String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     * For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in
     * ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple
     * functions in a single expression. You can use parenthesis to logically group the functions in your expression.
     * </p>
     * <p>
     * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
     * </p>
     * <p>
     * Functions can include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in ALARM state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OK("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in OK state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in
     * INSUFFICIENT_DATA state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRUE</code> always evaluates to TRUE.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FALSE</code> always evaluates to FALSE.
     * </p>
     * </li>
     * </ul>
     * <p>
     * TRUE and FALSE are useful for testing a complex <code>AlarmRule</code> structure, and for testing your alarm
     * actions.
     * </p>
     * <p>
     * Alarm names specified in <code>AlarmRule</code> can be surrounded with double-quotes ("), but do not have to be.
     * </p>
     * <p>
     * The following are some examples of <code>AlarmRule</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)</code> specifies that the composite alarm goes
     * into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)</code> specifies that the alarm goes to
     * ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM state. This
     * example reduces alarm noise during a known deployment window.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)</code> goes into
     * ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if NetworkOutTooHigh is in OK
     * state. This provides another example of using a composite alarm to prevent noise. This rule ensures that you are
     * not notified with an alarm action on high CPU or disk usage if a known network problem is also occurring.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>AlarmRule</code> can specify as many as 100 "children" alarms. The <code>AlarmRule</code> expression
     * can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and parentheses.
     * </p>
     * 
     * @return An expression that specifies which other alarms are to be evaluated to determine this composite alarm's
     *         state. For each alarm that you reference, you designate a function that specifies whether that alarm
     *         needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT)
     *         to combine multiple functions in a single expression. You can use parenthesis to logically group the
     *         functions in your expression.</p>
     *         <p>
     *         You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
     *         </p>
     *         <p>
     *         Functions can include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in ALARM state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OK("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in OK state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in
     *         INSUFFICIENT_DATA state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRUE</code> always evaluates to TRUE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FALSE</code> always evaluates to FALSE.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         TRUE and FALSE are useful for testing a complex <code>AlarmRule</code> structure, and for testing your
     *         alarm actions.
     *         </p>
     *         <p>
     *         Alarm names specified in <code>AlarmRule</code> can be surrounded with double-quotes ("), but do not have
     *         to be.
     *         </p>
     *         <p>
     *         The following are some examples of <code>AlarmRule</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)</code> specifies that the composite
     *         alarm goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM
     *         state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)</code> specifies that the alarm
     *         goes to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM
     *         state. This example reduces alarm noise during a known deployment window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)</code> goes
     *         into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if
     *         NetworkOutTooHigh is in OK state. This provides another example of using a composite alarm to prevent
     *         noise. This rule ensures that you are not notified with an alarm action on high CPU or disk usage if a
     *         known network problem is also occurring.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>AlarmRule</code> can specify as many as 100 "children" alarms. The <code>AlarmRule</code>
     *         expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and
     *         parentheses.
     */
    public final String alarmRule() {
        return alarmRule;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsufficientDataActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInsufficientDataActions() {
        return insufficientDataActions != null && !(insufficientDataActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
     * state. Each action is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsufficientDataActions} method.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any
     *         other state. Each action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
     */
    public final List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OKActions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOkActions() {
        return okActions != null && !(okActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action
     * is specified as an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOkActions} method.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
     *         action is specified as an Amazon Resource Name (ARN).</p>
     *         <p>
     *         Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
     */
    public final List<String> okActions() {
        return okActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an
     * alarm.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags
     *         with an alarm.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user
     *         permissions, by granting a user permission to access or change only resources with certain tag values.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmActions() ? alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsufficientDataActions() ? insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOkActions() ? okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCompositeAlarmRequest)) {
            return false;
        }
        PutCompositeAlarmRequest other = (PutCompositeAlarmRequest) obj;
        return Objects.equals(actionsEnabled(), other.actionsEnabled()) && hasAlarmActions() == other.hasAlarmActions()
                && Objects.equals(alarmActions(), other.alarmActions())
                && Objects.equals(alarmDescription(), other.alarmDescription()) && Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(alarmRule(), other.alarmRule())
                && hasInsufficientDataActions() == other.hasInsufficientDataActions()
                && Objects.equals(insufficientDataActions(), other.insufficientDataActions())
                && hasOkActions() == other.hasOkActions() && Objects.equals(okActions(), other.okActions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutCompositeAlarmRequest").add("ActionsEnabled", actionsEnabled())
                .add("AlarmActions", hasAlarmActions() ? alarmActions() : null).add("AlarmDescription", alarmDescription())
                .add("AlarmName", alarmName()).add("AlarmRule", alarmRule())
                .add("InsufficientDataActions", hasInsufficientDataActions() ? insufficientDataActions() : null)
                .add("OKActions", hasOkActions() ? okActions() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionsEnabled":
            return Optional.ofNullable(clazz.cast(actionsEnabled()));
        case "AlarmActions":
            return Optional.ofNullable(clazz.cast(alarmActions()));
        case "AlarmDescription":
            return Optional.ofNullable(clazz.cast(alarmDescription()));
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "AlarmRule":
            return Optional.ofNullable(clazz.cast(alarmRule()));
        case "InsufficientDataActions":
            return Optional.ofNullable(clazz.cast(insufficientDataActions()));
        case "OKActions":
            return Optional.ofNullable(clazz.cast(okActions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCompositeAlarmRequest, T> g) {
        return obj -> g.apply((PutCompositeAlarmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutCompositeAlarmRequest> {
        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
         * The default is <code>TRUE</code>.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state of the composite
         *        alarm. The default is <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
         * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
         *        <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
         * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
         * </p>
         * 
         * @param alarmActions
         *        The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other
         *        state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> |
         *        <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The description for the composite alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description for the composite alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * The name for the composite alarm. This name must be unique within the Region.
         * </p>
         * 
         * @param alarmName
         *        The name for the composite alarm. This name must be unique within the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's
         * state. For each alarm that you reference, you designate a function that specifies whether that alarm needs to
         * be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine
         * multiple functions in a single expression. You can use parenthesis to logically group the functions in your
         * expression.
         * </p>
         * <p>
         * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
         * </p>
         * <p>
         * Functions can include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in ALARM state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in OK state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in
         * INSUFFICIENT_DATA state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRUE</code> always evaluates to TRUE.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FALSE</code> always evaluates to FALSE.
         * </p>
         * </li>
         * </ul>
         * <p>
         * TRUE and FALSE are useful for testing a complex <code>AlarmRule</code> structure, and for testing your alarm
         * actions.
         * </p>
         * <p>
         * Alarm names specified in <code>AlarmRule</code> can be surrounded with double-quotes ("), but do not have to
         * be.
         * </p>
         * <p>
         * The following are some examples of <code>AlarmRule</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)</code> specifies that the composite alarm
         * goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)</code> specifies that the alarm goes
         * to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM state.
         * This example reduces alarm noise during a known deployment window.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)</code> goes into
         * ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if NetworkOutTooHigh is in
         * OK state. This provides another example of using a composite alarm to prevent noise. This rule ensures that
         * you are not notified with an alarm action on high CPU or disk usage if a known network problem is also
         * occurring.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>AlarmRule</code> can specify as many as 100 "children" alarms. The <code>AlarmRule</code>
         * expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and
         * parentheses.
         * </p>
         * 
         * @param alarmRule
         *        An expression that specifies which other alarms are to be evaluated to determine this composite
         *        alarm's state. For each alarm that you reference, you designate a function that specifies whether that
         *        alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR
         *        and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically
         *        group the functions in your expression.</p>
         *        <p>
         *        You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
         *        </p>
         *        <p>
         *        Functions can include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in ALARM
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in OK state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is
         *        in INSUFFICIENT_DATA state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRUE</code> always evaluates to TRUE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FALSE</code> always evaluates to FALSE.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        TRUE and FALSE are useful for testing a complex <code>AlarmRule</code> structure, and for testing your
         *        alarm actions.
         *        </p>
         *        <p>
         *        Alarm names specified in <code>AlarmRule</code> can be surrounded with double-quotes ("), but do not
         *        have to be.
         *        </p>
         *        <p>
         *        The following are some examples of <code>AlarmRule</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)</code> specifies that the composite
         *        alarm goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in
         *        ALARM state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)</code> specifies that the alarm
         *        goes to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in
         *        ALARM state. This example reduces alarm noise during a known deployment window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)</code>
         *        goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if
         *        NetworkOutTooHigh is in OK state. This provides another example of using a composite alarm to prevent
         *        noise. This rule ensures that you are not notified with an alarm action on high CPU or disk usage if a
         *        known network problem is also occurring.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>AlarmRule</code> can specify as many as 100 "children" alarms. The <code>AlarmRule</code>
         *        expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and
         *        parentheses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRule(String alarmRule);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each
         * action is specified as an Amazon Resource Name (ARN).
         * </p>
         * <p>
         * Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to an <code>OK</code> state from any other state.
         *        Each action is specified as an Amazon Resource Name (ARN).</p>
         *        <p>
         *        Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an
         * alarm.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags
         *        with an alarm.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions, by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an
         * alarm.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags
         *        with an alarm.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions, by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an
         * alarm.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private Boolean actionsEnabled;

        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private String alarmDescription;

        private String alarmName;

        private String alarmRule;

        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutCompositeAlarmRequest model) {
            super(model);
            actionsEnabled(model.actionsEnabled);
            alarmActions(model.alarmActions);
            alarmDescription(model.alarmDescription);
            alarmName(model.alarmName);
            alarmRule(model.alarmRule);
            insufficientDataActions(model.insufficientDataActions);
            okActions(model.okActions);
            tags(model.tags);
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final String getAlarmName() {
            return alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmRule() {
            return alarmRule;
        }

        public final void setAlarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
        }

        @Override
        public final Builder alarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final Collection<String> getOkActions() {
            if (okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            okActions(Arrays.asList(okActions));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCompositeAlarmRequest build() {
            return new PutCompositeAlarmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
