/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricStreamsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<ListMetricStreamsResponse.Builder, ListMetricStreamsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMetricStreamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MetricStreamEntry>> ENTRIES_FIELD = SdkField
            .<List<MetricStreamEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(ListMetricStreamsResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricStreamEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricStreamEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENTRIES_FIELD));

    private final String nextToken;

    private final List<MetricStreamEntry> entries;

    private ListMetricStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results. You can use this token in a subsequent
     * operation to get the next batch of results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results. You can use this token in a
     *         subsequent operation to get the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of metric stream information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return The array of metric stream information.
     */
    public final List<MetricStreamEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricStreamsResponse)) {
            return false;
        }
        ListMetricStreamsResponse other = (ListMetricStreamsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEntries() == other.hasEntries()
                && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricStreamsResponse").add("NextToken", nextToken())
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricStreamsResponse, T> g) {
        return obj -> g.apply((ListMetricStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricStreamsResponse> {
        /**
         * <p>
         * The token that marks the start of the next batch of returned results. You can use this token in a subsequent
         * operation to get the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results. You can use this token in a
         *        subsequent operation to get the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The array of metric stream information.
         * </p>
         * 
         * @param entries
         *        The array of metric stream information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<MetricStreamEntry> entries);

        /**
         * <p>
         * The array of metric stream information.
         * </p>
         * 
         * @param entries
         *        The array of metric stream information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(MetricStreamEntry... entries);

        /**
         * <p>
         * The array of metric stream information.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricStreamEntry>.Builder} avoiding
         * the need to create one manually via {@link List<MetricStreamEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricStreamEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #entries(List<MetricStreamEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<MetricStreamEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<MetricStreamEntry>)
         */
        Builder entries(Consumer<MetricStreamEntry.Builder>... entries);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MetricStreamEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricStreamsResponse model) {
            super(model);
            nextToken(model.nextToken);
            entries(model.entries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MetricStreamEntry.Builder> getEntries() {
            List<MetricStreamEntry.Builder> result = MetricStreamEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<MetricStreamEntry.BuilderImpl> entries) {
            this.entries = MetricStreamEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<MetricStreamEntry> entries) {
            this.entries = MetricStreamEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(MetricStreamEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<MetricStreamEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> MetricStreamEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMetricStreamsResponse build() {
            return new ListMetricStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
