/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricWidgetImageResponse extends CloudWatchResponse implements
        ToCopyableBuilder<GetMetricWidgetImageResponse.Builder, GetMetricWidgetImageResponse> {
    private static final SdkField<SdkBytes> METRIC_WIDGET_IMAGE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("MetricWidgetImage").getter(getter(GetMetricWidgetImageResponse::metricWidgetImage))
            .setter(setter(Builder::metricWidgetImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricWidgetImage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_WIDGET_IMAGE_FIELD));

    private final SdkBytes metricWidgetImage;

    private GetMetricWidgetImageResponse(BuilderImpl builder) {
        super(builder);
        this.metricWidgetImage = builder.metricWidgetImage;
    }

    /**
     * <p>
     * The image of the graph, in the output format specified. The output is base64-encoded.
     * </p>
     * 
     * @return The image of the graph, in the output format specified. The output is base64-encoded.
     */
    public final SdkBytes metricWidgetImage() {
        return metricWidgetImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricWidgetImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricWidgetImageResponse)) {
            return false;
        }
        GetMetricWidgetImageResponse other = (GetMetricWidgetImageResponse) obj;
        return Objects.equals(metricWidgetImage(), other.metricWidgetImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricWidgetImageResponse").add("MetricWidgetImage", metricWidgetImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricWidgetImage":
            return Optional.ofNullable(clazz.cast(metricWidgetImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricWidgetImageResponse, T> g) {
        return obj -> g.apply((GetMetricWidgetImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricWidgetImageResponse> {
        /**
         * <p>
         * The image of the graph, in the output format specified. The output is base64-encoded.
         * </p>
         * 
         * @param metricWidgetImage
         *        The image of the graph, in the output format specified. The output is base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricWidgetImage(SdkBytes metricWidgetImage);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private SdkBytes metricWidgetImage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricWidgetImageResponse model) {
            super(model);
            metricWidgetImage(model.metricWidgetImage);
        }

        public final ByteBuffer getMetricWidgetImage() {
            return metricWidgetImage == null ? null : metricWidgetImage.asByteBuffer();
        }

        public final void setMetricWidgetImage(ByteBuffer metricWidgetImage) {
            metricWidgetImage(metricWidgetImage == null ? null : SdkBytes.fromByteBuffer(metricWidgetImage));
        }

        @Override
        public final Builder metricWidgetImage(SdkBytes metricWidgetImage) {
            this.metricWidgetImage = metricWidgetImage;
            return this;
        }

        @Override
        public GetMetricWidgetImageResponse build() {
            return new GetMetricWidgetImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
