/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedInsightRulesResponse extends CloudWatchResponse implements
        ToCopyableBuilder<ListManagedInsightRulesResponse.Builder, ListManagedInsightRulesResponse> {
    private static final SdkField<List<ManagedRuleDescription>> MANAGED_RULES_FIELD = SdkField
            .<List<ManagedRuleDescription>> builder(MarshallingType.LIST)
            .memberName("ManagedRules")
            .getter(getter(ListManagedInsightRulesResponse::managedRules))
            .setter(setter(Builder::managedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedRuleDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedRuleDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListManagedInsightRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ManagedRuleDescription> managedRules;

    private final String nextToken;

    private ListManagedInsightRulesResponse(BuilderImpl builder) {
        super(builder);
        this.managedRules = builder.managedRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedRules() {
        return managedRules != null && !(managedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The managed rules that are available for the specified Amazon Web Services resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedRules} method.
     * </p>
     * 
     * @return The managed rules that are available for the specified Amazon Web Services resource.
     */
    public final List<ManagedRuleDescription> managedRules() {
        return managedRules;
    }

    /**
     * <p>
     * Include this value to get the next set of rules if the value was returned by the previous operation.
     * </p>
     * 
     * @return Include this value to get the next set of rules if the value was returned by the previous operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedRules() ? managedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedInsightRulesResponse)) {
            return false;
        }
        ListManagedInsightRulesResponse other = (ListManagedInsightRulesResponse) obj;
        return hasManagedRules() == other.hasManagedRules() && Objects.equals(managedRules(), other.managedRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedInsightRulesResponse").add("ManagedRules", hasManagedRules() ? managedRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedRules":
            return Optional.ofNullable(clazz.cast(managedRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedInsightRulesResponse, T> g) {
        return obj -> g.apply((ListManagedInsightRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedInsightRulesResponse> {
        /**
         * <p>
         * The managed rules that are available for the specified Amazon Web Services resource.
         * </p>
         * 
         * @param managedRules
         *        The managed rules that are available for the specified Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(Collection<ManagedRuleDescription> managedRules);

        /**
         * <p>
         * The managed rules that are available for the specified Amazon Web Services resource.
         * </p>
         * 
         * @param managedRules
         *        The managed rules that are available for the specified Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(ManagedRuleDescription... managedRules);

        /**
         * <p>
         * The managed rules that are available for the specified Amazon Web Services resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ManagedRuleDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ManagedRuleDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedRuleDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #managedRules(List<ManagedRuleDescription>)}.
         * 
         * @param managedRules
         *        a consumer that will call methods on {@link List<ManagedRuleDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRules(List<ManagedRuleDescription>)
         */
        Builder managedRules(Consumer<ManagedRuleDescription.Builder>... managedRules);

        /**
         * <p>
         * Include this value to get the next set of rules if the value was returned by the previous operation.
         * </p>
         * 
         * @param nextToken
         *        Include this value to get the next set of rules if the value was returned by the previous operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<ManagedRuleDescription> managedRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedInsightRulesResponse model) {
            super(model);
            managedRules(model.managedRules);
            nextToken(model.nextToken);
        }

        public final List<ManagedRuleDescription.Builder> getManagedRules() {
            List<ManagedRuleDescription.Builder> result = ManagedRuleDescriptionsCopier.copyToBuilder(this.managedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedRules(Collection<ManagedRuleDescription.BuilderImpl> managedRules) {
            this.managedRules = ManagedRuleDescriptionsCopier.copyFromBuilder(managedRules);
        }

        @Override
        public final Builder managedRules(Collection<ManagedRuleDescription> managedRules) {
            this.managedRules = ManagedRuleDescriptionsCopier.copy(managedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(ManagedRuleDescription... managedRules) {
            managedRules(Arrays.asList(managedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(Consumer<ManagedRuleDescription.Builder>... managedRules) {
            managedRules(Stream.of(managedRules).map(c -> ManagedRuleDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedInsightRulesResponse build() {
            return new ListManagedInsightRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
