/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the metric to be returned, along with the statistics, period, and units.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricStat implements SdkPojo, Serializable, ToCopyableBuilder<MetricStat.Builder, MetricStat> {
    private static final SdkField<Metric> METRIC_FIELD = SdkField.<Metric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(MetricStat::metric)).setter(setter(Builder::metric)).constructor(Metric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(MetricStat::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(MetricStat::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(MetricStat::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, PERIOD_FIELD,
            STAT_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Metric metric;

    private final Integer period;

    private final String stat;

    private final String unit;

    private MetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.period = builder.period;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The metric to return, including the metric name, namespace, and dimensions.
     * </p>
     * 
     * @return The metric to return, including the metric name, namespace, and dimensions.
     */
    public final Metric metric() {
        return metric;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> call that includes a
     * <code>StorageResolution</code> of 1 second.
     * </p>
     * <p>
     * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify
     * the period as follows or no data points in that time range is returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period
     *         can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     *         are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple
     *         of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that
     *         includes a <code>StorageResolution</code> of 1 second.</p>
     *         <p>
     *         If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must
     *         specify the period as follows or no data points in that time range is returned:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
     *         </p>
     *         </li>
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The statistic to return. It can include any CloudWatch statistic or extended statistic.
     * </p>
     * 
     * @return The statistic to return. It can include any CloudWatch statistic or extended statistic.
     */
    public final String stat() {
        return stat;
    }

    /**
     * <p>
     * When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.
     * </p>
     * <p>
     * In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is
     * returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you
     * specify a unit, the operation returns only data that was collected with that unit specified. If you specify a
     * unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform
     * unit conversions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the
     *         metric.</p>
     *         <p>
     *         In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any
     *         unit is returned, along with the corresponding units that were specified when the data was reported to
     *         CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit
     *         specified. If you specify a unit that does not match the data collected, the results of the operation are
     *         null. CloudWatch does not perform unit conversions.
     * @see StandardUnit
     */
    public final StandardUnit unit() {
        return StandardUnit.fromValue(unit);
    }

    /**
     * <p>
     * When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.
     * </p>
     * <p>
     * In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is
     * returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you
     * specify a unit, the operation returns only data that was collected with that unit specified. If you specify a
     * unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform
     * unit conversions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link StandardUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the
     *         metric.</p>
     *         <p>
     *         In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any
     *         unit is returned, along with the corresponding units that were specified when the data was reported to
     *         CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit
     *         specified. If you specify a unit that does not match the data collected, the results of the operation are
     *         null. CloudWatch does not perform unit conversions.
     * @see StandardUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStat)) {
            return false;
        }
        MetricStat other = (MetricStat) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(period(), other.period())
                && Objects.equals(stat(), other.stat()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricStat").add("Metric", metric()).add("Period", period()).add("Stat", stat())
                .add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricStat, T> g) {
        return obj -> g.apply((MetricStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricStat> {
        /**
         * <p>
         * The metric to return, including the metric name, namespace, and dimensions.
         * </p>
         * 
         * @param metric
         *        The metric to return, including the metric name, namespace, and dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(Metric metric);

        /**
         * <p>
         * The metric to return, including the metric name, namespace, and dimensions.
         * </p>
         * This is a convenience that creates an instance of the {@link Metric.Builder} avoiding the need to create one
         * manually via {@link Metric#builder()}.
         *
         * When the {@link Consumer} completes, {@link Metric.Builder#build()} is called immediately and its result is
         * passed to {@link #metric(Metric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(Metric)
         */
        default Builder metric(Consumer<Metric.Builder> metric) {
            return metric(Metric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
         * be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are
         * collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60.
         * High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a
         * <code>StorageResolution</code> of 1 second.
         * </p>
         * <p>
         * If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must
         * specify the period as follows or no data points in that time range is returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         * </p>
         * </li>
         * </ul>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
         *        period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution
         *        metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
         *        or any multiple of 60. High-resolution metrics are those metrics stored by a
         *        <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
         *        <p>
         *        If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you
         *        must specify the period as follows or no data points in that time range is returned:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The statistic to return. It can include any CloudWatch statistic or extended statistic.
         * </p>
         * 
         * @param stat
         *        The statistic to return. It can include any CloudWatch statistic or extended statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stat(String stat);

        /**
         * <p>
         * When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the
         * metric.
         * </p>
         * <p>
         * In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit
         * is returned, along with the corresponding units that were specified when the data was reported to CloudWatch.
         * If you specify a unit, the operation returns only data that was collected with that unit specified. If you
         * specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does
         * not perform unit conversions.
         * </p>
         * 
         * @param unit
         *        When you are using a <code>Put</code> operation, this defines what unit you want to use when storing
         *        the metric.</p>
         *        <p>
         *        In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with
         *        any unit is returned, along with the corresponding units that were specified when the data was
         *        reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with
         *        that unit specified. If you specify a unit that does not match the data collected, the results of the
         *        operation are null. CloudWatch does not perform unit conversions.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the
         * metric.
         * </p>
         * <p>
         * In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit
         * is returned, along with the corresponding units that were specified when the data was reported to CloudWatch.
         * If you specify a unit, the operation returns only data that was collected with that unit specified. If you
         * specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does
         * not perform unit conversions.
         * </p>
         * 
         * @param unit
         *        When you are using a <code>Put</code> operation, this defines what unit you want to use when storing
         *        the metric.</p>
         *        <p>
         *        In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with
         *        any unit is returned, along with the corresponding units that were specified when the data was
         *        reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with
         *        that unit specified. If you specify a unit that does not match the data collected, the results of the
         *        operation are null. CloudWatch does not perform unit conversions.
         * @see StandardUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardUnit
         */
        Builder unit(StandardUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Metric metric;

        private Integer period;

        private String stat;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStat model) {
            metric(model.metric);
            period(model.period);
            stat(model.stat);
            unit(model.unit);
        }

        public final Metric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        @Transient
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        @Transient
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStat() {
            return stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        @Transient
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public MetricStat build() {
            return new MetricStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
