/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetAlarmStateRequest extends CloudWatchRequest implements
        ToCopyableBuilder<SetAlarmStateRequest.Builder, SetAlarmStateRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetAlarmStateRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetAlarmStateRequest::stateValueAsString)).setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetAlarmStateRequest::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetAlarmStateRequest::stateReasonData)).setter(setter(Builder::stateReasonData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            STATE_VALUE_FIELD, STATE_REASON_FIELD, STATE_REASON_DATA_FIELD));

    private final String alarmName;

    private final String stateValue;

    private final String stateReason;

    private final String stateReasonData;

    private SetAlarmStateRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
    }

    /**
     * <p>
     * The name for the alarm. This name must be unique within the AWS account. The maximum length is 255 characters.
     * </p>
     * 
     * @return The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
     *         characters.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The value of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The value of the state.
     * @see StateValue
     */
    public StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The value of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The value of the state.
     * @see StateValue
     */
    public String stateValueAsString() {
        return stateValue;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in text format.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in text format.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in JSON format.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in JSON format.
     */
    public String stateReasonData() {
        return stateReasonData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetAlarmStateRequest)) {
            return false;
        }
        SetAlarmStateRequest other = (SetAlarmStateRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(stateValueAsString(), other.stateValueAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonData(), other.stateReasonData());
    }

    @Override
    public String toString() {
        return ToString.builder("SetAlarmStateRequest").add("AlarmName", alarmName()).add("StateValue", stateValueAsString())
                .add("StateReason", stateReason()).add("StateReasonData", stateReasonData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonData":
            return Optional.ofNullable(clazz.cast(stateReasonData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetAlarmStateRequest, T> g) {
        return obj -> g.apply((SetAlarmStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetAlarmStateRequest> {
        /**
         * <p>
         * The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
         * characters.
         * </p>
         * 
         * @param alarmName
         *        The name for the alarm. This name must be unique within the AWS account. The maximum length is 255
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in text format.
         * </p>
         * 
         * @param stateReason
         *        The reason that this alarm is set to this specific state, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in JSON format.
         * </p>
         * 
         * @param stateReasonData
         *        The reason that this alarm is set to this specific state, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReasonData(String stateReasonData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String stateValue;

        private String stateReason;

        private String stateReasonData;

        private BuilderImpl() {
        }

        private BuilderImpl(SetAlarmStateRequest model) {
            super(model);
            alarmName(model.alarmName);
            stateValue(model.stateValue);
            stateReason(model.stateReason);
            stateReasonData(model.stateReasonData);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetAlarmStateRequest build() {
            return new SetAlarmStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
