/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatch.CloudWatchServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatch.DefaultCloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.DefaultCloudWatchBaseClientBuilder;
import software.amazon.awssdk.services.cloudwatch.endpoints.CloudWatchEndpointProvider;

@SdkInternalApi
final class DefaultCloudWatchAsyncClientBuilder
extends DefaultCloudWatchBaseClientBuilder<CloudWatchAsyncClientBuilder, CloudWatchAsyncClient>
implements CloudWatchAsyncClientBuilder {
    DefaultCloudWatchAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudWatchAsyncClientBuilder endpointProvider(CloudWatchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudWatchAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudWatchAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudWatchServiceClientConfiguration serviceClientConfiguration = CloudWatchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudWatchAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

