/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DescribeAlarmsRequest.Builder, DescribeAlarmsRequest> {
    private static final SdkField<List<String>> ALARM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmNames")
            .getter(getter(DescribeAlarmsRequest::alarmNames))
            .setter(setter(Builder::alarmNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALARM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmNamePrefix").getter(getter(DescribeAlarmsRequest::alarmNamePrefix))
            .setter(setter(Builder::alarmNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmNamePrefix").build()).build();

    private static final SdkField<List<String>> ALARM_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmTypes")
            .getter(getter(DescribeAlarmsRequest::alarmTypesAsStrings))
            .setter(setter(Builder::alarmTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHILDREN_OF_ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChildrenOfAlarmName").getter(getter(DescribeAlarmsRequest::childrenOfAlarmName))
            .setter(setter(Builder::childrenOfAlarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildrenOfAlarmName").build())
            .build();

    private static final SdkField<String> PARENTS_OF_ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentsOfAlarmName").getter(getter(DescribeAlarmsRequest::parentsOfAlarmName))
            .setter(setter(Builder::parentsOfAlarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentsOfAlarmName").build())
            .build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateValue").getter(getter(DescribeAlarmsRequest::stateValueAsString))
            .setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()).build();

    private static final SdkField<String> ACTION_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionPrefix").getter(getter(DescribeAlarmsRequest::actionPrefix)).setter(setter(Builder::actionPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionPrefix").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeAlarmsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAlarmsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAMES_FIELD,
            ALARM_NAME_PREFIX_FIELD, ALARM_TYPES_FIELD, CHILDREN_OF_ALARM_NAME_FIELD, PARENTS_OF_ALARM_NAME_FIELD,
            STATE_VALUE_FIELD, ACTION_PREFIX_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> alarmNames;

    private final String alarmNamePrefix;

    private final List<String> alarmTypes;

    private final String childrenOfAlarmName;

    private final String parentsOfAlarmName;

    private final String stateValue;

    private final String actionPrefix;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.alarmTypes = builder.alarmTypes;
        this.childrenOfAlarmName = builder.childrenOfAlarmName;
        this.parentsOfAlarmName = builder.parentsOfAlarmName;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarmNames() {
        return alarmNames != null && !(alarmNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the alarms to retrieve information about.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmNames} method.
     * </p>
     * 
     * @return The names of the alarms to retrieve information about.
     */
    public final List<String> alarmNames() {
        return alarmNames;
    }

    /**
     * <p>
     * An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names
     * that start with this prefix.
     * </p>
     * <p>
     * If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     * </p>
     * 
     * @return An alarm name prefix. If you specify this parameter, you receive information about all alarms that have
     *         names that start with this prefix.</p>
     *         <p>
     *         If this parameter is specified, you cannot specify <code>AlarmNames</code>.
     */
    public final String alarmNamePrefix() {
        return alarmNamePrefix;
    }

    /**
     * <p>
     * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you
     * omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
     * </p>
     * <p>
     * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a list
     * of metric alarms. It does not return any composite alarms, even if composite alarms exist in the account.
     * </p>
     * <p>
     * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does not
     * return any metric alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmTypes} method.
     * </p>
     * 
     * @return Use this parameter to specify whether you want the operation to return metric alarms or composite alarms.
     *         If you omit this parameter, only metric alarms are returned, even if composite alarms exist in the
     *         account.</p>
     *         <p>
     *         For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only
     *         a list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
     *         account.
     *         </p>
     *         <p>
     *         If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and
     *         does not return any metric alarms.
     */
    public final List<AlarmType> alarmTypes() {
        return AlarmTypesCopier.copyStringToEnum(alarmTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlarmTypes() {
        return alarmTypes != null && !(alarmTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you
     * omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
     * </p>
     * <p>
     * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a list
     * of metric alarms. It does not return any composite alarms, even if composite alarms exist in the account.
     * </p>
     * <p>
     * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does not
     * return any metric alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmTypes} method.
     * </p>
     * 
     * @return Use this parameter to specify whether you want the operation to return metric alarms or composite alarms.
     *         If you omit this parameter, only metric alarms are returned, even if composite alarms exist in the
     *         account.</p>
     *         <p>
     *         For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only
     *         a list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
     *         account.
     *         </p>
     *         <p>
     *         If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and
     *         does not return any metric alarms.
     */
    public final List<String> alarmTypesAsStrings() {
        return alarmTypes;
    }

    /**
     * <p>
     * If you use this parameter and specify the name of a composite alarm, the operation returns information about the
     * "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced in the
     * <code>AlarmRule</code> field of the composite alarm that you specify in <code>ChildrenOfAlarmName</code>.
     * Information about the composite alarm that you name in <code>ChildrenOfAlarmName</code> is not returned.
     * </p>
     * <p>
     * If you specify <code>ChildrenOfAlarmName</code>, you cannot specify any other parameters in the request except
     * for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.
     * </p>
     * <note>
     * <p>
     * Only the <code>Alarm Name</code>, <code>ARN</code>, <code>StateValue</code> (OK/ALARM/INSUFFICIENT_DATA), and
     * <code>StateUpdatedTimestamp</code> information are returned by this operation when you use this parameter. To get
     * complete information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the
     * parent alarm names in the <code>AlarmNames</code> parameter.
     * </p>
     * </note>
     * 
     * @return If you use this parameter and specify the name of a composite alarm, the operation returns information
     *         about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms
     *         referenced in the <code>AlarmRule</code> field of the composite alarm that you specify in
     *         <code>ChildrenOfAlarmName</code>. Information about the composite alarm that you name in
     *         <code>ChildrenOfAlarmName</code> is not returned.</p>
     *         <p>
     *         If you specify <code>ChildrenOfAlarmName</code>, you cannot specify any other parameters in the request
     *         except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation
     *         error.
     *         </p>
     *         <note>
     *         <p>
     *         Only the <code>Alarm Name</code>, <code>ARN</code>, <code>StateValue</code> (OK/ALARM/INSUFFICIENT_DATA),
     *         and <code>StateUpdatedTimestamp</code> information are returned by this operation when you use this
     *         parameter. To get complete information about these alarms, perform another <code>DescribeAlarms</code>
     *         operation and specify the parent alarm names in the <code>AlarmNames</code> parameter.
     *         </p>
     */
    public final String childrenOfAlarmName() {
        return childrenOfAlarmName;
    }

    /**
     * <p>
     * If you use this parameter and specify the name of a metric or composite alarm, the operation returns information
     * about the "parent" alarms of the alarm you specify. These are the composite alarms that have
     * <code>AlarmRule</code> parameters that reference the alarm named in <code>ParentsOfAlarmName</code>. Information
     * about the alarm that you specify in <code>ParentsOfAlarmName</code> is not returned.
     * </p>
     * <p>
     * If you specify <code>ParentsOfAlarmName</code>, you cannot specify any other parameters in the request except for
     * <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.
     * </p>
     * <note>
     * <p>
     * Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete
     * information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the parent
     * alarm names in the <code>AlarmNames</code> parameter.
     * </p>
     * </note>
     * 
     * @return If you use this parameter and specify the name of a metric or composite alarm, the operation returns
     *         information about the "parent" alarms of the alarm you specify. These are the composite alarms that have
     *         <code>AlarmRule</code> parameters that reference the alarm named in <code>ParentsOfAlarmName</code>.
     *         Information about the alarm that you specify in <code>ParentsOfAlarmName</code> is not returned.</p>
     *         <p>
     *         If you specify <code>ParentsOfAlarmName</code>, you cannot specify any other parameters in the request
     *         except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation
     *         error.
     *         </p>
     *         <note>
     *         <p>
     *         Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete
     *         information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the
     *         parent alarm names in the <code>AlarmNames</code> parameter.
     *         </p>
     */
    public final String parentsOfAlarmName() {
        return parentsOfAlarmName;
    }

    /**
     * <p>
     * Specify this parameter to receive information only about alarms that are currently in the state that you specify.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return Specify this parameter to receive information only about alarms that are currently in the state that you
     *         specify.
     * @see StateValue
     */
    public final StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * Specify this parameter to receive information only about alarms that are currently in the state that you specify.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return Specify this parameter to receive information only about alarms that are currently in the state that you
     *         specify.
     * @see StateValue
     */
    public final String stateValueAsString() {
        return stateValue;
    }

    /**
     * <p>
     * Use this parameter to filter the results of the operation to only those alarms that use a certain alarm action.
     * For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to that topic.
     * </p>
     * 
     * @return Use this parameter to filter the results of the operation to only those alarms that use a certain alarm
     *         action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications
     *         to that topic.
     */
    public final String actionPrefix() {
        return actionPrefix;
    }

    /**
     * <p>
     * The maximum number of alarm descriptions to retrieve.
     * </p>
     * 
     * @return The maximum number of alarm descriptions to retrieve.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmNames() ? alarmNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmTypes() ? alarmTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(childrenOfAlarmName());
        hashCode = 31 * hashCode + Objects.hashCode(parentsOfAlarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest) obj;
        return hasAlarmNames() == other.hasAlarmNames() && Objects.equals(alarmNames(), other.alarmNames())
                && Objects.equals(alarmNamePrefix(), other.alarmNamePrefix()) && hasAlarmTypes() == other.hasAlarmTypes()
                && Objects.equals(alarmTypesAsStrings(), other.alarmTypesAsStrings())
                && Objects.equals(childrenOfAlarmName(), other.childrenOfAlarmName())
                && Objects.equals(parentsOfAlarmName(), other.parentsOfAlarmName())
                && Objects.equals(stateValueAsString(), other.stateValueAsString())
                && Objects.equals(actionPrefix(), other.actionPrefix()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmsRequest").add("AlarmNames", hasAlarmNames() ? alarmNames() : null)
                .add("AlarmNamePrefix", alarmNamePrefix()).add("AlarmTypes", hasAlarmTypes() ? alarmTypesAsStrings() : null)
                .add("ChildrenOfAlarmName", childrenOfAlarmName()).add("ParentsOfAlarmName", parentsOfAlarmName())
                .add("StateValue", stateValueAsString()).add("ActionPrefix", actionPrefix()).add("MaxRecords", maxRecords())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmNames":
            return Optional.ofNullable(clazz.cast(alarmNames()));
        case "AlarmNamePrefix":
            return Optional.ofNullable(clazz.cast(alarmNamePrefix()));
        case "AlarmTypes":
            return Optional.ofNullable(clazz.cast(alarmTypesAsStrings()));
        case "ChildrenOfAlarmName":
            return Optional.ofNullable(clazz.cast(childrenOfAlarmName()));
        case "ParentsOfAlarmName":
            return Optional.ofNullable(clazz.cast(parentsOfAlarmName()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        case "ActionPrefix":
            return Optional.ofNullable(clazz.cast(actionPrefix()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsRequest, T> g) {
        return obj -> g.apply((DescribeAlarmsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmsRequest> {
        /**
         * <p>
         * The names of the alarms to retrieve information about.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms to retrieve information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(Collection<String> alarmNames);

        /**
         * <p>
         * The names of the alarms to retrieve information about.
         * </p>
         * 
         * @param alarmNames
         *        The names of the alarms to retrieve information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNames(String... alarmNames);

        /**
         * <p>
         * An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names
         * that start with this prefix.
         * </p>
         * <p>
         * If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * </p>
         * 
         * @param alarmNamePrefix
         *        An alarm name prefix. If you specify this parameter, you receive information about all alarms that
         *        have names that start with this prefix.</p>
         *        <p>
         *        If this parameter is specified, you cannot specify <code>AlarmNames</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNamePrefix(String alarmNamePrefix);

        /**
         * <p>
         * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If
         * you omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
         * </p>
         * <p>
         * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a
         * list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
         * account.
         * </p>
         * <p>
         * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does
         * not return any metric alarms.
         * </p>
         * 
         * @param alarmTypes
         *        Use this parameter to specify whether you want the operation to return metric alarms or composite
         *        alarms. If you omit this parameter, only metric alarms are returned, even if composite alarms exist in
         *        the account.</p>
         *        <p>
         *        For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns
         *        only a list of metric alarms. It does not return any composite alarms, even if composite alarms exist
         *        in the account.
         *        </p>
         *        <p>
         *        If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms,
         *        and does not return any metric alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmTypesWithStrings(Collection<String> alarmTypes);

        /**
         * <p>
         * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If
         * you omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
         * </p>
         * <p>
         * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a
         * list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
         * account.
         * </p>
         * <p>
         * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does
         * not return any metric alarms.
         * </p>
         * 
         * @param alarmTypes
         *        Use this parameter to specify whether you want the operation to return metric alarms or composite
         *        alarms. If you omit this parameter, only metric alarms are returned, even if composite alarms exist in
         *        the account.</p>
         *        <p>
         *        For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns
         *        only a list of metric alarms. It does not return any composite alarms, even if composite alarms exist
         *        in the account.
         *        </p>
         *        <p>
         *        If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms,
         *        and does not return any metric alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmTypesWithStrings(String... alarmTypes);

        /**
         * <p>
         * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If
         * you omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
         * </p>
         * <p>
         * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a
         * list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
         * account.
         * </p>
         * <p>
         * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does
         * not return any metric alarms.
         * </p>
         * 
         * @param alarmTypes
         *        Use this parameter to specify whether you want the operation to return metric alarms or composite
         *        alarms. If you omit this parameter, only metric alarms are returned, even if composite alarms exist in
         *        the account.</p>
         *        <p>
         *        For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns
         *        only a list of metric alarms. It does not return any composite alarms, even if composite alarms exist
         *        in the account.
         *        </p>
         *        <p>
         *        If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms,
         *        and does not return any metric alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmTypes(Collection<AlarmType> alarmTypes);

        /**
         * <p>
         * Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If
         * you omit this parameter, only metric alarms are returned, even if composite alarms exist in the account.
         * </p>
         * <p>
         * For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns only a
         * list of metric alarms. It does not return any composite alarms, even if composite alarms exist in the
         * account.
         * </p>
         * <p>
         * If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms, and does
         * not return any metric alarms.
         * </p>
         * 
         * @param alarmTypes
         *        Use this parameter to specify whether you want the operation to return metric alarms or composite
         *        alarms. If you omit this parameter, only metric alarms are returned, even if composite alarms exist in
         *        the account.</p>
         *        <p>
         *        For example, if you omit this parameter or specify <code>MetricAlarms</code>, the operation returns
         *        only a list of metric alarms. It does not return any composite alarms, even if composite alarms exist
         *        in the account.
         *        </p>
         *        <p>
         *        If you specify <code>CompositeAlarms</code>, the operation returns only a list of composite alarms,
         *        and does not return any metric alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmTypes(AlarmType... alarmTypes);

        /**
         * <p>
         * If you use this parameter and specify the name of a composite alarm, the operation returns information about
         * the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced
         * in the <code>AlarmRule</code> field of the composite alarm that you specify in
         * <code>ChildrenOfAlarmName</code>. Information about the composite alarm that you name in
         * <code>ChildrenOfAlarmName</code> is not returned.
         * </p>
         * <p>
         * If you specify <code>ChildrenOfAlarmName</code>, you cannot specify any other parameters in the request
         * except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.
         * </p>
         * <note>
         * <p>
         * Only the <code>Alarm Name</code>, <code>ARN</code>, <code>StateValue</code> (OK/ALARM/INSUFFICIENT_DATA), and
         * <code>StateUpdatedTimestamp</code> information are returned by this operation when you use this parameter. To
         * get complete information about these alarms, perform another <code>DescribeAlarms</code> operation and
         * specify the parent alarm names in the <code>AlarmNames</code> parameter.
         * </p>
         * </note>
         * 
         * @param childrenOfAlarmName
         *        If you use this parameter and specify the name of a composite alarm, the operation returns information
         *        about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms
         *        referenced in the <code>AlarmRule</code> field of the composite alarm that you specify in
         *        <code>ChildrenOfAlarmName</code>. Information about the composite alarm that you name in
         *        <code>ChildrenOfAlarmName</code> is not returned.</p>
         *        <p>
         *        If you specify <code>ChildrenOfAlarmName</code>, you cannot specify any other parameters in the
         *        request except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a
         *        validation error.
         *        </p>
         *        <note>
         *        <p>
         *        Only the <code>Alarm Name</code>, <code>ARN</code>, <code>StateValue</code>
         *        (OK/ALARM/INSUFFICIENT_DATA), and <code>StateUpdatedTimestamp</code> information are returned by this
         *        operation when you use this parameter. To get complete information about these alarms, perform another
         *        <code>DescribeAlarms</code> operation and specify the parent alarm names in the
         *        <code>AlarmNames</code> parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childrenOfAlarmName(String childrenOfAlarmName);

        /**
         * <p>
         * If you use this parameter and specify the name of a metric or composite alarm, the operation returns
         * information about the "parent" alarms of the alarm you specify. These are the composite alarms that have
         * <code>AlarmRule</code> parameters that reference the alarm named in <code>ParentsOfAlarmName</code>.
         * Information about the alarm that you specify in <code>ParentsOfAlarmName</code> is not returned.
         * </p>
         * <p>
         * If you specify <code>ParentsOfAlarmName</code>, you cannot specify any other parameters in the request except
         * for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.
         * </p>
         * <note>
         * <p>
         * Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete
         * information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the parent
         * alarm names in the <code>AlarmNames</code> parameter.
         * </p>
         * </note>
         * 
         * @param parentsOfAlarmName
         *        If you use this parameter and specify the name of a metric or composite alarm, the operation returns
         *        information about the "parent" alarms of the alarm you specify. These are the composite alarms that
         *        have <code>AlarmRule</code> parameters that reference the alarm named in
         *        <code>ParentsOfAlarmName</code>. Information about the alarm that you specify in
         *        <code>ParentsOfAlarmName</code> is not returned.</p>
         *        <p>
         *        If you specify <code>ParentsOfAlarmName</code>, you cannot specify any other parameters in the request
         *        except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation
         *        error.
         *        </p>
         *        <note>
         *        <p>
         *        Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get
         *        complete information about these alarms, perform another <code>DescribeAlarms</code> operation and
         *        specify the parent alarm names in the <code>AlarmNames</code> parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentsOfAlarmName(String parentsOfAlarmName);

        /**
         * <p>
         * Specify this parameter to receive information only about alarms that are currently in the state that you
         * specify.
         * </p>
         * 
         * @param stateValue
         *        Specify this parameter to receive information only about alarms that are currently in the state that
         *        you specify.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * Specify this parameter to receive information only about alarms that are currently in the state that you
         * specify.
         * </p>
         * 
         * @param stateValue
         *        Specify this parameter to receive information only about alarms that are currently in the state that
         *        you specify.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * Use this parameter to filter the results of the operation to only those alarms that use a certain alarm
         * action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to
         * that topic.
         * </p>
         * 
         * @param actionPrefix
         *        Use this parameter to filter the results of the operation to only those alarms that use a certain
         *        alarm action. For example, you could specify the ARN of an SNS topic to find all alarms that send
         *        notifications to that topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPrefix(String actionPrefix);

        /**
         * <p>
         * The maximum number of alarm descriptions to retrieve.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of alarm descriptions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();

        private String alarmNamePrefix;

        private List<String> alarmTypes = DefaultSdkAutoConstructList.getInstance();

        private String childrenOfAlarmName;

        private String parentsOfAlarmName;

        private String stateValue;

        private String actionPrefix;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            super(model);
            alarmNames(model.alarmNames);
            alarmNamePrefix(model.alarmNamePrefix);
            alarmTypesWithStrings(model.alarmTypes);
            childrenOfAlarmName(model.childrenOfAlarmName);
            parentsOfAlarmName(model.parentsOfAlarmName);
            stateValue(model.stateValue);
            actionPrefix(model.actionPrefix);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            if (alarmNames instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmNames;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String... alarmNames) {
            alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final String getAlarmNamePrefix() {
            return alarmNamePrefix;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final Collection<String> getAlarmTypes() {
            if (alarmTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmTypes;
        }

        public final void setAlarmTypes(Collection<String> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copy(alarmTypes);
        }

        @Override
        public final Builder alarmTypesWithStrings(Collection<String> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copy(alarmTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmTypesWithStrings(String... alarmTypes) {
            alarmTypesWithStrings(Arrays.asList(alarmTypes));
            return this;
        }

        @Override
        public final Builder alarmTypes(Collection<AlarmType> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copyEnumToString(alarmTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmTypes(AlarmType... alarmTypes) {
            alarmTypes(Arrays.asList(alarmTypes));
            return this;
        }

        public final String getChildrenOfAlarmName() {
            return childrenOfAlarmName;
        }

        public final void setChildrenOfAlarmName(String childrenOfAlarmName) {
            this.childrenOfAlarmName = childrenOfAlarmName;
        }

        @Override
        public final Builder childrenOfAlarmName(String childrenOfAlarmName) {
            this.childrenOfAlarmName = childrenOfAlarmName;
            return this;
        }

        public final String getParentsOfAlarmName() {
            return parentsOfAlarmName;
        }

        public final void setParentsOfAlarmName(String parentsOfAlarmName) {
            this.parentsOfAlarmName = parentsOfAlarmName;
        }

        @Override
        public final Builder parentsOfAlarmName(String parentsOfAlarmName) {
            this.parentsOfAlarmName = parentsOfAlarmName;
            return this;
        }

        public final String getStateValue() {
            return stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final String getActionPrefix() {
            return actionPrefix;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
