/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about managed Contributor Insights rules, as returned by <code>ListManagedInsightRules</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedRuleDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedRuleDescription.Builder, ManagedRuleDescription> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(ManagedRuleDescription::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(ManagedRuleDescription::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<ManagedRuleState> RULE_STATE_FIELD = SdkField
            .<ManagedRuleState> builder(MarshallingType.SDK_POJO).memberName("RuleState")
            .getter(getter(ManagedRuleDescription::ruleState)).setter(setter(Builder::ruleState))
            .constructor(ManagedRuleState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            RESOURCE_ARN_FIELD, RULE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TemplateName", TEMPLATE_NAME_FIELD);
                    put("ResourceARN", RESOURCE_ARN_FIELD);
                    put("RuleState", RULE_STATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String resourceARN;

    private final ManagedRuleState ruleState;

    private ManagedRuleDescription(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.resourceARN = builder.resourceARN;
        this.ruleState = builder.ruleState;
    }

    /**
     * <p>
     * The template name for the managed rule. Used to enable managed rules using <code>PutManagedInsightRules</code>.
     * </p>
     * 
     * @return The template name for the managed rule. Used to enable managed rules using
     *         <code>PutManagedInsightRules</code>.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * If a managed rule is enabled, this is the ARN for the related Amazon Web Services resource.
     * </p>
     * 
     * @return If a managed rule is enabled, this is the ARN for the related Amazon Web Services resource.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * Describes the state of a managed rule. If present, it contains information about the Contributor Insights rule
     * that contains information about the related Amazon Web Services resource.
     * </p>
     * 
     * @return Describes the state of a managed rule. If present, it contains information about the Contributor Insights
     *         rule that contains information about the related Amazon Web Services resource.
     */
    public final ManagedRuleState ruleState() {
        return ruleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(ruleState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleDescription)) {
            return false;
        }
        ManagedRuleDescription other = (ManagedRuleDescription) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(resourceARN(), other.resourceARN())
                && Objects.equals(ruleState(), other.ruleState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedRuleDescription").add("TemplateName", templateName()).add("ResourceARN", resourceARN())
                .add("RuleState", ruleState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "RuleState":
            return Optional.ofNullable(clazz.cast(ruleState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleDescription, T> g) {
        return obj -> g.apply((ManagedRuleDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedRuleDescription> {
        /**
         * <p>
         * The template name for the managed rule. Used to enable managed rules using
         * <code>PutManagedInsightRules</code>.
         * </p>
         * 
         * @param templateName
         *        The template name for the managed rule. Used to enable managed rules using
         *        <code>PutManagedInsightRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * If a managed rule is enabled, this is the ARN for the related Amazon Web Services resource.
         * </p>
         * 
         * @param resourceARN
         *        If a managed rule is enabled, this is the ARN for the related Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * Describes the state of a managed rule. If present, it contains information about the Contributor Insights
         * rule that contains information about the related Amazon Web Services resource.
         * </p>
         * 
         * @param ruleState
         *        Describes the state of a managed rule. If present, it contains information about the Contributor
         *        Insights rule that contains information about the related Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleState(ManagedRuleState ruleState);

        /**
         * <p>
         * Describes the state of a managed rule. If present, it contains information about the Contributor Insights
         * rule that contains information about the related Amazon Web Services resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedRuleState.Builder} avoiding the
         * need to create one manually via {@link ManagedRuleState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedRuleState.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleState(ManagedRuleState)}.
         * 
         * @param ruleState
         *        a consumer that will call methods on {@link ManagedRuleState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleState(ManagedRuleState)
         */
        default Builder ruleState(Consumer<ManagedRuleState.Builder> ruleState) {
            return ruleState(ManagedRuleState.builder().applyMutation(ruleState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String resourceARN;

        private ManagedRuleState ruleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleDescription model) {
            templateName(model.templateName);
            resourceARN(model.resourceARN);
            ruleState(model.ruleState);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final ManagedRuleState.Builder getRuleState() {
            return ruleState != null ? ruleState.toBuilder() : null;
        }

        public final void setRuleState(ManagedRuleState.BuilderImpl ruleState) {
            this.ruleState = ruleState != null ? ruleState.build() : null;
        }

        @Override
        public final Builder ruleState(ManagedRuleState ruleState) {
            this.ruleState = ruleState;
            return this;
        }

        @Override
        public ManagedRuleDescription build() {
            return new ManagedRuleDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
