/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<ListDashboardsRequest.Builder, ListDashboardsRequest> {
    private static final SdkField<String> DASHBOARD_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardNamePrefix").getter(getter(ListDashboardsRequest::dashboardNamePrefix))
            .setter(setter(Builder::dashboardNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardNamePrefix").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDashboardsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAME_PREFIX_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DashboardNamePrefix", DASHBOARD_NAME_PREFIX_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String dashboardNamePrefix;

    private final String nextToken;

    private ListDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNamePrefix = builder.dashboardNamePrefix;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * If you specify this parameter, only the dashboards with names starting with the specified string are listed. The
     * maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
     * </p>
     * 
     * @return If you specify this parameter, only the dashboards with names starting with the specified string are
     *         listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
     */
    public final String dashboardNamePrefix() {
        return dashboardNamePrefix;
    }

    /**
     * <p>
     * The token returned by a previous call to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned by a previous call to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsRequest)) {
            return false;
        }
        ListDashboardsRequest other = (ListDashboardsRequest) obj;
        return Objects.equals(dashboardNamePrefix(), other.dashboardNamePrefix())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDashboardsRequest").add("DashboardNamePrefix", dashboardNamePrefix())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardNamePrefix":
            return Optional.ofNullable(clazz.cast(dashboardNamePrefix()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsRequest, T> g) {
        return obj -> g.apply((ListDashboardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDashboardsRequest> {
        /**
         * <p>
         * If you specify this parameter, only the dashboards with names starting with the specified string are listed.
         * The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
         * </p>
         * 
         * @param dashboardNamePrefix
         *        If you specify this parameter, only the dashboards with names starting with the specified string are
         *        listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNamePrefix(String dashboardNamePrefix);

        /**
         * <p>
         * The token returned by a previous call to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String dashboardNamePrefix;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsRequest model) {
            super(model);
            dashboardNamePrefix(model.dashboardNamePrefix);
            nextToken(model.nextToken);
        }

        public final String getDashboardNamePrefix() {
            return dashboardNamePrefix;
        }

        public final void setDashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
        }

        @Override
        public final Builder dashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDashboardsRequest build() {
            return new ListDashboardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
