/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDashboardsRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DeleteDashboardsRequest.Builder, DeleteDashboardsRequest> {
    private static final SdkField<List<String>> DASHBOARD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DashboardNames")
            .getter(getter(DeleteDashboardsRequest::dashboardNames))
            .setter(setter(Builder::dashboardNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DashboardNames", DASHBOARD_NAMES_FIELD);
                }
            });

    private final List<String> dashboardNames;

    private DeleteDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNames = builder.dashboardNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashboardNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDashboardNames() {
        return dashboardNames != null && !(dashboardNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dashboards to be deleted. This parameter is required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboardNames} method.
     * </p>
     * 
     * @return The dashboards to be deleted. This parameter is required.
     */
    public final List<String> dashboardNames() {
        return dashboardNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboardNames() ? dashboardNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDashboardsRequest)) {
            return false;
        }
        DeleteDashboardsRequest other = (DeleteDashboardsRequest) obj;
        return hasDashboardNames() == other.hasDashboardNames() && Objects.equals(dashboardNames(), other.dashboardNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDashboardsRequest").add("DashboardNames", hasDashboardNames() ? dashboardNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardNames":
            return Optional.ofNullable(clazz.cast(dashboardNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDashboardsRequest, T> g) {
        return obj -> g.apply((DeleteDashboardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDashboardsRequest> {
        /**
         * <p>
         * The dashboards to be deleted. This parameter is required.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(Collection<String> dashboardNames);

        /**
         * <p>
         * The dashboards to be deleted. This parameter is required.
         * </p>
         * 
         * @param dashboardNames
         *        The dashboards to be deleted. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardNames(String... dashboardNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> dashboardNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDashboardsRequest model) {
            super(model);
            dashboardNames(model.dashboardNames);
        }

        public final Collection<String> getDashboardNames() {
            if (dashboardNames instanceof SdkAutoConstructList) {
                return null;
            }
            return dashboardNames;
        }

        public final void setDashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
        }

        @Override
        public final Builder dashboardNames(Collection<String> dashboardNames) {
            this.dashboardNames = DashboardNamesCopier.copy(dashboardNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardNames(String... dashboardNames) {
            dashboardNames(Arrays.asList(dashboardNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDashboardsRequest build() {
            return new DeleteDashboardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
