/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamOutputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStreamEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricStreamEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(MetricStreamEntry.getter(MetricStreamEntry::arn)).setter(MetricStreamEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(MetricStreamEntry.getter(MetricStreamEntry::creationDate)).setter(MetricStreamEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDate").getter(MetricStreamEntry.getter(MetricStreamEntry::lastUpdateDate)).setter(MetricStreamEntry.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MetricStreamEntry.getter(MetricStreamEntry::name)).setter(MetricStreamEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FIREHOSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseArn").getter(MetricStreamEntry.getter(MetricStreamEntry::firehoseArn)).setter(MetricStreamEntry.setter(Builder::firehoseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(MetricStreamEntry.getter(MetricStreamEntry::state)).setter(MetricStreamEntry.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(MetricStreamEntry.getter(MetricStreamEntry::outputFormatAsString)).setter(MetricStreamEntry.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, NAME_FIELD, FIREHOSE_ARN_FIELD, STATE_FIELD, OUTPUT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("FirehoseArn", FIREHOSE_ARN_FIELD);
            this.put("State", STATE_FIELD);
            this.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant creationDate;
    private final Instant lastUpdateDate;
    private final String name;
    private final String firehoseArn;
    private final String state;
    private final String outputFormat;

    private MetricStreamEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.name = builder.name;
        this.firehoseArn = builder.firehoseArn;
        this.state = builder.state;
        this.outputFormat = builder.outputFormat;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public final String name() {
        return this.name;
    }

    public final String firehoseArn() {
        return this.firehoseArn;
    }

    public final String state() {
        return this.state;
    }

    public final MetricStreamOutputFormat outputFormat() {
        return MetricStreamOutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamEntry)) {
            return false;
        }
        MetricStreamEntry other = (MetricStreamEntry)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.firehoseArn(), other.firehoseArn()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetricStreamEntry").add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).add("Name", (Object)this.name()).add("FirehoseArn", (Object)this.firehoseArn()).add("State", (Object)this.state()).add("OutputFormat", (Object)this.outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FirehoseArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricStreamEntry, T> g) {
        return obj -> g.apply((MetricStreamEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationDate;
        private Instant lastUpdateDate;
        private String name;
        private String firehoseArn;
        private String state;
        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStreamEntry model) {
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
            this.name(model.name);
            this.firehoseArn(model.firehoseArn);
            this.state(model.state);
            this.outputFormat(model.outputFormat);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFirehoseArn() {
            return this.firehoseArn;
        }

        public final void setFirehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
        }

        @Override
        public final Builder firehoseArn(String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(MetricStreamOutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public MetricStreamEntry build() {
            return new MetricStreamEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricStreamEntry> {
        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);

        public Builder name(String var1);

        public Builder firehoseArn(String var1);

        public Builder state(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(MetricStreamOutputFormat var1);
    }
}

