/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<ListMetricsResponse.Builder, ListMetricsResponse> {
    private static final SdkField<List<Metric>> METRICS_FIELD = SdkField
            .<List<Metric>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(ListMetricsResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metric> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> OWNING_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OwningAccounts")
            .getter(getter(ListMetricsResponse::owningAccounts))
            .setter(setter(Builder::owningAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            NEXT_TOKEN_FIELD, OWNING_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Metrics", METRICS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("OwningAccounts", OWNING_ACCOUNTS_FIELD);
                }
            });

    private final List<Metric> metrics;

    private final String nextToken;

    private final List<String> owningAccounts;

    private ListMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.owningAccounts = builder.owningAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics that match your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics that match your request.
     */
    public final List<Metric> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OwningAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOwningAccounts() {
        return owningAccounts != null && !(owningAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you are using this operation in a monitoring account, this array contains the account IDs of the source
     * accounts where the metrics in the returned data are from.
     * </p>
     * <p>
     * This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOwningAccounts} method.
     * </p>
     * 
     * @return If you are using this operation in a monitoring account, this array contains the account IDs of the
     *         source accounts where the metrics in the returned data are from.</p>
     *         <p>
     *         This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
     */
    public final List<String> owningAccounts() {
        return owningAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOwningAccounts() ? owningAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResponse)) {
            return false;
        }
        ListMetricsResponse other = (ListMetricsResponse) obj;
        return hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(nextToken(), other.nextToken()) && hasOwningAccounts() == other.hasOwningAccounts()
                && Objects.equals(owningAccounts(), other.owningAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricsResponse").add("Metrics", hasMetrics() ? metrics() : null)
                .add("NextToken", nextToken()).add("OwningAccounts", hasOwningAccounts() ? owningAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OwningAccounts":
            return Optional.ofNullable(clazz.cast(owningAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricsResponse, T> g) {
        return obj -> g.apply((ListMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricsResponse> {
        /**
         * <p>
         * The metrics that match your request.
         * </p>
         * 
         * @param metrics
         *        The metrics that match your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<Metric> metrics);

        /**
         * <p>
         * The metrics that match your request.
         * </p>
         * 
         * @param metrics
         *        The metrics that match your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Metric... metrics);

        /**
         * <p>
         * The metrics that match your request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.Metric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudwatch.model.Metric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.Metric.Builder#build()} is called immediately and its
         * result is passed to {@link #metrics(List<Metric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<Metric>)
         */
        Builder metrics(Consumer<Metric.Builder>... metrics);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * If you are using this operation in a monitoring account, this array contains the account IDs of the source
         * accounts where the metrics in the returned data are from.
         * </p>
         * <p>
         * This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
         * </p>
         * 
         * @param owningAccounts
         *        If you are using this operation in a monitoring account, this array contains the account IDs of the
         *        source accounts where the metrics in the returned data are from.</p>
         *        <p>
         *        This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningAccounts(Collection<String> owningAccounts);

        /**
         * <p>
         * If you are using this operation in a monitoring account, this array contains the account IDs of the source
         * accounts where the metrics in the returned data are from.
         * </p>
         * <p>
         * This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
         * </p>
         * 
         * @param owningAccounts
         *        If you are using this operation in a monitoring account, this array contains the account IDs of the
         *        source accounts where the metrics in the returned data are from.</p>
         *        <p>
         *        This field is a 1:1 mapping between each metric that is returned and the ID of the owning account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningAccounts(String... owningAccounts);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<Metric> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<String> owningAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsResponse model) {
            super(model);
            metrics(model.metrics);
            nextToken(model.nextToken);
            owningAccounts(model.owningAccounts);
        }

        public final List<Metric.Builder> getMetrics() {
            List<Metric.Builder> result = MetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<Metric.BuilderImpl> metrics) {
            this.metrics = MetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<Metric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> Metric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getOwningAccounts() {
            if (owningAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return owningAccounts;
        }

        public final void setOwningAccounts(Collection<String> owningAccounts) {
            this.owningAccounts = OwningAccountsCopier.copy(owningAccounts);
        }

        @Override
        public final Builder owningAccounts(Collection<String> owningAccounts) {
            this.owningAccounts = OwningAccountsCopier.copy(owningAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owningAccounts(String... owningAccounts) {
            owningAccounts(Arrays.asList(owningAccounts));
            return this;
        }

        @Override
        public ListMetricsResponse build() {
            return new ListMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
