/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDashboardResponse extends CloudWatchResponse implements
        ToCopyableBuilder<PutDashboardResponse.Builder, PutDashboardResponse> {
    private static final SdkField<List<DashboardValidationMessage>> DASHBOARD_VALIDATION_MESSAGES_FIELD = SdkField
            .<List<DashboardValidationMessage>> builder(MarshallingType.LIST)
            .memberName("DashboardValidationMessages")
            .getter(getter(PutDashboardResponse::dashboardValidationMessages))
            .setter(setter(Builder::dashboardValidationMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardValidationMessages")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardValidationMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardValidationMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DASHBOARD_VALIDATION_MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private PutDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashboardValidationMessages property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDashboardValidationMessages() {
        return dashboardValidationMessages != null && !(dashboardValidationMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or modified,
     * this result is empty.
     * </p>
     * <p>
     * If this result includes only warning messages, then the input was valid enough for the dashboard to be created or
     * modified, but some elements of the dashboard might not render.
     * </p>
     * <p>
     * If this result includes error messages, the input was not valid and the operation failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboardValidationMessages} method.
     * </p>
     * 
     * @return If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
     *         modified, this result is empty.</p>
     *         <p>
     *         If this result includes only warning messages, then the input was valid enough for the dashboard to be
     *         created or modified, but some elements of the dashboard might not render.
     *         </p>
     *         <p>
     *         If this result includes error messages, the input was not valid and the operation failed.
     */
    public final List<DashboardValidationMessage> dashboardValidationMessages() {
        return dashboardValidationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboardValidationMessages() ? dashboardValidationMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardResponse)) {
            return false;
        }
        PutDashboardResponse other = (PutDashboardResponse) obj;
        return hasDashboardValidationMessages() == other.hasDashboardValidationMessages()
                && Objects.equals(dashboardValidationMessages(), other.dashboardValidationMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDashboardResponse")
                .add("DashboardValidationMessages", hasDashboardValidationMessages() ? dashboardValidationMessages() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardValidationMessages":
            return Optional.ofNullable(clazz.cast(dashboardValidationMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardValidationMessages", DASHBOARD_VALIDATION_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDashboardResponse, T> g) {
        return obj -> g.apply((PutDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutDashboardResponse> {
        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard might not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * 
         * @param dashboardValidationMessages
         *        If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         *        modified, this result is empty.</p>
         *        <p>
         *        If this result includes only warning messages, then the input was valid enough for the dashboard to be
         *        created or modified, but some elements of the dashboard might not render.
         *        </p>
         *        <p>
         *        If this result includes error messages, the input was not valid and the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages);

        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard might not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * 
         * @param dashboardValidationMessages
         *        If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         *        modified, this result is empty.</p>
         *        <p>
         *        If this result includes only warning messages, then the input was valid enough for the dashboard to be
         *        created or modified, but some elements of the dashboard might not render.
         *        </p>
         *        <p>
         *        If this result includes error messages, the input was not valid and the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages);

        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard might not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dashboardValidationMessages(List<DashboardValidationMessage>)}.
         * 
         * @param dashboardValidationMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardValidationMessages(java.util.Collection<DashboardValidationMessage>)
         */
        Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardResponse model) {
            super(model);
            dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final List<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            List<DashboardValidationMessage.Builder> result = DashboardValidationMessagesCopier
                    .copyToBuilder(this.dashboardValidationMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboardValidationMessages(
                Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages) {
            dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(
                Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages) {
            dashboardValidationMessages(Stream.of(dashboardValidationMessages)
                    .map(c -> DashboardValidationMessage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutDashboardResponse build() {
            return new PutDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
