/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutManagedInsightRulesRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutManagedInsightRulesRequest.Builder, PutManagedInsightRulesRequest> {
    private static final SdkField<List<ManagedRule>> MANAGED_RULES_FIELD = SdkField
            .<List<ManagedRule>> builder(MarshallingType.LIST)
            .memberName("ManagedRules")
            .getter(getter(PutManagedInsightRulesRequest::managedRules))
            .setter(setter(Builder::managedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ManagedRule> managedRules;

    private PutManagedInsightRulesRequest(BuilderImpl builder) {
        super(builder);
        this.managedRules = builder.managedRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedRules() {
        return managedRules != null && !(managedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ManagedRules</code> to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedRules} method.
     * </p>
     * 
     * @return A list of <code>ManagedRules</code> to enable.
     */
    public final List<ManagedRule> managedRules() {
        return managedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedRules() ? managedRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutManagedInsightRulesRequest)) {
            return false;
        }
        PutManagedInsightRulesRequest other = (PutManagedInsightRulesRequest) obj;
        return hasManagedRules() == other.hasManagedRules() && Objects.equals(managedRules(), other.managedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutManagedInsightRulesRequest").add("ManagedRules", hasManagedRules() ? managedRules() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedRules":
            return Optional.ofNullable(clazz.cast(managedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedRules", MANAGED_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutManagedInsightRulesRequest, T> g) {
        return obj -> g.apply((PutManagedInsightRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutManagedInsightRulesRequest> {
        /**
         * <p>
         * A list of <code>ManagedRules</code> to enable.
         * </p>
         * 
         * @param managedRules
         *        A list of <code>ManagedRules</code> to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(Collection<ManagedRule> managedRules);

        /**
         * <p>
         * A list of <code>ManagedRules</code> to enable.
         * </p>
         * 
         * @param managedRules
         *        A list of <code>ManagedRules</code> to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(ManagedRule... managedRules);

        /**
         * <p>
         * A list of <code>ManagedRules</code> to enable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.ManagedRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudwatch.model.ManagedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.ManagedRule.Builder#build()} is called immediately
         * and its result is passed to {@link #managedRules(List<ManagedRule>)}.
         * 
         * @param managedRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.ManagedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRules(java.util.Collection<ManagedRule>)
         */
        Builder managedRules(Consumer<ManagedRule.Builder>... managedRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<ManagedRule> managedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutManagedInsightRulesRequest model) {
            super(model);
            managedRules(model.managedRules);
        }

        public final List<ManagedRule.Builder> getManagedRules() {
            List<ManagedRule.Builder> result = ManagedRulesCopier.copyToBuilder(this.managedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedRules(Collection<ManagedRule.BuilderImpl> managedRules) {
            this.managedRules = ManagedRulesCopier.copyFromBuilder(managedRules);
        }

        @Override
        public final Builder managedRules(Collection<ManagedRule> managedRules) {
            this.managedRules = ManagedRulesCopier.copy(managedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(ManagedRule... managedRules) {
            managedRules(Arrays.asList(managedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(Consumer<ManagedRule.Builder>... managedRules) {
            managedRules(Stream.of(managedRules).map(c -> ManagedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutManagedInsightRulesRequest build() {
            return new PutManagedInsightRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
