/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStreamStatisticsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricStreamStatisticsMetric> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(MetricStreamStatisticsMetric.getter(MetricStreamStatisticsMetric::namespace)).setter(MetricStreamStatisticsMetric.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricStreamStatisticsMetric.getter(MetricStreamStatisticsMetric::metricName)).setter(MetricStreamStatisticsMetric.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricStreamStatisticsMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String metricName;

    private MetricStreamStatisticsMetric(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String metricName() {
        return this.metricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamStatisticsMetric)) {
            return false;
        }
        MetricStreamStatisticsMetric other = (MetricStreamStatisticsMetric)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricName(), other.metricName());
    }

    public final String toString() {
        return ToString.builder((String)"MetricStreamStatisticsMetric").add("Namespace", (Object)this.namespace()).add("MetricName", (Object)this.metricName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricStreamStatisticsMetric, T> g) {
        return obj -> g.apply((MetricStreamStatisticsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStreamStatisticsMetric model) {
            this.namespace(model.namespace);
            this.metricName(model.metricName);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public MetricStreamStatisticsMetric build() {
            return new MetricStreamStatisticsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricStreamStatisticsMetric> {
        public Builder namespace(String var1);

        public Builder metricName(String var1);
    }
}

