/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmsForMetricResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
    private static final SdkField<List<MetricAlarm>> METRIC_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAlarmsForMetricResponse.getter(DescribeAlarmsForMetricResponse::metricAlarms)).setter(DescribeAlarmsForMetricResponse.setter(Builder::metricAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAlarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ALARMS_FIELD));
    private final List<MetricAlarm> metricAlarms;

    private DescribeAlarmsForMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricAlarms = builder.metricAlarms;
    }

    public List<MetricAlarm> metricAlarms() {
        return this.metricAlarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAlarms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricResponse)) {
            return false;
        }
        DescribeAlarmsForMetricResponse other = (DescribeAlarmsForMetricResponse)((Object)obj);
        return Objects.equals(this.metricAlarms(), other.metricAlarms());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmsForMetricResponse").add("MetricAlarms", this.metricAlarms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricAlarms": {
                return Optional.ofNullable(clazz.cast(this.metricAlarms()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsForMetricResponse, T> g) {
        return obj -> g.apply((DescribeAlarmsForMetricResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<MetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricResponse model) {
            super(model);
            this.metricAlarms(model.metricAlarms);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            return this.metricAlarms != null ? (Collection)this.metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm ... metricAlarms) {
            this.metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder> ... metricAlarms) {
            this.metricAlarms(Stream.of(metricAlarms).map(c -> (MetricAlarm)((MetricAlarm.Builder)MetricAlarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        @Override
        public DescribeAlarmsForMetricResponse build() {
            return new DescribeAlarmsForMetricResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmsForMetricResponse> {
        public Builder metricAlarms(Collection<MetricAlarm> var1);

        public Builder metricAlarms(MetricAlarm ... var1);

        public Builder metricAlarms(Consumer<MetricAlarm.Builder> ... var1);
    }
}

