/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<DescribeAlarmsResponse.Builder, DescribeAlarmsResponse> {
    private static final SdkField<List<MetricAlarm>> METRIC_ALARMS_FIELD = SdkField
            .<List<MetricAlarm>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAlarmsResponse::metricAlarms))
            .setter(setter(Builder::metricAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAlarmsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ALARMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MetricAlarm> metricAlarms;

    private final String nextToken;

    private DescribeAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.metricAlarms = builder.metricAlarms;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The information for the specified alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The information for the specified alarms.
     */
    public List<MetricAlarm> metricAlarms() {
        return metricAlarms;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricAlarms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsResponse)) {
            return false;
        }
        DescribeAlarmsResponse other = (DescribeAlarmsResponse) obj;
        return Objects.equals(metricAlarms(), other.metricAlarms()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAlarmsResponse").add("MetricAlarms", metricAlarms()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricAlarms":
            return Optional.ofNullable(clazz.cast(metricAlarms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsResponse, T> g) {
        return obj -> g.apply((DescribeAlarmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmsResponse> {
        /**
         * <p>
         * The information for the specified alarms.
         * </p>
         * 
         * @param metricAlarms
         *        The information for the specified alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(Collection<MetricAlarm> metricAlarms);

        /**
         * <p>
         * The information for the specified alarms.
         * </p>
         * 
         * @param metricAlarms
         *        The information for the specified alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAlarms(MetricAlarm... metricAlarms);

        /**
         * <p>
         * The information for the specified alarms.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricAlarm>.Builder} avoiding the need to
         * create one manually via {@link List<MetricAlarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricAlarm>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricAlarms(List<MetricAlarm>)}.
         * 
         * @param metricAlarms
         *        a consumer that will call methods on {@link List<MetricAlarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAlarms(List<MetricAlarm>)
         */
        Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<MetricAlarm> metricAlarms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsResponse model) {
            super(model);
            metricAlarms(model.metricAlarms);
            nextToken(model.nextToken);
        }

        public final Collection<MetricAlarm.Builder> getMetricAlarms() {
            return metricAlarms != null ? metricAlarms.stream().map(MetricAlarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricAlarms(Collection<MetricAlarm> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copy(metricAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(MetricAlarm... metricAlarms) {
            metricAlarms(Arrays.asList(metricAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAlarms(Consumer<MetricAlarm.Builder>... metricAlarms) {
            metricAlarms(Stream.of(metricAlarms).map(c -> MetricAlarm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricAlarms(Collection<MetricAlarm.BuilderImpl> metricAlarms) {
            this.metricAlarms = MetricAlarmsCopier.copyFromBuilder(metricAlarms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmsResponse build() {
            return new DescribeAlarmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
