/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDashboardRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutDashboardRequest.Builder, PutDashboardRequest> {
    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutDashboardRequest::dashboardName)).setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()).build();

    private static final SdkField<String> DASHBOARD_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutDashboardRequest::dashboardBody)).setter(setter(Builder::dashboardBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAME_FIELD,
            DASHBOARD_BODY_FIELD));

    private final String dashboardName;

    private final String dashboardBody;

    private PutDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardName = builder.dashboardName;
        this.dashboardBody = builder.dashboardBody;
    }

    /**
     * <p>
     * The name of the dashboard. If a dashboard with this name already exists, this call modifies that dashboard,
     * replacing its current contents. Otherwise, a new dashboard is created. The maximum length is 255, and valid
     * characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
     * </p>
     * 
     * @return The name of the dashboard. If a dashboard with this name already exists, this call modifies that
     *         dashboard, replacing its current contents. Otherwise, a new dashboard is created. The maximum length is
     *         255, and valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
     */
    public String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * The detailed information about the dashboard in JSON format, including the widgets to include and their location
     * on the dashboard. This parameter is required.
     * </p>
     * <p>
     * For more information about the syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>.
     * </p>
     * 
     * @return The detailed information about the dashboard in JSON format, including the widgets to include and their
     *         location on the dashboard. This parameter is required.</p>
     *         <p>
     *         For more information about the syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>.
     */
    public String dashboardBody() {
        return dashboardBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardRequest)) {
            return false;
        }
        PutDashboardRequest other = (PutDashboardRequest) obj;
        return Objects.equals(dashboardName(), other.dashboardName()) && Objects.equals(dashboardBody(), other.dashboardBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutDashboardRequest").add("DashboardName", dashboardName())
                .add("DashboardBody", dashboardBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "DashboardBody":
            return Optional.ofNullable(clazz.cast(dashboardBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDashboardRequest, T> g) {
        return obj -> g.apply((PutDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutDashboardRequest> {
        /**
         * <p>
         * The name of the dashboard. If a dashboard with this name already exists, this call modifies that dashboard,
         * replacing its current contents. Otherwise, a new dashboard is created. The maximum length is 255, and valid
         * characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard. If a dashboard with this name already exists, this call modifies that
         *        dashboard, replacing its current contents. Otherwise, a new dashboard is created. The maximum length
         *        is 255, and valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * The detailed information about the dashboard in JSON format, including the widgets to include and their
         * location on the dashboard. This parameter is required.
         * </p>
         * <p>
         * For more information about the syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>.
         * </p>
         * 
         * @param dashboardBody
         *        The detailed information about the dashboard in JSON format, including the widgets to include and
         *        their location on the dashboard. This parameter is required.</p>
         *        <p>
         *        For more information about the syntax, see <a>CloudWatch-Dashboard-Body-Structure</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardBody(String dashboardBody);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String dashboardName;

        private String dashboardBody;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardRequest model) {
            super(model);
            dashboardName(model.dashboardName);
            dashboardBody(model.dashboardBody);
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardBody() {
            return dashboardBody;
        }

        @Override
        public final Builder dashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
            return this;
        }

        public final void setDashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDashboardRequest build() {
            return new PutDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
