/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetricDataRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutMetricDataRequest.Builder, PutMetricDataRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMetricDataRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<MetricDatum>> METRIC_DATA_FIELD = SdkField
            .<List<MetricDatum>> builder(MarshallingType.LIST)
            .getter(getter(PutMetricDataRequest::metricData))
            .setter(setter(Builder::metricData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatum> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            METRIC_DATA_FIELD));

    private final String namespace;

    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The namespace for the metric data.
     * </p>
     * <p>
     * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for use by
     * Amazon Web Services products.
     * </p>
     * 
     * @return The namespace for the metric data.</p>
     *         <p>
     *         You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
     *         for use by Amazon Web Services products.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The data for the metric. The array can include no more than 20 metrics per call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data for the metric. The array can include no more than 20 metrics per call.
     */
    public List<MetricDatum> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(metricData(), other.metricData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutMetricDataRequest").add("Namespace", namespace()).add("MetricData", metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "MetricData":
            return Optional.ofNullable(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricDataRequest, T> g) {
        return obj -> g.apply((PutMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetricDataRequest> {
        /**
         * <p>
         * The namespace for the metric data.
         * </p>
         * <p>
         * You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved for
         * use by Amazon Web Services products.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric data.</p>
         *        <p>
         *        You cannot specify a namespace that begins with "AWS/". Namespaces that begin with "AWS/" are reserved
         *        for use by Amazon Web Services products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The data for the metric. The array can include no more than 20 metrics per call.
         * </p>
         * 
         * @param metricData
         *        The data for the metric. The array can include no more than 20 metrics per call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatum> metricData);

        /**
         * <p>
         * The data for the metric. The array can include no more than 20 metrics per call.
         * </p>
         * 
         * @param metricData
         *        The data for the metric. The array can include no more than 20 metrics per call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatum... metricData);

        /**
         * <p>
         * The data for the metric. The array can include no more than 20 metrics per call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDatum>.Builder} avoiding the need to
         * create one manually via {@link List<MetricDatum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatum>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricData(List<MetricDatum>)}.
         * 
         * @param metricData
         *        a consumer that will call methods on {@link List<MetricDatum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricData(List<MetricDatum>)
         */
        Builder metricData(Consumer<MetricDatum.Builder>... metricData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String namespace;

        private List<MetricDatum> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            super(model);
            namespace(model.namespace);
            metricData(model.metricData);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum.Builder> getMetricData() {
            return metricData != null ? metricData.stream().map(MetricDatum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder>... metricData) {
            metricData(Stream.of(metricData).map(c -> MetricDatum.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
