/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.BatchArrayPropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and
 * 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target
 * is an AWS Batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchArrayProperties implements StructuredPojo,
        ToCopyableBuilder<BatchArrayProperties.Builder, BatchArrayProperties> {
    private final Integer size;

    private BatchArrayProperties(BuilderImpl builder) {
        this.size = builder.size;
    }

    /**
     * <p>
     * The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     * </p>
     * 
     * @return The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
     */
    public Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchArrayProperties)) {
            return false;
        }
        BatchArrayProperties other = (BatchArrayProperties) obj;
        return Objects.equals(size(), other.size());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchArrayProperties").add("Size", size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchArrayPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BatchArrayProperties> {
        /**
         * <p>
         * The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
         * </p>
         * 
         * @param size
         *        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchArrayProperties model) {
            size(model.size);
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public BatchArrayProperties build() {
            return new BatchArrayProperties(this);
        }
    }
}
