/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.BatchRetryStrategyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy to use for failed jobs, if the target is an AWS Batch job. If you specify a retry strategy here,
 * it overrides the retry strategy defined in the job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRetryStrategy implements StructuredPojo,
        ToCopyableBuilder<BatchRetryStrategy.Builder, BatchRetryStrategy> {
    private final Integer attempts;

    private BatchRetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
    }

    /**
     * <p>
     * The number of times to attempt to retry, if the job fails. Valid values are 1–10.
     * </p>
     * 
     * @return The number of times to attempt to retry, if the job fails. Valid values are 1–10.
     */
    public Integer attempts() {
        return attempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRetryStrategy)) {
            return false;
        }
        BatchRetryStrategy other = (BatchRetryStrategy) obj;
        return Objects.equals(attempts(), other.attempts());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchRetryStrategy").add("Attempts", attempts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchRetryStrategyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BatchRetryStrategy> {
        /**
         * <p>
         * The number of times to attempt to retry, if the job fails. Valid values are 1–10.
         * </p>
         * 
         * @param attempts
         *        The number of times to attempt to retry, if the job fails. Valid values are 1–10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);
    }

    static final class BuilderImpl implements Builder {
        private Integer attempts;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRetryStrategy model) {
            attempts(model.attempts);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        public BatchRetryStrategy build() {
            return new BatchRetryStrategy(this);
        }
    }
}
