/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.NetworkConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the network configuration for an ECS task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements StructuredPojo,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private final AwsVpcConfiguration awsvpcConfiguration;

    private NetworkConfiguration(BuilderImpl builder) {
        this.awsvpcConfiguration = builder.awsvpcConfiguration;
    }

    /**
     * <p>
     * Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address
     * is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
     * </p>
     * 
     * @return Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP
     *         address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code>
     *         network mode.
     */
    public AwsVpcConfiguration awsvpcConfiguration() {
        return awsvpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsvpcConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(awsvpcConfiguration(), other.awsvpcConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("NetworkConfiguration").add("AwsvpcConfiguration", awsvpcConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsvpcConfiguration":
            return Optional.ofNullable(clazz.cast(awsvpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP
         * address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network
         * mode.
         * </p>
         * 
         * @param awsvpcConfiguration
         *        Use this structure to specify the VPC subnets and security groups for the task, and whether a public
         *        IP address is to be used. This structure is relevant only for ECS tasks that use the
         *        <code>awsvpc</code> network mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsvpcConfiguration(AwsVpcConfiguration awsvpcConfiguration);

        /**
         * <p>
         * Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP
         * address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network
         * mode.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsVpcConfiguration.Builder} avoiding the need
         * to create one manually via {@link AwsVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsVpcConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #awsvpcConfiguration(AwsVpcConfiguration)}.
         * 
         * @param awsvpcConfiguration
         *        a consumer that will call methods on {@link AwsVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsvpcConfiguration(AwsVpcConfiguration)
         */
        default Builder awsvpcConfiguration(Consumer<AwsVpcConfiguration.Builder> awsvpcConfiguration) {
            return awsvpcConfiguration(AwsVpcConfiguration.builder().applyMutation(awsvpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsVpcConfiguration awsvpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            awsvpcConfiguration(model.awsvpcConfiguration);
        }

        public final AwsVpcConfiguration.Builder getAwsvpcConfiguration() {
            return awsvpcConfiguration != null ? awsvpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder awsvpcConfiguration(AwsVpcConfiguration awsvpcConfiguration) {
            this.awsvpcConfiguration = awsvpcConfiguration;
            return this;
        }

        public final void setAwsvpcConfiguration(AwsVpcConfiguration.BuilderImpl awsvpcConfiguration) {
            this.awsvpcConfiguration = awsvpcConfiguration != null ? awsvpcConfiguration.build() : null;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }
    }
}
