/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemoveTargetsResultEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a target that failed to be removed from a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTargetsResultEntry implements StructuredPojo,
        ToCopyableBuilder<RemoveTargetsResultEntry.Builder, RemoveTargetsResultEntry> {
    private final String targetId;

    private final String errorCode;

    private final String errorMessage;

    private RemoveTargetsResultEntry(BuilderImpl builder) {
        this.targetId = builder.targetId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ID of the target.
     * </p>
     * 
     * @return The ID of the target.
     */
    public String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The error code that indicates why the target removal failed. If the value is
     * <code>ConcurrentModificationException</code>, too many requests were made at the same time.
     * </p>
     * 
     * @return The error code that indicates why the target removal failed. If the value is
     *         <code>ConcurrentModificationException</code>, too many requests were made at the same time.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message that explains why the target removal failed.
     * </p>
     * 
     * @return The error message that explains why the target removal failed.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTargetsResultEntry)) {
            return false;
        }
        RemoveTargetsResultEntry other = (RemoveTargetsResultEntry) obj;
        return Objects.equals(targetId(), other.targetId()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("RemoveTargetsResultEntry").add("TargetId", targetId()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoveTargetsResultEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RemoveTargetsResultEntry> {
        /**
         * <p>
         * The ID of the target.
         * </p>
         * 
         * @param targetId
         *        The ID of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The error code that indicates why the target removal failed. If the value is
         * <code>ConcurrentModificationException</code>, too many requests were made at the same time.
         * </p>
         * 
         * @param errorCode
         *        The error code that indicates why the target removal failed. If the value is
         *        <code>ConcurrentModificationException</code>, too many requests were made at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message that explains why the target removal failed.
         * </p>
         * 
         * @param errorMessage
         *        The error message that explains why the target removal failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String targetId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTargetsResultEntry model) {
            targetId(model.targetId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getTargetId() {
            return targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public RemoveTargetsResultEntry build() {
            return new RemoveTargetsResultEntry(this);
        }
    }
}
