/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.SqsParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure includes the custom parameter to be used when the target is an SQS FIFO queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqsParameters implements StructuredPojo, ToCopyableBuilder<SqsParameters.Builder, SqsParameters> {
    private final String messageGroupId;

    private SqsParameters(BuilderImpl builder) {
        this.messageGroupId = builder.messageGroupId;
    }

    /**
     * <p>
     * The FIFO message group ID to use as the target.
     * </p>
     * 
     * @return The FIFO message group ID to use as the target.
     */
    public String messageGroupId() {
        return messageGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageGroupId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsParameters)) {
            return false;
        }
        SqsParameters other = (SqsParameters) obj;
        return Objects.equals(messageGroupId(), other.messageGroupId());
    }

    @Override
    public String toString() {
        return ToString.builder("SqsParameters").add("MessageGroupId", messageGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageGroupId":
            return Optional.ofNullable(clazz.cast(messageGroupId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqsParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SqsParameters> {
        /**
         * <p>
         * The FIFO message group ID to use as the target.
         * </p>
         * 
         * @param messageGroupId
         *        The FIFO message group ID to use as the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroupId(String messageGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsParameters model) {
            messageGroupId(model.messageGroupId);
        }

        public final String getMessageGroupId() {
            return messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public SqsParameters build() {
            return new SqsParameters(this);
        }
    }
}
