/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.AwsVpcConfiguration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AwsVpcConfiguration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AwsVpcConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").isBinary(false).build();

    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").isBinary(false).build();

    private static final MarshallingInfo<String> ASSIGNPUBLICIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignPublicIp").isBinary(false).build();

    private static final AwsVpcConfigurationMarshaller INSTANCE = new AwsVpcConfigurationMarshaller();

    private AwsVpcConfigurationMarshaller() {
    }

    public static AwsVpcConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AwsVpcConfiguration awsVpcConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(awsVpcConfiguration, "awsVpcConfiguration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(awsVpcConfiguration.subnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(awsVpcConfiguration.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(awsVpcConfiguration.assignPublicIpAsString(), ASSIGNPUBLICIP_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
