/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.Target;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Target} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class TargetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();

    private static final MarshallingInfo<String> INPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Input").isBinary(false).build();

    private static final MarshallingInfo<String> INPUTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputPath").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTTRANSFORMER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputTransformer").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisParameters").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RUNCOMMANDPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RunCommandParameters").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ECSPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsParameters")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BATCHPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("BatchParameters").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SQSPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqsParameters")
            .isBinary(false).build();

    private static final TargetMarshaller INSTANCE = new TargetMarshaller();

    private TargetMarshaller() {
    }

    public static TargetMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Target target, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(target, "target");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(target.id(), ID_BINDING);
            protocolMarshaller.marshall(target.arn(), ARN_BINDING);
            protocolMarshaller.marshall(target.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(target.input(), INPUT_BINDING);
            protocolMarshaller.marshall(target.inputPath(), INPUTPATH_BINDING);
            protocolMarshaller.marshall(target.inputTransformer(), INPUTTRANSFORMER_BINDING);
            protocolMarshaller.marshall(target.kinesisParameters(), KINESISPARAMETERS_BINDING);
            protocolMarshaller.marshall(target.runCommandParameters(), RUNCOMMANDPARAMETERS_BINDING);
            protocolMarshaller.marshall(target.ecsParameters(), ECSPARAMETERS_BINDING);
            protocolMarshaller.marshall(target.batchParameters(), BATCHPARAMETERS_BINDING);
            protocolMarshaller.marshall(target.sqsParameters(), SQSPARAMETERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
