/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatchevents.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Target JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TargetUnmarshaller implements Unmarshaller<Target, JsonUnmarshallerContext> {

    public Target unmarshall(JsonUnmarshallerContext context) throws Exception {
        Target.Builder targetBuilder = Target.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    targetBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    targetBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    targetBuilder.roleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Input", targetDepth)) {
                    context.nextToken();
                    targetBuilder.input(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InputPath", targetDepth)) {
                    context.nextToken();
                    targetBuilder.inputPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InputTransformer", targetDepth)) {
                    context.nextToken();
                    targetBuilder.inputTransformer(InputTransformerUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.kinesisParameters(KinesisParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RunCommandParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.runCommandParameters(RunCommandParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EcsParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.ecsParameters(EcsParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BatchParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.batchParameters(BatchParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SqsParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.sqsParameters(SqsParametersUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return targetBuilder.build();
    }

    private static final TargetUnmarshaller INSTANCE = new TargetUnmarshaller();

    public static TargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}
