/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.LaunchType;
import software.amazon.awssdk.services.cloudwatchevents.model.NetworkConfiguration;
import software.amazon.awssdk.services.cloudwatchevents.transform.EcsParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, EcsParameters> {
    private final String taskDefinitionArn;
    private final Integer taskCount;
    private final String launchType;
    private final NetworkConfiguration networkConfiguration;
    private final String platformVersion;
    private final String group;

    private EcsParameters(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.taskCount = builder.taskCount;
        this.launchType = builder.launchType;
        this.networkConfiguration = builder.networkConfiguration;
        this.platformVersion = builder.platformVersion;
        this.group = builder.group;
    }

    public String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Integer taskCount() {
        return this.taskCount;
    }

    public LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public String launchTypeAsString() {
        return this.launchType;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String group() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsParameters)) {
            return false;
        }
        EcsParameters other = (EcsParameters)obj;
        return Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.taskCount(), other.taskCount()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.group(), other.group());
    }

    public String toString() {
        return ToString.builder((String)"EcsParameters").add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("TaskCount", (Object)this.taskCount()).add("LaunchType", (Object)this.launchTypeAsString()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlatformVersion", (Object)this.platformVersion()).add("Group", (Object)this.group()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "TaskCount": {
                return Optional.ofNullable(clazz.cast(this.taskCount()));
            }
            case "LaunchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskDefinitionArn;
        private Integer taskCount;
        private String launchType;
        private NetworkConfiguration networkConfiguration;
        private String platformVersion;
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsParameters model) {
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.taskCount(model.taskCount);
            this.launchType(model.launchType);
            this.networkConfiguration(model.networkConfiguration);
            this.platformVersion(model.platformVersion);
            this.group(model.group);
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Integer getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public EcsParameters build() {
            return new EcsParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EcsParameters> {
        public Builder taskDefinitionArn(String var1);

        public Builder taskCount(Integer var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder platformVersion(String var1);

        public Builder group(String var1);
    }
}

