/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutEventsResultEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsResultEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, PutEventsResultEntry> {
    private final String eventId;
    private final String errorCode;
    private final String errorMessage;

    private PutEventsResultEntry(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String eventId() {
        return this.eventId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsResultEntry)) {
            return false;
        }
        PutEventsResultEntry other = (PutEventsResultEntry)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"PutEventsResultEntry").add("EventId", (Object)this.eventId()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutEventsResultEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsResultEntry model) {
            this.eventId(model.eventId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public PutEventsResultEntry build() {
            return new PutEventsResultEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutEventsResultEntry> {
        public Builder eventId(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

