/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.AwsVpcConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AwsVpcConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<String> ASSIGNPUBLICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignPublicIp").isBinary(false).build();
    private static final AwsVpcConfigurationMarshaller INSTANCE = new AwsVpcConfigurationMarshaller();

    private AwsVpcConfigurationMarshaller() {
    }

    public static AwsVpcConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AwsVpcConfiguration awsVpcConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)awsVpcConfiguration, (String)"awsVpcConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(awsVpcConfiguration.subnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(awsVpcConfiguration.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)awsVpcConfiguration.assignPublicIpAsString(), ASSIGNPUBLICIP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

