/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.Target;
import software.amazon.awssdk.services.cloudwatchevents.transform.BatchParametersUnmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.EcsParametersUnmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.InputTransformerUnmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.KinesisParametersUnmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RunCommandParametersUnmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.SqsParametersUnmarshaller;

public class TargetUnmarshaller
implements Unmarshaller<Target, JsonUnmarshallerContext> {
    private static final TargetUnmarshaller INSTANCE = new TargetUnmarshaller();

    public Target unmarshall(JsonUnmarshallerContext context) throws Exception {
        Target.Builder targetBuilder = Target.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    targetBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    targetBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    targetBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Input", targetDepth)) {
                    context.nextToken();
                    targetBuilder.input((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InputPath", targetDepth)) {
                    context.nextToken();
                    targetBuilder.inputPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InputTransformer", targetDepth)) {
                    context.nextToken();
                    targetBuilder.inputTransformer(InputTransformerUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.kinesisParameters(KinesisParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RunCommandParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.runCommandParameters(RunCommandParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EcsParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.ecsParameters(EcsParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BatchParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.batchParameters(BatchParametersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SqsParameters", targetDepth)) {
                    context.nextToken();
                    targetBuilder.sqsParameters(SqsParametersUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Target)targetBuilder.build();
    }

    public static TargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

