/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePermissionRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemovePermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_ID_FIELD));

    private final String statementId;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.statementId = builder.statementId;
    }

    /**
     * <p>
     * The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.
     * </p>
     * 
     * @return The statement ID corresponding to the account that is no longer allowed to put events to the default
     *         event bus.
     */
    public String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        return Objects.equals(statementId(), other.statementId());
    }

    @Override
    public String toString() {
        return ToString.builder("RemovePermissionRequest").add("StatementId", statementId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * The statement ID corresponding to the account that is no longer allowed to put events to the default event
         * bus.
         * </p>
         * 
         * @param statementId
         *        The statement ID corresponding to the account that is no longer allowed to put events to the default
         *        event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            statementId(model.statementId);
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
