/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RuleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRuleRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, PutRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::name)).setter(PutRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::scheduleExpression)).setter(PutRuleRequest.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::eventPattern)).setter(PutRuleRequest.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::stateAsString)).setter(PutRuleRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::description)).setter(PutRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRuleRequest.getter(PutRuleRequest::roleArn)).setter(PutRuleRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEDULE_EXPRESSION_FIELD, EVENT_PATTERN_FIELD, STATE_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD));
    private final String name;
    private final String scheduleExpression;
    private final String eventPattern;
    private final String state;
    private final String description;
    private final String roleArn;

    private PutRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scheduleExpression = builder.scheduleExpression;
        this.eventPattern = builder.eventPattern;
        this.state = builder.state;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
    }

    public String name() {
        return this.name;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public String eventPattern() {
        return this.eventPattern;
    }

    public RuleState state() {
        return RuleState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String description() {
        return this.description;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuleRequest)) {
            return false;
        }
        PutRuleRequest other = (PutRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.eventPattern(), other.eventPattern()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"PutRuleRequest").add("Name", (Object)this.name()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("EventPattern", (Object)this.eventPattern()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "EventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRuleRequest, T> g) {
        return obj -> g.apply((PutRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String scheduleExpression;
        private String eventPattern;
        private String state;
        private String description;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuleRequest model) {
            super(model);
            this.name(model.name);
            this.scheduleExpression(model.scheduleExpression);
            this.eventPattern(model.eventPattern);
            this.state(model.state);
            this.description(model.description);
            this.roleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RuleState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRuleRequest build() {
            return new PutRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRuleRequest> {
        public Builder name(String var1);

        public Builder scheduleExpression(String var1);

        public Builder eventPattern(String var1);

        public Builder state(String var1);

        public Builder state(RuleState var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

