/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<PutEventsResponse.Builder, PutEventsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutEventsResponse::failedEntryCount)).setter(setter(Builder::failedEntryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()).build();

    private static final SdkField<List<PutEventsResultEntry>> ENTRIES_FIELD = SdkField
            .<List<PutEventsResultEntry>> builder(MarshallingType.LIST)
            .getter(getter(PutEventsResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutEventsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutEventsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD,
            ENTRIES_FIELD));

    private final Integer failedEntryCount;

    private final List<PutEventsResultEntry> entries;

    private PutEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The number of failed entries.
     * </p>
     * 
     * @return The number of failed entries.
     */
    public Integer failedEntryCount() {
        return failedEntryCount;
    }

    /**
     * <p>
     * The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has the
     * event ID in it. Otherwise, you can use the error code and error message to identify the problem with the entry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry
     *         has the event ID in it. Otherwise, you can use the error code and error message to identify the problem
     *         with the entry.
     */
    public List<PutEventsResultEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsResponse)) {
            return false;
        }
        PutEventsResponse other = (PutEventsResponse) obj;
        return Objects.equals(failedEntryCount(), other.failedEntryCount()) && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEventsResponse").add("FailedEntryCount", failedEntryCount()).add("Entries", entries())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEntryCount":
            return Optional.ofNullable(clazz.cast(failedEntryCount()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsResponse, T> g) {
        return obj -> g.apply((PutEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsResponse> {
        /**
         * <p>
         * The number of failed entries.
         * </p>
         * 
         * @param failedEntryCount
         *        The number of failed entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntryCount(Integer failedEntryCount);

        /**
         * <p>
         * The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has
         * the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the
         * entry.
         * </p>
         * 
         * @param entries
         *        The successfully and unsuccessfully ingested events results. If the ingestion was successful, the
         *        entry has the event ID in it. Otherwise, you can use the error code and error message to identify the
         *        problem with the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<PutEventsResultEntry> entries);

        /**
         * <p>
         * The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has
         * the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the
         * entry.
         * </p>
         * 
         * @param entries
         *        The successfully and unsuccessfully ingested events results. If the ingestion was successful, the
         *        entry has the event ID in it. Otherwise, you can use the error code and error message to identify the
         *        problem with the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(PutEventsResultEntry... entries);

        /**
         * <p>
         * The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has
         * the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the
         * entry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutEventsResultEntry>.Builder} avoiding the
         * need to create one manually via {@link List<PutEventsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutEventsResultEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #entries(List<PutEventsResultEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<PutEventsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<PutEventsResultEntry>)
         */
        Builder entries(Consumer<PutEventsResultEntry.Builder>... entries);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private Integer failedEntryCount;

        private List<PutEventsResultEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsResponse model) {
            super(model);
            failedEntryCount(model.failedEntryCount);
            entries(model.entries);
        }

        public final Integer getFailedEntryCount() {
            return failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        public final Collection<PutEventsResultEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(PutEventsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<PutEventsResultEntry> entries) {
            this.entries = PutEventsResultEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutEventsResultEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutEventsResultEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> PutEventsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<PutEventsResultEntry.BuilderImpl> entries) {
            this.entries = PutEventsResultEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public PutEventsResponse build() {
            return new PutEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
