/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventSourceResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<DescribeEventSourceResponse.Builder, DescribeEventSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEventSourceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEventSourceResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeEventSourceResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeEventSourceResponse::expirationTime)).setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEventSourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEventSourceResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_BY_FIELD,
            CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, NAME_FIELD, STATE_FIELD));

    private final String arn;

    private final String createdBy;

    private final Instant creationTime;

    private final Instant expirationTime;

    private final String name;

    private final String state;

    private DescribeEventSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ARN of the partner event source.
     * </p>
     * 
     * @return The ARN of the partner event source.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the SaaS partner that created the event source.
     * </p>
     * 
     * @return The name of the SaaS partner that created the event source.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the event source was created.
     * </p>
     * 
     * @return The date and time that the event source was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the event source will expire if you don't create a matching event bus.
     * </p>
     * 
     * @return The date and time that the event source will expire if you don't create a matching event bus.
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The name of the partner event source.
     * </p>
     * 
     * @return The name of the partner event source.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus for
     * this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet created a
     * matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have created a matching
     * event bus, but the event source has since been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventSourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus
     *         for this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet
     *         created a matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have
     *         created a matching event bus, but the event source has since been deleted.
     * @see EventSourceState
     */
    public EventSourceState state() {
        return EventSourceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus for
     * this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet created a
     * matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have created a matching
     * event bus, but the event source has since been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventSourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus
     *         for this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet
     *         created a matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have
     *         created a matching event bus, but the event source has since been deleted.
     * @see EventSourceState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSourceResponse)) {
            return false;
        }
        DescribeEventSourceResponse other = (DescribeEventSourceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(expirationTime(), other.expirationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventSourceResponse").add("Arn", arn()).add("CreatedBy", createdBy())
                .add("CreationTime", creationTime()).add("ExpirationTime", expirationTime()).add("Name", name())
                .add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSourceResponse, T> g) {
        return obj -> g.apply((DescribeEventSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventSourceResponse> {
        /**
         * <p>
         * The ARN of the partner event source.
         * </p>
         * 
         * @param arn
         *        The ARN of the partner event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the SaaS partner that created the event source.
         * </p>
         * 
         * @param createdBy
         *        The name of the SaaS partner that created the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the event source was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the event source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the event source will expire if you don't create a matching event bus.
         * </p>
         * 
         * @param expirationTime
         *        The date and time that the event source will expire if you don't create a matching event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The name of the partner event source.
         * </p>
         * 
         * @param name
         *        The name of the partner event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus for
         * this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet created
         * a matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have created a
         * matching event bus, but the event source has since been deleted.
         * </p>
         * 
         * @param state
         *        The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event
         *        bus for this event source, and that event bus is active. If it's <code>PENDING</code>, either you
         *        haven't yet created a matching event bus, or that event bus is deactivated. If it's
         *        <code>DELETED</code>, you have created a matching event bus, but the event source has since been
         *        deleted.
         * @see EventSourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event bus for
         * this event source, and that event bus is active. If it's <code>PENDING</code>, either you haven't yet created
         * a matching event bus, or that event bus is deactivated. If it's <code>DELETED</code>, you have created a
         * matching event bus, but the event source has since been deleted.
         * </p>
         * 
         * @param state
         *        The state of the event source. If it's <code>ACTIVE</code>, you have already created a matching event
         *        bus for this event source, and that event bus is active. If it's <code>PENDING</code>, either you
         *        haven't yet created a matching event bus, or that event bus is deactivated. If it's
         *        <code>DELETED</code>, you have created a matching event bus, but the event source has since been
         *        deleted.
         * @see EventSourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceState
         */
        Builder state(EventSourceState state);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String arn;

        private String createdBy;

        private Instant creationTime;

        private Instant expirationTime;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSourceResponse model) {
            super(model);
            arn(model.arn);
            createdBy(model.createdBy);
            creationTime(model.creationTime);
            expirationTime(model.expirationTime);
            name(model.name);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventSourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public DescribeEventSourceResponse build() {
            return new DescribeEventSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
