/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.InternalException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidEventPatternException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidStateException;
import software.amazon.awssdk.services.cloudwatchevents.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ManagedRuleException;
import software.amazon.awssdk.services.cloudwatchevents.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceResponse;

/**
 * Service client for accessing Amazon CloudWatch Events. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon EventBridge helps you to respond to state changes in your AWS resources. When your resources change state,
 * they automatically send events into an event stream. You can create rules that match selected events in the stream
 * and route them to targets to take action. You can also use rules to take action on a predetermined schedule. For
 * example, you can configure rules to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Automatically invoke an AWS Lambda function to update DNS entries when an event notifies you that Amazon EC2 instance
 * enters the running state
 * </p>
 * </li>
 * <li>
 * <p>
 * Direct specific API records from AWS CloudTrail to an Amazon Kinesis data stream for detailed analysis of potential
 * security or availability risks
 * </p>
 * </li>
 * <li>
 * <p>
 * Periodically invoke a built-in target to create a snapshot of an Amazon EBS volume
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about the features of Amazon EventBridge, see the <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/">Amazon EventBridge User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudWatchEventsClient extends SdkClient {
    String SERVICE_NAME = "events";

    /**
     * Create a {@link CloudWatchEventsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudWatchEventsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudWatchEventsClient}.
     */
    static CloudWatchEventsClientBuilder builder() {
        return new DefaultCloudWatchEventsClientBuilder();
    }

    /**
     * <p>
     * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start
     * receiving events from the event source.
     * </p>
     * <note>
     * <p>
     * This operation is performed by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param activateEventSourceRequest
     * @return Result of the ActivateEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ActivateEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ActivateEventSource" target="_top">AWS API
     *      Documentation</a>
     */
    default ActivateEventSourceResponse activateEventSource(ActivateEventSourceRequest activateEventSourceRequest)
            throws ResourceNotFoundException, InvalidStateException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start
     * receiving events from the event source.
     * </p>
     * <note>
     * <p>
     * This operation is performed by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEventSourceRequest#builder()}
     * </p>
     *
     * @param activateEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link ActivateEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the ActivateEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ActivateEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ActivateEventSource" target="_top">AWS API
     *      Documentation</a>
     */
    default ActivateEventSourceResponse activateEventSource(
            Consumer<ActivateEventSourceRequest.Builder> activateEventSourceRequest) throws ResourceNotFoundException,
            InvalidStateException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return activateEventSource(ActivateEventSourceRequest.builder().applyMutation(activateEventSourceRequest).build());
    }

    /**
     * <p>
     * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events
     * from your own custom applications and services, or it can be a partner event bus which can be matched to a
     * partner event source.
     * </p>
     * <note>
     * <p>
     * This operation is used by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param createEventBusRequest
     * @return Result of the CreateEventBus operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource that you're trying to create already exists.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.CreateEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/CreateEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEventBusResponse createEventBus(CreateEventBusRequest createEventBusRequest)
            throws ResourceAlreadyExistsException, ResourceNotFoundException, InvalidStateException, InternalException,
            ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events
     * from your own custom applications and services, or it can be a partner event bus which can be matched to a
     * partner event source.
     * </p>
     * <note>
     * <p>
     * This operation is used by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBusRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEventBusRequest#builder()}
     * </p>
     *
     * @param createEventBusRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventBusRequest.Builder} to create a request.
     * @return Result of the CreateEventBus operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource that you're trying to create already exists.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.CreateEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/CreateEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEventBusResponse createEventBus(Consumer<CreateEventBusRequest.Builder> createEventBusRequest)
            throws ResourceAlreadyExistsException, ResourceNotFoundException, InvalidStateException, InternalException,
            ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return createEventBus(CreateEventBusRequest.builder().applyMutation(createEventBusRequest).build());
    }

    /**
     * <p>
     * Called by an SaaS partner to create a partner event source.
     * </p>
     * <note>
     * <p>
     * This operation is not used by AWS customers.
     * </p>
     * </note>
     * <p>
     * Each partner event source can be used by one AWS account to create a matching partner event bus in that AWS
     * account. A SaaS partner must create one partner event source for each AWS account that wants to receive those
     * event types.
     * </p>
     * <p>
     * A partner event source creates events based on resources in the SaaS partner's service or application.
     * </p>
     * <p>
     * An AWS account that creates a partner event bus that matches the partner event source can use that event bus to
     * receive events from the partner, and then process them using AWS Events rules and targets.
     * </p>
     * <p>
     * Partner event source names follow this format:
     * </p>
     * <p>
     * <code>aws.partner/<i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>partner_name</i> is determined during partner registration and identifies the partner to AWS customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <i>event_namespace</i>, we recommend that partners use a string that identifies the AWS customer within the
     * partner's system. This should not be the customer's AWS account ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within
     * the partner system. This should help AWS customers decide whether to create an event bus to receive these events.
     * </p>
     * </li>
     * </ul>
     *
     * @param createPartnerEventSourceRequest
     * @return Result of the CreatePartnerEventSource operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource that you're trying to create already exists.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.CreatePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/CreatePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePartnerEventSourceResponse createPartnerEventSource(
            CreatePartnerEventSourceRequest createPartnerEventSourceRequest) throws ResourceAlreadyExistsException,
            InternalException, ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Called by an SaaS partner to create a partner event source.
     * </p>
     * <note>
     * <p>
     * This operation is not used by AWS customers.
     * </p>
     * </note>
     * <p>
     * Each partner event source can be used by one AWS account to create a matching partner event bus in that AWS
     * account. A SaaS partner must create one partner event source for each AWS account that wants to receive those
     * event types.
     * </p>
     * <p>
     * A partner event source creates events based on resources in the SaaS partner's service or application.
     * </p>
     * <p>
     * An AWS account that creates a partner event bus that matches the partner event source can use that event bus to
     * receive events from the partner, and then process them using AWS Events rules and targets.
     * </p>
     * <p>
     * Partner event source names follow this format:
     * </p>
     * <p>
     * <code>aws.partner/<i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>partner_name</i> is determined during partner registration and identifies the partner to AWS customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <i>event_namespace</i>, we recommend that partners use a string that identifies the AWS customer within the
     * partner's system. This should not be the customer's AWS account ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within
     * the partner system. This should help AWS customers decide whether to create an event bus to receive these events.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param createPartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreatePartnerEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePartnerEventSource operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource that you're trying to create already exists.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.CreatePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/CreatePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePartnerEventSourceResponse createPartnerEventSource(
            Consumer<CreatePartnerEventSourceRequest.Builder> createPartnerEventSourceRequest)
            throws ResourceAlreadyExistsException, InternalException, ConcurrentModificationException, LimitExceededException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return createPartnerEventSource(CreatePartnerEventSourceRequest.builder().applyMutation(createPartnerEventSourceRequest)
                .build());
    }

    /**
     * <p>
     * An AWS customer uses this operation to temporarily stop receiving events from the specified partner event source.
     * The matching event bus isn't deleted.
     * </p>
     * <p>
     * When you deactivate a partner event source, the source goes into <code>PENDING</code> state. If it remains in
     * <code>PENDING</code> state for more than two weeks, it's deleted.
     * </p>
     * <p>
     * To activate a deactivated partner event source, use <a>ActivateEventSource</a>.
     * </p>
     *
     * @param deactivateEventSourceRequest
     * @return Result of the DeactivateEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeactivateEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeactivateEventSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeactivateEventSourceResponse deactivateEventSource(DeactivateEventSourceRequest deactivateEventSourceRequest)
            throws ResourceNotFoundException, InvalidStateException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An AWS customer uses this operation to temporarily stop receiving events from the specified partner event source.
     * The matching event bus isn't deleted.
     * </p>
     * <p>
     * When you deactivate a partner event source, the source goes into <code>PENDING</code> state. If it remains in
     * <code>PENDING</code> state for more than two weeks, it's deleted.
     * </p>
     * <p>
     * To activate a deactivated partner event source, use <a>ActivateEventSource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeactivateEventSourceRequest#builder()}
     * </p>
     *
     * @param deactivateEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeactivateEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InvalidStateException
     *         The specified state isn't a valid state for an event source.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeactivateEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeactivateEventSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeactivateEventSourceResponse deactivateEventSource(
            Consumer<DeactivateEventSourceRequest.Builder> deactivateEventSourceRequest) throws ResourceNotFoundException,
            InvalidStateException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return deactivateEventSource(DeactivateEventSourceRequest.builder().applyMutation(deactivateEventSourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus are also
     * deleted. You can't delete your account's default event bus.
     * </p>
     * <note>
     * <p>
     * This operation is performed by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param deleteEventBusRequest
     * @return Result of the DeleteEventBus operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeleteEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventBusResponse deleteEventBus(DeleteEventBusRequest deleteEventBusRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus are also
     * deleted. You can't delete your account's default event bus.
     * </p>
     * <note>
     * <p>
     * This operation is performed by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBusRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventBusRequest#builder()}
     * </p>
     *
     * @param deleteEventBusRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventBusRequest.Builder} to create a request.
     * @return Result of the DeleteEventBus operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeleteEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventBusResponse deleteEventBus(Consumer<DeleteEventBusRequest.Builder> deleteEventBusRequest)
            throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return deleteEventBus(DeleteEventBusRequest.builder().applyMutation(deleteEventBusRequest).build());
    }

    /**
     * <p>
     * This operation is used by SaaS partners to delete a partner event source. AWS customers don't use this operation.
     * </p>
     * <p>
     * When you delete an event source, the status of the corresponding partner event bus in the AWS customer account
     * becomes <code>DELETED</code>.
     * </p>
     *
     * @param deletePartnerEventSourceRequest
     * @return Result of the DeletePartnerEventSource operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeletePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeletePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePartnerEventSourceResponse deletePartnerEventSource(
            DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) throws InternalException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation is used by SaaS partners to delete a partner event source. AWS customers don't use this operation.
     * </p>
     * <p>
     * When you delete an event source, the status of the corresponding partner event bus in the AWS customer account
     * becomes <code>DELETED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param deletePartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeletePartnerEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePartnerEventSource operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeletePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeletePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePartnerEventSourceResponse deletePartnerEventSource(
            Consumer<DeletePartnerEventSourceRequest.Builder> deletePartnerEventSourceRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return deletePartnerEventSource(DeletePartnerEventSourceRequest.builder().applyMutation(deletePartnerEventSourceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * Before you can delete the rule, you must remove all targets, using <a>RemoveTargets</a>.
     * </p>
     * <p>
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time
     * for changes to take effect.
     * </p>
     * <p>
     * Managed rules are rules created and managed by another AWS service on your behalf. These rules are created by
     * those other AWS services to support functionality in those services. You can delete these rules using the
     * <code>Force</code> option, but you should do so only if you're sure that the other service isn't still using that
     * rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeleteRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConcurrentModificationException,
            ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * Before you can delete the rule, you must remove all targets, using <a>RemoveTargets</a>.
     * </p>
     * <p>
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time
     * for changes to take effect.
     * </p>
     * <p>
     * Managed rules are rules created and managed by another AWS service on your behalf. These rules are created by
     * those other AWS services to support functionality in those services. You can delete these rules using the
     * <code>Force</code> option, but you should do so only if you're sure that the other service isn't still using that
     * rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleRequest.Builder} to create a request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DeleteRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest)
            throws ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Displays details about an event bus in your account. This can include the external AWS accounts that are
     * permitted to write events to your default event bus, and the associated policy. For custom event buses and
     * partner event buses, it displays the name, ARN, policy, state, and creation time.
     * </p>
     * <p>
     * To enable your account to receive events from other accounts on its default event bus, use <a>PutPermission</a>.
     * </p>
     * <p>
     * For more information about partner event buses, see <a>CreateEventBus</a>.
     * </p>
     *
     * @return Result of the DescribeEventBus operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeEventBus
     * @see #describeEventBus(DescribeEventBusRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventBusResponse describeEventBus() throws ResourceNotFoundException, InternalException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        return describeEventBus(DescribeEventBusRequest.builder().build());
    }

    /**
     * <p>
     * Displays details about an event bus in your account. This can include the external AWS accounts that are
     * permitted to write events to your default event bus, and the associated policy. For custom event buses and
     * partner event buses, it displays the name, ARN, policy, state, and creation time.
     * </p>
     * <p>
     * To enable your account to receive events from other accounts on its default event bus, use <a>PutPermission</a>.
     * </p>
     * <p>
     * For more information about partner event buses, see <a>CreateEventBus</a>.
     * </p>
     *
     * @param describeEventBusRequest
     * @return Result of the DescribeEventBus operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventBusResponse describeEventBus(DescribeEventBusRequest describeEventBusRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays details about an event bus in your account. This can include the external AWS accounts that are
     * permitted to write events to your default event bus, and the associated policy. For custom event buses and
     * partner event buses, it displays the name, ARN, policy, state, and creation time.
     * </p>
     * <p>
     * To enable your account to receive events from other accounts on its default event bus, use <a>PutPermission</a>.
     * </p>
     * <p>
     * For more information about partner event buses, see <a>CreateEventBus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventBusRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEventBusRequest#builder()}
     * </p>
     *
     * @param describeEventBusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventBusRequest.Builder} to create a request.
     * @return Result of the DescribeEventBus operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeEventBus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventBus" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventBusResponse describeEventBus(Consumer<DescribeEventBusRequest.Builder> describeEventBusRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return describeEventBus(DescribeEventBusRequest.builder().applyMutation(describeEventBusRequest).build());
    }

    /**
     * <p>
     * This operation lists details about a partner event source that is shared with your account.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param describeEventSourceRequest
     * @return Result of the DescribeEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventSourceResponse describeEventSource(DescribeEventSourceRequest describeEventSourceRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists details about a partner event source that is shared with your account.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventSourceRequest#builder()}
     * </p>
     *
     * @param describeEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventSourceResponse describeEventSource(
            Consumer<DescribeEventSourceRequest.Builder> describeEventSourceRequest) throws ResourceNotFoundException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return describeEventSource(DescribeEventSourceRequest.builder().applyMutation(describeEventSourceRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list details about a partner event source that they have created.
     * </p>
     * <note>
     * <p>
     * AWS customers do not use this operation. Instead, AWS customers can use <a>DescribeEventSource</a> to see details
     * about a partner event source that is shared with them.
     * </p>
     * </note>
     *
     * @param describePartnerEventSourceRequest
     * @return Result of the DescribePartnerEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePartnerEventSourceResponse describePartnerEventSource(
            DescribePartnerEventSourceRequest describePartnerEventSourceRequest) throws ResourceNotFoundException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list details about a partner event source that they have created.
     * </p>
     * <note>
     * <p>
     * AWS customers do not use this operation. Instead, AWS customers can use <a>DescribeEventSource</a> to see details
     * about a partner event source that is shared with them.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param describePartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribePartnerEventSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePartnerEventSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribePartnerEventSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePartnerEventSourceResponse describePartnerEventSource(
            Consumer<DescribePartnerEventSourceRequest.Builder> describePartnerEventSourceRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return describePartnerEventSource(DescribePartnerEventSourceRequest.builder()
                .applyMutation(describePartnerEventSourceRequest).build());
    }

    /**
     * <p>
     * Describes the specified rule.
     * </p>
     * <p>
     * <code>DescribeRule</code> doesn't list the targets of a rule. To see the targets associated with a rule, use
     * <a>ListTargetsByRule</a>.
     * </p>
     *
     * @param describeRuleRequest
     * @return Result of the DescribeRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRuleResponse describeRule(DescribeRuleRequest describeRuleRequest) throws ResourceNotFoundException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified rule.
     * </p>
     * <p>
     * <code>DescribeRule</code> doesn't list the targets of a rule. To see the targets associated with a rule, use
     * <a>ListTargetsByRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRuleRequest#builder()}
     * </p>
     *
     * @param describeRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRuleRequest.Builder} to create a request.
     * @return Result of the DescribeRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DescribeRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRuleResponse describeRule(Consumer<DescribeRuleRequest.Builder> describeRuleRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return describeRule(DescribeRuleRequest.builder().applyMutation(describeRuleRequest).build());
    }

    /**
     * <p>
     * Disables the specified rule. A disabled rule won't match any events and won't self-trigger if it has a schedule
     * expression.
     * </p>
     * <p>
     * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of
     * time for changes to take effect.
     * </p>
     *
     * @param disableRuleRequest
     * @return Result of the DisableRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DisableRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableRuleResponse disableRule(DisableRuleRequest disableRuleRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified rule. A disabled rule won't match any events and won't self-trigger if it has a schedule
     * expression.
     * </p>
     * <p>
     * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of
     * time for changes to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DisableRuleRequest#builder()}
     * </p>
     *
     * @param disableRuleRequest
     *        A {@link Consumer} that will call methods on {@link DisableRuleRequest.Builder} to create a request.
     * @return Result of the DisableRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.DisableRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableRuleResponse disableRule(Consumer<DisableRuleRequest.Builder> disableRuleRequest)
            throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return disableRule(DisableRuleRequest.builder().applyMutation(disableRuleRequest).build());
    }

    /**
     * <p>
     * Enables the specified rule. If the rule doesn't exist, the operation fails.
     * </p>
     * <p>
     * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a
     * short period of time for changes to take effect.
     * </p>
     *
     * @param enableRuleRequest
     * @return Result of the EnableRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.EnableRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableRuleResponse enableRule(EnableRuleRequest enableRuleRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified rule. If the rule doesn't exist, the operation fails.
     * </p>
     * <p>
     * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a
     * short period of time for changes to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRuleRequest.Builder} avoiding the need to
     * create one manually via {@link EnableRuleRequest#builder()}
     * </p>
     *
     * @param enableRuleRequest
     *        A {@link Consumer} that will call methods on {@link EnableRuleRequest.Builder} to create a request.
     * @return Result of the EnableRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.EnableRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableRuleResponse enableRule(Consumer<EnableRuleRequest.Builder> enableRuleRequest)
            throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return enableRule(EnableRuleRequest.builder().applyMutation(enableRuleRequest).build());
    }

    /**
     * <p>
     * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event
     * buses.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param listEventBusesRequest
     * @return Result of the ListEventBuses operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListEventBuses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListEventBuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventBusesResponse listEventBuses(ListEventBusesRequest listEventBusesRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event
     * buses.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBusesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventBusesRequest#builder()}
     * </p>
     *
     * @param listEventBusesRequest
     *        A {@link Consumer} that will call methods on {@link ListEventBusesRequest.Builder} to create a request.
     * @return Result of the ListEventBuses operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListEventBuses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListEventBuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventBusesResponse listEventBuses(Consumer<ListEventBusesRequest.Builder> listEventBusesRequest)
            throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listEventBuses(ListEventBusesRequest.builder().applyMutation(listEventBusesRequest).build());
    }

    /**
     * <p>
     * You can use this to see all the partner event sources that have been shared with your AWS account. For more
     * information about partner event sources, see <a>CreateEventBus</a>.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note>
     *
     * @param listEventSourcesRequest
     * @return Result of the ListEventSources operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListEventSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListEventSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventSourcesResponse listEventSources(ListEventSourcesRequest listEventSourcesRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use this to see all the partner event sources that have been shared with your AWS account. For more
     * information about partner event sources, see <a>CreateEventBus</a>.
     * </p>
     * <note>
     * <p>
     * This operation is run by AWS customers, not by SaaS partners.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventSourcesRequest#builder()}
     * </p>
     *
     * @param listEventSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSourcesRequest.Builder} to create a request.
     * @return Result of the ListEventSources operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListEventSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListEventSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventSourcesResponse listEventSources(Consumer<ListEventSourcesRequest.Builder> listEventSourcesRequest)
            throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listEventSources(ListEventSourcesRequest.builder().applyMutation(listEventSourcesRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to display the AWS account ID that a particular partner event source name
     * is associated with.
     * </p>
     * <note>
     * <p>
     * This operation is used by SaaS partners, not by AWS customers.
     * </p>
     * </note>
     *
     * @param listPartnerEventSourceAccountsRequest
     * @return Result of the ListPartnerEventSourceAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListPartnerEventSourceAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListPartnerEventSourceAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccounts(
            ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) throws ResourceNotFoundException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to display the AWS account ID that a particular partner event source name
     * is associated with.
     * </p>
     * <note>
     * <p>
     * This operation is used by SaaS partners, not by AWS customers.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerEventSourceAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPartnerEventSourceAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerEventSourceAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerEventSourceAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPartnerEventSourceAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListPartnerEventSourceAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListPartnerEventSourceAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccounts(
            Consumer<ListPartnerEventSourceAccountsRequest.Builder> listPartnerEventSourceAccountsRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest.builder()
                .applyMutation(listPartnerEventSourceAccountsRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list all the partner event source names that they have created.
     * </p>
     * <note>
     * <p>
     * This operation is not used by AWS customers.
     * </p>
     * </note>
     *
     * @param listPartnerEventSourcesRequest
     * @return Result of the ListPartnerEventSources operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListPartnerEventSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListPartnerEventSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPartnerEventSourcesResponse listPartnerEventSources(ListPartnerEventSourcesRequest listPartnerEventSourcesRequest)
            throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list all the partner event source names that they have created.
     * </p>
     * <note>
     * <p>
     * This operation is not used by AWS customers.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerEventSourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListPartnerEventSourcesRequest#builder()}
     * </p>
     *
     * @param listPartnerEventSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListPartnerEventSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPartnerEventSources operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListPartnerEventSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListPartnerEventSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPartnerEventSourcesResponse listPartnerEventSources(
            Consumer<ListPartnerEventSourcesRequest.Builder> listPartnerEventSourcesRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listPartnerEventSources(ListPartnerEventSourcesRequest.builder().applyMutation(listPartnerEventSourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the rules for the specified target. You can see which rules can invoke a specific target in your account.
     * </p>
     *
     * @param listRuleNamesByTargetRequest
     * @return Result of the ListRuleNamesByTarget operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListRuleNamesByTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRuleNamesByTargetResponse listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest)
            throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules for the specified target. You can see which rules can invoke a specific target in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleNamesByTargetRequest.Builder} avoiding the
     * need to create one manually via {@link ListRuleNamesByTargetRequest#builder()}
     * </p>
     *
     * @param listRuleNamesByTargetRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleNamesByTargetRequest.Builder} to create a
     *        request.
     * @return Result of the ListRuleNamesByTarget operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListRuleNamesByTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRuleNamesByTargetResponse listRuleNamesByTarget(
            Consumer<ListRuleNamesByTargetRequest.Builder> listRuleNamesByTargetRequest) throws InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listRuleNamesByTarget(ListRuleNamesByTargetRequest.builder().applyMutation(listRuleNamesByTargetRequest).build());
    }

    /**
     * <p>
     * Lists your EventBridge rules. You can either list all the rules or provide a prefix to match to the rule names.
     * </p>
     * <p>
     * <code>ListRules</code> doesn't list the targets of a rule. To see the targets associated with a rule, use
     * <a>ListTargetsByRule</a>.
     * </p>
     *
     * @return Result of the ListRules operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListRules
     * @see #listRules(ListRulesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules() throws InternalException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        return listRules(ListRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists your EventBridge rules. You can either list all the rules or provide a prefix to match to the rule names.
     * </p>
     * <p>
     * <code>ListRules</code> doesn't list the targets of a rule. To see the targets associated with a rule, use
     * <a>ListTargetsByRule</a>.
     * </p>
     *
     * @param listRulesRequest
     * @return Result of the ListRules operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws InternalException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your EventBridge rules. You can either list all the rules or provide a prefix to match to the rule names.
     * </p>
     * <p>
     * <code>ListRules</code> doesn't list the targets of a rule. To see the targets associated with a rule, use
     * <a>ListTargetsByRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesRequest.Builder} to create a request.
     * @return Result of the ListRules operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) throws InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the targets assigned to the specified rule.
     * </p>
     *
     * @param listTargetsByRuleRequest
     * @return Result of the ListTargetsByRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListTargetsByRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsByRuleResponse listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets assigned to the specified rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsByRuleRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetsByRuleRequest#builder()}
     * </p>
     *
     * @param listTargetsByRuleRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetsByRuleRequest.Builder} to create a request.
     * @return Result of the ListTargetsByRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.ListTargetsByRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsByRuleResponse listTargetsByRule(Consumer<ListTargetsByRuleRequest.Builder> listTargetsByRuleRequest)
            throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return listTargetsByRule(ListTargetsByRuleRequest.builder().applyMutation(listTargetsByRuleRequest).build());
    }

    /**
     * <p>
     * Sends custom events to EventBridge so that they can be matched to rules. These events can be from your custom
     * applications and services.
     * </p>
     *
     * @param putEventsRequest
     * @return Result of the PutEvents operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws InternalException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends custom events to EventBridge so that they can be matched to rules. These events can be from your custom
     * applications and services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutEventsRequest.Builder} to create a request.
     * @return Result of the PutEvents operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventsResponse putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * <p>
     * This is used by SaaS partners to write events to a customer's partner event bus.
     * </p>
     * <note>
     * <p>
     * AWS customers do not use this operation. Instead, AWS customers can use <a>PutEvents</a> to write custom events
     * from their own applications to an event bus.
     * </p>
     * </note>
     *
     * @param putPartnerEventsRequest
     * @return Result of the PutPartnerEvents operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutPartnerEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPartnerEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPartnerEventsResponse putPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) throws InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is used by SaaS partners to write events to a customer's partner event bus.
     * </p>
     * <note>
     * <p>
     * AWS customers do not use this operation. Instead, AWS customers can use <a>PutEvents</a> to write custom events
     * from their own applications to an event bus.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPartnerEventsRequest.Builder} avoiding the need
     * to create one manually via {@link PutPartnerEventsRequest#builder()}
     * </p>
     *
     * @param putPartnerEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutPartnerEventsRequest.Builder} to create a request.
     * @return Result of the PutPartnerEvents operation returned by the service.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutPartnerEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPartnerEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPartnerEventsResponse putPartnerEvents(Consumer<PutPartnerEventsRequest.Builder> putPartnerEventsRequest)
            throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return putPartnerEvents(PutPartnerEventsRequest.builder().applyMutation(putPartnerEventsRequest).build());
    }

    /**
     * <p>
     * Running <code>PutPermission</code> permits the specified AWS account or AWS organization to put events to the
     * specified <i>event bus</i>. Rules in your account are triggered by these events arriving to an event bus in your
     * account.
     * </p>
     * <p>
     * For another account to send events to your account, that external account must have a rule with your account's
     * event bus as a target.
     * </p>
     * <p>
     * To enable multiple AWS accounts to put events to an event bus, run <code>PutPermission</code> once for each of
     * these accounts. Or, if all the accounts are members of the same AWS organization, you can run
     * <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying the AWS organization ID
     * in <code>Condition</code>, to grant permissions to all accounts in that organization.
     * </p>
     * <p>
     * If you grant permissions using an organization, then accounts in that organization must specify a
     * <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus
     * as a target. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between AWS Accounts</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * The permission policy on an event bus can't exceed 10 KB in size.
     * </p>
     *
     * @param putPermissionRequest
     * @return Result of the PutPermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws PolicyLengthExceededException
     *         The event bus policy is too long. For more information, see the limits.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPermissionResponse putPermission(PutPermissionRequest putPermissionRequest) throws ResourceNotFoundException,
            PolicyLengthExceededException, InternalException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Running <code>PutPermission</code> permits the specified AWS account or AWS organization to put events to the
     * specified <i>event bus</i>. Rules in your account are triggered by these events arriving to an event bus in your
     * account.
     * </p>
     * <p>
     * For another account to send events to your account, that external account must have a rule with your account's
     * event bus as a target.
     * </p>
     * <p>
     * To enable multiple AWS accounts to put events to an event bus, run <code>PutPermission</code> once for each of
     * these accounts. Or, if all the accounts are members of the same AWS organization, you can run
     * <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying the AWS organization ID
     * in <code>Condition</code>, to grant permissions to all accounts in that organization.
     * </p>
     * <p>
     * If you grant permissions using an organization, then accounts in that organization must specify a
     * <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus
     * as a target. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between AWS Accounts</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * The permission policy on an event bus can't exceed 10 KB in size.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link PutPermissionRequest#builder()}
     * </p>
     *
     * @param putPermissionRequest
     *        A {@link Consumer} that will call methods on {@link PutPermissionRequest.Builder} to create a request.
     * @return Result of the PutPermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws PolicyLengthExceededException
     *         The event bus policy is too long. For more information, see the limits.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPermissionResponse putPermission(Consumer<PutPermissionRequest.Builder> putPermissionRequest)
            throws ResourceNotFoundException, PolicyLengthExceededException, InternalException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return putPermission(PutPermissionRequest.builder().applyMutation(putPermissionRequest).build());
    }

    /**
     * <p>
     * Creates or updates the specified rule. Rules are enabled by default or based on value of the state. You can
     * disable a rule using <a>DisableRule</a>.
     * </p>
     * <p>
     * A single rule watches for events from a single event bus. Events generated by AWS services go to your account's
     * default event bus. Events generated by SaaS partner services or applications go to the matching partner event
     * bus. If you have custom applications or services, you can specify whether their events go to your default event
     * bus or a custom event bus that you have created. For more information, see <a>CreateEventBus</a>.
     * </p>
     * <p>
     * If you're updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code>
     * command. If you omit arguments in <code>PutRule</code>, the old values for those arguments aren't kept. Instead,
     * they're replaced with null values.
     * </p>
     * <p>
     * When you create or update a rule, incoming events might not immediately start matching to new or updated rules.
     * Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * A rule must contain at least an <code>EventPattern</code> or <code>ScheduleExpression</code>. Rules with
     * <code>EventPatterns</code> are triggered when a matching event is observed. Rules with
     * <code>ScheduleExpressions</code> self-trigger based on the given schedule. A rule can have both an
     * <code>EventPattern</code> and a <code>ScheduleExpression</code>, in which case the rule triggers on matching
     * events as well as on a schedule.
     * </p>
     * <p>
     * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions, by granting a user
     * permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and
     * assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.
     * </p>
     * <p>
     * If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To
     * update the tags of an existing rule, use <a>TagResource</a> and <a>UntagResource</a>.
     * </p>
     * <p>
     * Most services in AWS treat <code>:</code> or <code>/</code> as the same character in Amazon Resource Names
     * (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN
     * characters when creating event patterns so that they match the ARN syntax in the event that you want to match.
     * </p>
     * <p>
     * In EventBridge, you could create rules that lead to infinite loops, where a rule is fired repeatedly. For
     * example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the
     * desired state. If you don't write the rule carefully, the subsequent change to the ACLs fires the rule again,
     * creating an infinite loop.
     * </p>
     * <p>
     * To prevent this, write the rules so that the triggered actions don't refire the same rule. For example, your rule
     * could fire only if ACLs are found to be in a bad state, instead of after any change.
     * </p>
     * <p>
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which
     * alerts you when charges exceed your specified limit. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your
     * Costs with Budgets</a>.
     * </p>
     *
     * @param putRuleRequest
     * @return Result of the PutRule operation returned by the service.
     * @throws InvalidEventPatternException
     *         The event pattern isn't valid.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRuleResponse putRule(PutRuleRequest putRuleRequest) throws InvalidEventPatternException, LimitExceededException,
            ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the specified rule. Rules are enabled by default or based on value of the state. You can
     * disable a rule using <a>DisableRule</a>.
     * </p>
     * <p>
     * A single rule watches for events from a single event bus. Events generated by AWS services go to your account's
     * default event bus. Events generated by SaaS partner services or applications go to the matching partner event
     * bus. If you have custom applications or services, you can specify whether their events go to your default event
     * bus or a custom event bus that you have created. For more information, see <a>CreateEventBus</a>.
     * </p>
     * <p>
     * If you're updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code>
     * command. If you omit arguments in <code>PutRule</code>, the old values for those arguments aren't kept. Instead,
     * they're replaced with null values.
     * </p>
     * <p>
     * When you create or update a rule, incoming events might not immediately start matching to new or updated rules.
     * Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * A rule must contain at least an <code>EventPattern</code> or <code>ScheduleExpression</code>. Rules with
     * <code>EventPatterns</code> are triggered when a matching event is observed. Rules with
     * <code>ScheduleExpressions</code> self-trigger based on the given schedule. A rule can have both an
     * <code>EventPattern</code> and a <code>ScheduleExpression</code>, in which case the rule triggers on matching
     * events as well as on a schedule.
     * </p>
     * <p>
     * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions, by granting a user
     * permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and
     * assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.
     * </p>
     * <p>
     * If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To
     * update the tags of an existing rule, use <a>TagResource</a> and <a>UntagResource</a>.
     * </p>
     * <p>
     * Most services in AWS treat <code>:</code> or <code>/</code> as the same character in Amazon Resource Names
     * (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN
     * characters when creating event patterns so that they match the ARN syntax in the event that you want to match.
     * </p>
     * <p>
     * In EventBridge, you could create rules that lead to infinite loops, where a rule is fired repeatedly. For
     * example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the
     * desired state. If you don't write the rule carefully, the subsequent change to the ACLs fires the rule again,
     * creating an infinite loop.
     * </p>
     * <p>
     * To prevent this, write the rules so that the triggered actions don't refire the same rule. For example, your rule
     * could fire only if ACLs are found to be in a bad state, instead of after any change.
     * </p>
     * <p>
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which
     * alerts you when charges exceed your specified limit. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your
     * Costs with Budgets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuleRequest.Builder} avoiding the need to create
     * one manually via {@link PutRuleRequest#builder()}
     * </p>
     *
     * @param putRuleRequest
     *        A {@link Consumer} that will call methods on {@link PutRuleRequest.Builder} to create a request.
     * @return Result of the PutRule operation returned by the service.
     * @throws InvalidEventPatternException
     *         The event pattern isn't valid.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRuleResponse putRule(Consumer<PutRuleRequest.Builder> putRuleRequest) throws InvalidEventPatternException,
            LimitExceededException, ConcurrentModificationException, ManagedRuleException, InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return putRule(PutRuleRequest.builder().applyMutation(putRuleRequest).build());
    }

    /**
     * <p>
     * Adds the specified targets to the specified rule, or updates the targets if they're already associated with the
     * rule.
     * </p>
     * <p>
     * Targets are the resources that are invoked when a rule is triggered.
     * </p>
     * <p>
     * You can configure the following as targets in EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * EC2 instances
     * </p>
     * </li>
     * <li>
     * <p>
     * SSM Run Command
     * </p>
     * </li>
     * <li>
     * <p>
     * SSM Automation
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Lambda functions
     * </p>
     * </li>
     * <li>
     * <p>
     * Data streams in Amazon Kinesis Data Streams
     * </p>
     * </li>
     * <li>
     * <p>
     * Data delivery streams in Amazon Kinesis Data Firehose
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS tasks
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Step Functions state machines
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Batch jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS CodeBuild projects
     * </p>
     * </li>
     * <li>
     * <p>
     * Pipelines in AWS CodePipeline
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Inspector assessment templates
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SNS topics
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SQS queues, including FIFO queues
     * </p>
     * </li>
     * <li>
     * <p>
     * The default event bus of another AWS account
     * </p>
     * </li>
     * </ul>
     * <p>
     * Creating rules with built-in targets is supported only on the AWS Management Console. The built-in targets are
     * <code>EC2 CreateSnapshot API call</code>, <code>EC2 RebootInstances API call</code>,
     * <code>EC2 StopInstances API call</code>, and <code>EC2 TerminateInstances API call</code>.
     * </p>
     * <p>
     * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis
     * data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code>
     * argument. To invoke a command on multiple EC2 instances with one rule, you can use the
     * <code>RunCommandParameters</code> field.
     * </p>
     * <p>
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate
     * permissions. For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2
     * instances, Kinesis data streams, and AWS Step Functions state machines, EventBridge relies on IAM roles that you
     * specify in the <code>RoleARN</code> argument in <code>PutTargets</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html"
     * >Authentication and Access Control</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * If another AWS account is in the same Region and has granted you permission (using <code>PutPermission</code>),
     * you can send events to that account. Set that account's event bus as a target of the rules in your account. To
     * send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when
     * you run <code>PutTargets</code>. If your account sends events to another account, your account is charged for
     * each sent event. Each event sent to another account is charged as a custom event. The account receiving the event
     * isn't charged. For more information, see <a href="https://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge
     * Pricing</a>.
     * </p>
     * <p>
     * If you're setting an event bus in another account as the target and that account granted permission to your
     * account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code>
     * with proper permissions in the <code>Target</code> structure. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between AWS Accounts</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * For more information about enabling cross-account events, see <a>PutPermission</a>.
     * </p>
     * <p>
     * <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are mutually exclusive and optional
     * parameters of a target. When a rule is triggered due to a matched event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If none of the following arguments are specified for a target, the entire event is passed to the target in JSON
     * format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is
     * passed to the target).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>Input</code> is specified in the form of valid JSON, then the matched event is overridden with this
     * constant.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>InputPath</code> is specified in the form of JSONPath (for example, <code>&#36.detail</code>), only the
     * part of the event specified in the path is passed to the target (for example, only the detail part of the event
     * is passed).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>InputTransformer</code> is specified, one or more specified JSONPaths are extracted from the event and
     * used as values in a template that you specify as the input to the target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not
     * bracket notation.
     * </p>
     * <p>
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be
     * immediately invoked. Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is nonzero in the response, and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     *
     * @param putTargetsRequest
     * @return Result of the PutTargets operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTargetsResponse putTargets(PutTargetsRequest putTargetsRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, LimitExceededException, ManagedRuleException, InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified targets to the specified rule, or updates the targets if they're already associated with the
     * rule.
     * </p>
     * <p>
     * Targets are the resources that are invoked when a rule is triggered.
     * </p>
     * <p>
     * You can configure the following as targets in EventBridge:
     * </p>
     * <ul>
     * <li>
     * <p>
     * EC2 instances
     * </p>
     * </li>
     * <li>
     * <p>
     * SSM Run Command
     * </p>
     * </li>
     * <li>
     * <p>
     * SSM Automation
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Lambda functions
     * </p>
     * </li>
     * <li>
     * <p>
     * Data streams in Amazon Kinesis Data Streams
     * </p>
     * </li>
     * <li>
     * <p>
     * Data delivery streams in Amazon Kinesis Data Firehose
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS tasks
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Step Functions state machines
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Batch jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS CodeBuild projects
     * </p>
     * </li>
     * <li>
     * <p>
     * Pipelines in AWS CodePipeline
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Inspector assessment templates
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SNS topics
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SQS queues, including FIFO queues
     * </p>
     * </li>
     * <li>
     * <p>
     * The default event bus of another AWS account
     * </p>
     * </li>
     * </ul>
     * <p>
     * Creating rules with built-in targets is supported only on the AWS Management Console. The built-in targets are
     * <code>EC2 CreateSnapshot API call</code>, <code>EC2 RebootInstances API call</code>,
     * <code>EC2 StopInstances API call</code>, and <code>EC2 TerminateInstances API call</code>.
     * </p>
     * <p>
     * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis
     * data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code>
     * argument. To invoke a command on multiple EC2 instances with one rule, you can use the
     * <code>RunCommandParameters</code> field.
     * </p>
     * <p>
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate
     * permissions. For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2
     * instances, Kinesis data streams, and AWS Step Functions state machines, EventBridge relies on IAM roles that you
     * specify in the <code>RoleARN</code> argument in <code>PutTargets</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html"
     * >Authentication and Access Control</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * If another AWS account is in the same Region and has granted you permission (using <code>PutPermission</code>),
     * you can send events to that account. Set that account's event bus as a target of the rules in your account. To
     * send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when
     * you run <code>PutTargets</code>. If your account sends events to another account, your account is charged for
     * each sent event. Each event sent to another account is charged as a custom event. The account receiving the event
     * isn't charged. For more information, see <a href="https://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge
     * Pricing</a>.
     * </p>
     * <p>
     * If you're setting an event bus in another account as the target and that account granted permission to your
     * account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code>
     * with proper permissions in the <code>Target</code> structure. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between AWS Accounts</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * For more information about enabling cross-account events, see <a>PutPermission</a>.
     * </p>
     * <p>
     * <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are mutually exclusive and optional
     * parameters of a target. When a rule is triggered due to a matched event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If none of the following arguments are specified for a target, the entire event is passed to the target in JSON
     * format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is
     * passed to the target).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>Input</code> is specified in the form of valid JSON, then the matched event is overridden with this
     * constant.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>InputPath</code> is specified in the form of JSONPath (for example, <code>&#36.detail</code>), only the
     * part of the event specified in the path is passed to the target (for example, only the detail part of the event
     * is passed).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>InputTransformer</code> is specified, one or more specified JSONPaths are extracted from the event and
     * used as values in a template that you specify as the input to the target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not
     * bracket notation.
     * </p>
     * <p>
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be
     * immediately invoked. Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is nonzero in the response, and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link PutTargetsRequest#builder()}
     * </p>
     *
     * @param putTargetsRequest
     *        A {@link Consumer} that will call methods on {@link PutTargetsRequest.Builder} to create a request.
     * @return Result of the PutTargets operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws LimitExceededException
     *         You tried to create more resources than is allowed.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.PutTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTargetsResponse putTargets(Consumer<PutTargetsRequest.Builder> putTargetsRequest)
            throws ResourceNotFoundException, ConcurrentModificationException, LimitExceededException, ManagedRuleException,
            InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        return putTargets(PutTargetsRequest.builder().applyMutation(putTargetsRequest).build());
    }

    /**
     * <p>
     * Revokes the permission of another AWS account to be able to put events to the specified event bus. Specify the
     * account to revoke by the <code>StatementId</code> value that you associated with the account when you granted it
     * permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by using
     * <a>DescribeEventBus</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest)
            throws ResourceNotFoundException, InternalException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes the permission of another AWS account to be able to put events to the specified event bus. Specify the
     * account to revoke by the <code>StatementId</code> value that you associated with the account when you granted it
     * permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by using
     * <a>DescribeEventBus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemovePermissionRequest.Builder} to create a request.
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(Consumer<RemovePermissionRequest.Builder> removePermissionRequest)
            throws ResourceNotFoundException, InternalException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, CloudWatchEventsException {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be
     * invoked.
     * </p>
     * <p>
     * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow
     * a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     *
     * @param removeTargetsRequest
     * @return Result of the RemoveTargets operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.RemoveTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveTargetsResponse removeTargets(RemoveTargetsRequest removeTargetsRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be
     * invoked.
     * </p>
     * <p>
     * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow
     * a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTargetsRequest#builder()}
     * </p>
     *
     * @param removeTargetsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTargetsRequest.Builder} to create a request.
     * @return Result of the RemoveTargets operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.RemoveTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveTargetsResponse removeTargets(Consumer<RemoveTargetsRequest.Builder> removeTargetsRequest)
            throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return removeTargets(RemoveTargetsRequest.builder().applyMutation(removeTargetsRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions by granting a user permission to
     * access or change only resources with certain tag values. In EventBridge, rules can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a rule that already has tags. If you specify a new tag key
     * for the rule, this tag is appended to the list of tags associated with the rule. If you specify a tag key that is
     * already associated with the rule, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, InternalException, ManagedRuleException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions by granting a user permission to
     * access or change only resources with certain tag values. In EventBridge, rules can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a rule that already has tags. If you specify a new tag key
     * for the rule, this tag is appended to the list of tags associated with the rule. If you specify a tag key that is
     * already associated with the rule, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ConcurrentModificationException, InternalException, ManagedRuleException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests whether the specified event pattern matches the provided event.
     * </p>
     * <p>
     * Most services in AWS treat <code>:</code> or <code>/</code> as the same character in Amazon Resource Names
     * (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN
     * characters when creating event patterns so that they match the ARN syntax in the event that you want to match.
     * </p>
     *
     * @param testEventPatternRequest
     * @return Result of the TestEventPattern operation returned by the service.
     * @throws InvalidEventPatternException
     *         The event pattern isn't valid.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.TestEventPattern
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern" target="_top">AWS API
     *      Documentation</a>
     */
    default TestEventPatternResponse testEventPattern(TestEventPatternRequest testEventPatternRequest)
            throws InvalidEventPatternException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests whether the specified event pattern matches the provided event.
     * </p>
     * <p>
     * Most services in AWS treat <code>:</code> or <code>/</code> as the same character in Amazon Resource Names
     * (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN
     * characters when creating event patterns so that they match the ARN syntax in the event that you want to match.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestEventPatternRequest.Builder} avoiding the need
     * to create one manually via {@link TestEventPatternRequest#builder()}
     * </p>
     *
     * @param testEventPatternRequest
     *        A {@link Consumer} that will call methods on {@link TestEventPatternRequest.Builder} to create a request.
     * @return Result of the TestEventPattern operation returned by the service.
     * @throws InvalidEventPatternException
     *         The event pattern isn't valid.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.TestEventPattern
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern" target="_top">AWS API
     *      Documentation</a>
     */
    default TestEventPatternResponse testEventPattern(Consumer<TestEventPatternRequest.Builder> testEventPatternRequest)
            throws InvalidEventPatternException, InternalException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        return testEventPattern(TestEventPatternRequest.builder().applyMutation(testEventPatternRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge resource. In EventBridge, rules can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalException, ConcurrentModificationException, ManagedRuleException, AwsServiceException, SdkClientException,
            CloudWatchEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge resource. In EventBridge, rules can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         An entity that you specified doesn't exist.
     * @throws InternalException
     *         This exception occurs due to unexpected causes.
     * @throws ConcurrentModificationException
     *         There is concurrent modification on a resource.
     * @throws ManagedRuleException
     *         An AWS service created this rule on behalf of your account. That service manages it. If you see this
     *         error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the
     *         <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You can't
     *         modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>,
     *         <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchEventsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalException, ConcurrentModificationException, ManagedRuleException,
            AwsServiceException, SdkClientException, CloudWatchEventsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("events");
    }
}
