/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPermissionRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<PutPermissionRequest.Builder, PutPermissionRequest> {
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::eventBusName)).setter(setter(Builder::eventBusName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()).build();

    private static final SdkField<Condition> CONDITION_FIELD = SdkField.<Condition> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutPermissionRequest::condition)).setter(setter(Builder::condition)).constructor(Condition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUS_NAME_FIELD,
            ACTION_FIELD, PRINCIPAL_FIELD, STATEMENT_ID_FIELD, CONDITION_FIELD));

    private final String eventBusName;

    private final String action;

    private final String principal;

    private final String statementId;

    private final Condition condition;

    private PutPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.eventBusName = builder.eventBusName;
        this.action = builder.action;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     * 
     * @return The event bus associated with the rule. If you omit this, the default event bus is used.
     */
    public String eventBusName() {
        return eventBusName;
    }

    /**
     * <p>
     * The action that you're enabling the other account to perform. Currently, this must be
     * <code>events:PutEvents</code>.
     * </p>
     * 
     * @return The action that you're enabling the other account to perform. Currently, this must be
     *         <code>events:PutEvents</code>.
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*" to
     * permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that might match undesirable
     * events. To create more secure rules, make sure that the event pattern for each rule contains an
     * <code>account</code> field with a specific account ID to receive events from. Rules with an account field don't
     * match any events sent from other accounts.
     * </p>
     * 
     * @return The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*"
     *         to permit any account to put events to your default event bus.</p>
     *         <p>
     *         If you specify "*" without specifying <code>Condition</code>, avoid creating rules that might match
     *         undesirable events. To create more secure rules, make sure that the event pattern for each rule contains
     *         an <code>account</code> field with a specific account ID to receive events from. Rules with an account
     *         field don't match any events sent from other accounts.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * An identifier string for the external account that you're granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run
     * <a>RemovePermission</a>.
     * </p>
     * 
     * @return An identifier string for the external account that you're granting permissions to. If you later want to
     *         revoke the permission for this external account, specify this <code>StatementId</code> when you run
     *         <a>RemovePermission</a>.
     */
    public String statementId() {
        return statementId;
    }

    /**
     * <p>
     * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a
     * member of a certain AWS organization. For more information about AWS Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS
     * Organizations?</a> in the <i>AWS Organizations User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>Condition</code> with an AWS organization ID and specify "*" as the value for
     * <code>Principal</code>, you grant permission to all the accounts in the named organization.
     * </p>
     * <p>
     * The <code>Condition</code> is a JSON string that must contain <code>Type</code>, <code>Key</code>, and
     * <code>Value</code> fields.
     * </p>
     * 
     * @return This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
     *         being a member of a certain AWS organization. For more information about AWS Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS
     *         Organizations?</a> in the <i>AWS Organizations User Guide</i>.</p>
     *         <p>
     *         If you specify <code>Condition</code> with an AWS organization ID and specify "*" as the value for
     *         <code>Principal</code>, you grant permission to all the accounts in the named organization.
     *         </p>
     *         <p>
     *         The <code>Condition</code> is a JSON string that must contain <code>Type</code>, <code>Key</code>, and
     *         <code>Value</code> fields.
     */
    public Condition condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPermissionRequest)) {
            return false;
        }
        PutPermissionRequest other = (PutPermissionRequest) obj;
        return Objects.equals(eventBusName(), other.eventBusName()) && Objects.equals(action(), other.action())
                && Objects.equals(principal(), other.principal()) && Objects.equals(statementId(), other.statementId())
                && Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPermissionRequest").add("EventBusName", eventBusName()).add("Action", action())
                .add("Principal", principal()).add("StatementId", statementId()).add("Condition", condition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBusName":
            return Optional.ofNullable(clazz.cast(eventBusName()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPermissionRequest, T> g) {
        return obj -> g.apply((PutPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPermissionRequest> {
        /**
         * <p>
         * The event bus associated with the rule. If you omit this, the default event bus is used.
         * </p>
         * 
         * @param eventBusName
         *        The event bus associated with the rule. If you omit this, the default event bus is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusName(String eventBusName);

        /**
         * <p>
         * The action that you're enabling the other account to perform. Currently, this must be
         * <code>events:PutEvents</code>.
         * </p>
         * 
         * @param action
         *        The action that you're enabling the other account to perform. Currently, this must be
         *        <code>events:PutEvents</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*" to
         * permit any account to put events to your default event bus.
         * </p>
         * <p>
         * If you specify "*" without specifying <code>Condition</code>, avoid creating rules that might match
         * undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an
         * <code>account</code> field with a specific account ID to receive events from. Rules with an account field
         * don't match any events sent from other accounts.
         * </p>
         * 
         * @param principal
         *        The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify
         *        "*" to permit any account to put events to your default event bus.</p>
         *        <p>
         *        If you specify "*" without specifying <code>Condition</code>, avoid creating rules that might match
         *        undesirable events. To create more secure rules, make sure that the event pattern for each rule
         *        contains an <code>account</code> field with a specific account ID to receive events from. Rules with
         *        an account field don't match any events sent from other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * An identifier string for the external account that you're granting permissions to. If you later want to
         * revoke the permission for this external account, specify this <code>StatementId</code> when you run
         * <a>RemovePermission</a>.
         * </p>
         * 
         * @param statementId
         *        An identifier string for the external account that you're granting permissions to. If you later want
         *        to revoke the permission for this external account, specify this <code>StatementId</code> when you run
         *        <a>RemovePermission</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
         * being a member of a certain AWS organization. For more information about AWS Organizations, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS
         * Organizations?</a> in the <i>AWS Organizations User Guide</i>.
         * </p>
         * <p>
         * If you specify <code>Condition</code> with an AWS organization ID and specify "*" as the value for
         * <code>Principal</code>, you grant permission to all the accounts in the named organization.
         * </p>
         * <p>
         * The <code>Condition</code> is a JSON string that must contain <code>Type</code>, <code>Key</code>, and
         * <code>Value</code> fields.
         * </p>
         * 
         * @param condition
         *        This parameter enables you to limit the permission to accounts that fulfill a certain condition, such
         *        as being a member of a certain AWS organization. For more information about AWS Organizations, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS
         *        Organizations?</a> in the <i>AWS Organizations User Guide</i>.</p>
         *        <p>
         *        If you specify <code>Condition</code> with an AWS organization ID and specify "*" as the value for
         *        <code>Principal</code>, you grant permission to all the accounts in the named organization.
         *        </p>
         *        <p>
         *        The <code>Condition</code> is a JSON string that must contain <code>Type</code>, <code>Key</code>, and
         *        <code>Value</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * <p>
         * This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as
         * being a member of a certain AWS organization. For more information about AWS Organizations, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is AWS
         * Organizations?</a> in the <i>AWS Organizations User Guide</i>.
         * </p>
         * <p>
         * If you specify <code>Condition</code> with an AWS organization ID and specify "*" as the value for
         * <code>Principal</code>, you grant permission to all the accounts in the named organization.
         * </p>
         * <p>
         * The <code>Condition</code> is a JSON string that must contain <code>Type</code>, <code>Key</code>, and
         * <code>Value</code> fields.
         * </p>
         * This is a convenience that creates an instance of the {@link Condition.Builder} avoiding the need to create
         * one manually via {@link Condition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().applyMutation(condition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String eventBusName;

        private String action;

        private String principal;

        private String statementId;

        private Condition condition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPermissionRequest model) {
            super(model);
            eventBusName(model.eventBusName);
            action(model.action);
            principal(model.principal);
            statementId(model.statementId);
            condition(model.condition);
        }

        public final String getEventBusName() {
            return eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPermissionRequest build() {
            return new PutPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
